/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.jsr198.prefs;

import java.net.URL;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.ide.editor.Editor;
import oracle.ide.ExtensionRegistry;
import oracle.ide.config.ClientSetting;
import oracle.ide.net.URLFactory;
import oracle.ide.util.Namespace;
import oracle.ideimpl.jsr198.prefs.HashStructurePreferences;
import oracle.ideimpl.jsr198.prefs.HashStructurePreferencesRoot;
import oracle.ideimpl.jsr198.prefs.JSR198Preferences;
import oracle.javatools.data.PropertyStorage;

public final class JavaxIdePreferences {
    private static HashStructurePreferencesRoot _root = null;
    private static final String EDITOR_PATH = "editorprefs";
    public static final String JSR198_KEY = "jsr198";

    private JavaxIdePreferences() {
    }

    private static Preferences getRootPreferences() throws BackingStoreException {
        if (_root == null) {
            URL uRL = URLFactory.newURL(ExtensionRegistry.getOracleRegistry().getSystemDirectory("oracle.ide"), "jsr198prefs.xml");
            _root = new HashStructurePreferencesRoot(uRL);
            _root.sync();
        }
        return _root;
    }

    public static Preferences getEditorPreferences(Editor editor) throws BackingStoreException {
        return JavaxIdePreferences.getRootPreferences().node("editorprefs/" + editor.getClass().getName());
    }

    public static Preferences getPreferences(Namespace namespace) {
        JSR198Preferences jSR198Preferences = (JSR198Preferences)namespace.find(JSR198_KEY);
        return JavaxIdePreferences.toPreferences(jSR198Preferences);
    }

    public static Preferences getPreferences() {
        ClientSetting clientSetting = ClientSetting.findOrCreate("oracle.ide");
        JSR198Preferences jSR198Preferences = (JSR198Preferences)clientSetting.getData(JSR198_KEY);
        if (jSR198Preferences == null) {
            jSR198Preferences = new JSR198Preferences();
            clientSetting.putData(JSR198_KEY, jSR198Preferences);
        }
        return JavaxIdePreferences.toPreferences(jSR198Preferences);
    }

    public static Preferences getPreferences(PropertyStorage propertyStorage) {
        return new HashStructurePreferences(null, "", propertyStorage.getProperties());
    }

    private static Preferences toPreferences(JSR198Preferences jSR198Preferences) {
        return new HashStructurePreferences(null, "", jSR198Preferences.getHashStructure());
    }
}

