/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.jsr198.view;

import java.awt.Component;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.ide.net.URIFactory;
import javax.ide.net.VirtualFileSystem;
import javax.ide.view.GUIPanel;
import javax.ide.view.URISelectionDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ideimpl.jsr198.model.ContextFactory;

final class OracleURIChooser
implements URISelectionDialog {
    private final String _title;
    private final GUIPanel _parent;
    private final Context _oideContext;
    private final javax.ide.command.Context _javaxContext;
    private URL _location;
    private URLChooser _delegate;
    private final boolean _directories;

    public OracleURIChooser(boolean bl, String string, URI uRI, javax.ide.command.Context context, GUIPanel gUIPanel) {
        this._directories = bl;
        this._title = string;
        this._parent = gUIPanel;
        this._javaxContext = context;
        this._oideContext = ContextFactory.createOracleContext(context);
        try {
            this._location = uRI == null ? null : VirtualFileSystem.getVirtualFileSystem().toURL(uRI);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            this._location = null;
        }
    }

    private void createDelegate(URISelectionDialog.Validator validator) {
        if (validator == null) {
            this._delegate = DialogUtil.newURLChooser(this._oideContext, this._location);
        } else {
            this._delegate = new 1(this, this._location, validator);
            DialogUtil.initURLChooser(this._delegate, this._oideContext);
        }
        this._delegate.setSelectionScope(this._directories ? 1 : 2);
    }

    public int show() {
        return this.show(null);
    }

    public int show(URISelectionDialog.Validator validator) {
        this.createDelegate(validator);
        int n = this._delegate.showOpenDialog((Component)(this._parent == null ? Ide.getMainWindow() : (Component)this._parent.getRootComponent()), this._title);
        return n == 0 ? 0 : 3;
    }

    public URI[] getResults() {
        if (this._delegate == null) {
            throw new IllegalStateException("Dialog not yet shown.");
        }
        URL[] uRLArray = this._delegate.getSelectedURLs();
        if (uRLArray == null) {
            return null;
        }
        URI[] uRIArray = new URI[uRLArray.length];
        int n = 0;
        while (n < uRLArray.length) {
            URL uRL = uRLArray[n];
            uRIArray[n] = URIFactory.newURI((URL)uRL);
            ++n;
        }
        return uRIArray;
    }

    static javax.ide.command.Context ra$_javaxContext(OracleURIChooser oracleURIChooser) {
        return oracleURIChooser._javaxContext;
    }

    final class 1
    extends URLChooser {
        private final /* synthetic */ URISelectionDialog.Validator v$validator;
        final /* synthetic */ OracleURIChooser this$0;

        public boolean approveSelection() {
            if (super.approveSelection()) {
                return this.v$validator.validate(this.this$0.getResults(), OracleURIChooser.ra$_javaxContext(this.this$0));
            }
            return false;
        }

        public 1(OracleURIChooser oracleURIChooser, URL uRL, URISelectionDialog.Validator validator) {
            this.v$validator = validator;
            this.this$0 = oracleURIChooser;
            super(uRL);
        }
    }
}

