/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.layout;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import oracle.ide.ExtensionRegistry;
import oracle.ide.layout.Layouts;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ideimpl.docking.VisibilityLayout;
import org.xml.sax.SAXException;

public class LayoutsImpl
extends Layouts {
    static final String LAYOUT_FILE_NAME = "windowinglayout.xml";
    private static final String LAYOUT_ROOT_TAG = "LayoutInfo";
    private static LayoutsImpl INSTANCE;
    private DefaultStructuredPropertyAccess _layoutInfo;
    private HashMap _visibilityLayouts;
    private static final String KEY_KNOWN_DOCKABLE_FACTORIES = "knownDockableFactories";
    private static final String KEY_DOCKABLE_POSITIONS = "dockingPositions";
    private static final String KEY_VISIBILITY_LAYOUT = "visibilityLayouts";

    void $init$() {
        this._visibilityLayouts = new HashMap();
    }

    private LayoutsImpl() {
        this.$init$();
    }

    public static LayoutsImpl createInstance() {
        INSTANCE = new LayoutsImpl();
        return LayoutsImpl.getInstance();
    }

    public static LayoutsImpl getInstance() {
        return INSTANCE;
    }

    private DefaultStructuredPropertyAccess getLayoutInfo() {
        if (this._layoutInfo == null) {
            this.loadLayoutInfo();
        }
        return this._layoutInfo;
    }

    public boolean hasLayoutInfo(String string) {
        boolean bl = false;
        DefaultStructuredPropertyAccess defaultStructuredPropertyAccess = this.getLayoutInfo();
        if (defaultStructuredPropertyAccess.hasChildNodes()) {
            Iterator iterator = defaultStructuredPropertyAccess.getChildNodes(string);
            bl = iterator.hasNext();
        }
        return bl;
    }

    public StructuredPropertyAccess getLayoutInfo(String string) {
        StructuredPropertyAccess structuredPropertyAccess = this.getLayoutInfo().getChildNode(string);
        return structuredPropertyAccess;
    }

    public void setLayoutInfo(StructuredPropertyAccess structuredPropertyAccess) {
        String string = structuredPropertyAccess.getName();
        StructuredPropertyAccess structuredPropertyAccess2 = this.getLayoutInfo(string);
        DefaultStructuredPropertyAccess defaultStructuredPropertyAccess = this.getLayoutInfo();
        if (structuredPropertyAccess2 != null) {
            defaultStructuredPropertyAccess.removeChild(structuredPropertyAccess2);
        }
        defaultStructuredPropertyAccess.appendChild(structuredPropertyAccess);
    }

    private void loadLayoutInfo() {
        File file = this.getLayoutFile();
        if (file.exists()) {
            try {
                this._layoutInfo = DefaultStructuredPropertyAccess.loadFromXML(file);
                this.loadVisibility();
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (this._layoutInfo == null) {
            this._layoutInfo = new DefaultStructuredPropertyAccess(LAYOUT_ROOT_TAG);
        }
    }

    public void saveLayoutInfo() {
        File file = this.getLayoutFile();
        try {
            DefaultStructuredPropertyAccess defaultStructuredPropertyAccess = this.getLayoutInfo();
            DefaultStructuredPropertyAccess.saveToXML(defaultStructuredPropertyAccess, file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private File getLayoutFile() {
        URL uRL = ExtensionRegistry.getOracleRegistry().getSystemDirectory("oracle.ide");
        File file = new File(uRL.getPath(), LAYOUT_FILE_NAME);
        return file;
    }

    public void saveAll() {
        super.saveAll();
        this.saveVisibility();
        this.saveLayoutInfo();
    }

    private void saveVisibility() {
        DefaultStructuredPropertyAccess defaultStructuredPropertyAccess = new DefaultStructuredPropertyAccess(KEY_VISIBILITY_LAYOUT);
        Set set = this._visibilityLayouts.keySet();
        for (String string : set) {
            VisibilityLayout visibilityLayout = (VisibilityLayout)this._visibilityLayouts.get(string);
            StructuredPropertyAccess structuredPropertyAccess = visibilityLayout.save();
            defaultStructuredPropertyAccess.appendChild(structuredPropertyAccess);
        }
        DefaultStructuredPropertyAccess defaultStructuredPropertyAccess2 = this.getLayoutInfo();
        StructuredPropertyAccess structuredPropertyAccess = defaultStructuredPropertyAccess2.getChildNode(KEY_VISIBILITY_LAYOUT);
        if (structuredPropertyAccess != null) {
            defaultStructuredPropertyAccess2.removeChild(structuredPropertyAccess);
        }
        this.getLayoutInfo().appendChild(defaultStructuredPropertyAccess);
    }

    private void loadVisibility() {
        StructuredPropertyAccess structuredPropertyAccess = this.getLayoutInfo(KEY_VISIBILITY_LAYOUT);
        if (structuredPropertyAccess != null) {
            Iterator iterator = structuredPropertyAccess.getChildNodes();
            while (iterator.hasNext()) {
                StructuredPropertyAccess structuredPropertyAccess2 = (StructuredPropertyAccess)iterator.next();
                VisibilityLayout visibilityLayout = VisibilityLayout.load(structuredPropertyAccess2);
                String string = structuredPropertyAccess2.getName();
                this._visibilityLayouts.put(string, visibilityLayout);
            }
        }
    }

    public boolean hasDockableFactoryNode() {
        return this.hasLayoutInfo(KEY_KNOWN_DOCKABLE_FACTORIES);
    }

    public String[] getKnownDockableFactories() {
        ArrayList<String> arrayList = new ArrayList<String>();
        StructuredPropertyAccess structuredPropertyAccess = this.getLayoutInfo(KEY_KNOWN_DOCKABLE_FACTORIES);
        if (structuredPropertyAccess != null) {
            Iterator iterator = structuredPropertyAccess.getChildNodes();
            while (iterator.hasNext()) {
                StructuredPropertyAccess structuredPropertyAccess2 = (StructuredPropertyAccess)iterator.next();
                String string = structuredPropertyAccess2.getName();
                arrayList.add(string);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void setKnownDockableFactories(String[] stringArray) {
        DefaultStructuredPropertyAccess defaultStructuredPropertyAccess = new DefaultStructuredPropertyAccess(KEY_KNOWN_DOCKABLE_FACTORIES);
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            DefaultStructuredPropertyAccess defaultStructuredPropertyAccess2 = new DefaultStructuredPropertyAccess(string);
            defaultStructuredPropertyAccess.appendChild(defaultStructuredPropertyAccess2);
            ++n;
        }
        StructuredPropertyAccess structuredPropertyAccess = this.getLayoutInfo(KEY_KNOWN_DOCKABLE_FACTORIES);
        if (structuredPropertyAccess != null) {
            this.getLayoutInfo().removeChild(structuredPropertyAccess);
        }
        this.getLayoutInfo().appendChild(defaultStructuredPropertyAccess);
    }

    public StructuredPropertyAccess getDockablePositions() {
        StructuredPropertyAccess structuredPropertyAccess = null;
        structuredPropertyAccess = this.getLayoutInfo(KEY_DOCKABLE_POSITIONS);
        return structuredPropertyAccess;
    }

    public void setDockablePositions(StructuredPropertyAccess structuredPropertyAccess) {
        StructuredPropertyAccess structuredPropertyAccess2 = this.getDockablePositions();
        if (structuredPropertyAccess2 != null) {
            this.getLayoutInfo().removeChild(structuredPropertyAccess2);
        }
        structuredPropertyAccess.setName(KEY_DOCKABLE_POSITIONS);
        this.getLayoutInfo().appendChild(structuredPropertyAccess);
    }

    public VisibilityLayout getVisibilityLayout(String string) {
        String string2 = string.replace(' ', '_');
        VisibilityLayout visibilityLayout = (VisibilityLayout)this._visibilityLayouts.get(string2);
        if (visibilityLayout == null) {
            visibilityLayout = new VisibilityLayout(string2, string);
            this._visibilityLayouts.put(string2, visibilityLayout);
        }
        return visibilityLayout;
    }
}

