/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.layout;

import java.io.File;
import oracle.ide.migration.Migrator;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ideimpl.resource.IdeImplArb;

public final class LayoutsMigrator
implements Migrator {
    private static final int LAYOUT_CATEGORY = 0;
    boolean _selected;

    void $init$() {
        this._selected = true;
    }

    public int[] getMigrationCategories() {
        return new int[]{0};
    }

    public String getDescription(int n) {
        switch (n) {
            case 0: {
                return IdeImplArb.getString(95);
            }
        }
        return null;
    }

    public boolean canMigrate(int n, File file) {
        File file2;
        return n == 0 && file != null && file.exists() && (file2 = LayoutsMigrator.getLayoutsFile(file)).exists() && file2.canRead();
    }

    public void setSelected(int n, boolean bl) {
        if (n == 0) {
            this._selected = bl;
        }
    }

    public boolean isSelected(int n) {
        return n == 0 ? this._selected : false;
    }

    public String[] migrate(File file, File file2) {
        String string;
        if (!this._selected) {
            return null;
        }
        File file3 = LayoutsMigrator.getLayoutsFile(file);
        if (file3.exists() && (string = file.getName()) != null && string.startsWith("oracle.ide.")) {
            DefaultStructuredPropertyAccess defaultStructuredPropertyAccess = null;
            try {
                StructuredPropertyAccess structuredPropertyAccess;
                defaultStructuredPropertyAccess = DefaultStructuredPropertyAccess.loadFromXML(file3);
                StructuredPropertyAccess structuredPropertyAccess2 = structuredPropertyAccess = defaultStructuredPropertyAccess != null ? defaultStructuredPropertyAccess.getChildNode("editorPositions") : null;
                if (structuredPropertyAccess != null) {
                    defaultStructuredPropertyAccess.removeChild(structuredPropertyAccess);
                }
                structuredPropertyAccess = defaultStructuredPropertyAccess != null ? defaultStructuredPropertyAccess.getChildNode("dockingPositions") : null;
            }
            catch (Exception exception) {
                String[] stringArray = new String[]{exception.getLocalizedMessage()};
                return stringArray;
            }
            File file4 = LayoutsMigrator.getLayoutsFile(file2);
            try {
                DefaultStructuredPropertyAccess.saveToXML(defaultStructuredPropertyAccess, file4);
            }
            catch (Exception exception) {
                String[] stringArray = new String[]{exception.getLocalizedMessage()};
                return stringArray;
            }
        }
        return null;
    }

    private static final File getLayoutsFile(File file) {
        return new File(file, "windowinglayout.xml");
    }

    public LayoutsMigrator() {
        this.$init$();
    }
}

