/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.log;

import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.EventObject;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogOwner;
import oracle.ide.log.LogPage;
import oracle.ide.log.LogWindow;
import oracle.ide.model.UpdateMessage;
import oracle.ide.resource.IdeArb;
import oracle.ide.resource.LogArb;
import oracle.ide.util.PropertyAccess;
import oracle.ide.view.View;
import oracle.ideimpl.log.TabbedPage;

public class LogWindowImpl
extends LogWindow {
    private static final String CLOSED_BY_USER = "ClosedByUser";
    private LogPage _page;
    private boolean _closed;

    protected LogWindowImpl(LogPage logPage) {
        super(logPage.getLogPageView().getId());
        this._page = logPage;
        logPage.setOwner(this);
        this.setType(32);
    }

    public ContextMenu getContextMenu() {
        ContextMenu contextMenu = LogManager.getLogManager().getContextMenu();
        return contextMenu;
    }

    public void clearAll() {
        this._page.clearAll();
    }

    public String getTabName() {
        return this._page.getTabName();
    }

    public Icon getTabIcon() {
        return IdeArb.getIcon(172);
    }

    public String getMenuTitle() {
        return IdeArb.getString(170);
    }

    public String getToolTip() {
        return this._page.getToolTip();
    }

    public void log(Object object) {
        this._page.log(object);
    }

    public String getTitleName() {
        return this._page.getTitleName() + " - " + LogArb.getString(0);
    }

    public void setOwner(LogOwner logOwner) {
    }

    public void addMouseListener(MouseListener mouseListener) {
    }

    public void removeMouseListener(MouseListener mouseListener) {
    }

    public View getLogPageView() {
        return this;
    }

    public LogPage getPage() {
        if (this._page != null && this._page instanceof TabbedPage) {
            return ((TabbedPage)this._page).getSelectedPage();
        }
        return this._page;
    }

    public Component getGUI() {
        return this._page.getLogPageView().getGUI();
    }

    public Context getContext(EventObject eventObject) {
        return this._page.getLogPageView().getContext(eventObject);
    }

    public Controller getController() {
        return LogManager.getLogManager();
    }

    public void updateVisibleActions(UpdateMessage updateMessage) {
        View view;
        super.updateVisibleActions(updateMessage);
        LogPage logPage = this.getPage();
        if (logPage != null && (view = logPage.getLogPageView()) != null) {
            view.updateVisibleActions(updateMessage);
        }
    }

    public void stateChange(int n) {
        super.stateChange(n);
        switch (n) {
            case 1: {
                this._closed = false;
                break;
            }
            case 3: {
                this._closed = true;
            }
        }
    }

    public void saveLayout(PropertyAccess propertyAccess) {
        Boolean bl = new Boolean(this._closed);
        propertyAccess.setProperty(CLOSED_BY_USER, bl.toString());
    }

    public void loadLayout(PropertyAccess propertyAccess) {
        String string = propertyAccess.getProperty(CLOSED_BY_USER, "false");
        this._closed = Boolean.valueOf(string);
    }

    public void selectPage(LogPage logPage) {
        logPage.getLogPageView().show();
    }

    public boolean isClosed() {
        return this._closed;
    }

    public void highlightPage(LogPage logPage) {
        LogOwner logOwner = (LogOwner)((Object)logPage.getLogPageView().owner());
        logOwner.highlightPage(logPage);
    }

    public View getLogOwnerView() {
        return this;
    }
}

