/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.log;

import java.awt.Component;
import java.net.URL;
import java.util.EventObject;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.customtab.CustomTabPage;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.DockUtil;
import oracle.ide.log.AbstractLogManager;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.log.LogRecognizer;
import oracle.ide.log.LogWindow;
import oracle.ide.log.MessagePage;
import oracle.ide.net.URLChooser;
import oracle.ide.resource.IdeArb;
import oracle.ide.resource.LogArb;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.IdeUtil;
import oracle.ideimpl.IdeMenus;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.ideimpl.log.LogDockableFactory;
import oracle.ideimpl.log.LogWindowImpl;
import oracle.ideimpl.log.TabbedPage;

public class TabbedLogManager
extends AbstractLogManager
implements Addin {
    private LogPage _msgPage;
    private LogWindowImpl _logWindow;
    private TabbedPage _tabbedPage;

    private TabbedLogManager() {
    }

    public void addPage(LogPage logPage) {
        this.getTabbedPage().addPage(logPage);
        super.addPage(logPage);
    }

    public void removePage(LogPage logPage) {
        if (this._tabbedPage != null) {
            this.closePage(logPage);
        }
    }

    public LogPage getMsgPage() {
        if (this._msgPage == null) {
            this._msgPage = new MessagePage();
            CustomTabPage customTabPage = this._tabbedPage.getTabPageForLogPage(this._msgPage);
            customTabPage.setCloseable(false);
        }
        return this._msgPage;
    }

    public LogWindow getLogWindow() {
        return this.getLogWindowImpl();
    }

    protected LogWindowImpl getLogWindowImpl() {
        if (this._logWindow == null) {
            this._tabbedPage = new TabbedPage();
            this._logWindow = new LogWindowImpl(this._tabbedPage);
            this.installMouseListener(this._tabbedPage);
        }
        return this._logWindow;
    }

    public boolean isLogVisible() {
        if (this._logWindow == null) {
            return false;
        }
        return this._logWindow.isVisible();
    }

    public void showLog() {
        DockUtil.showDockableWindow(this.getLogWindowImpl());
        LogPage logPage = this.getSelectedPage();
        GraphicsUtils.focusComponentOrChild(logPage.getLogPageView().getGUI(), true);
    }

    public void hideLog() {
        if (this._logWindow != null) {
            DockUtil.hideDockableWindow(this.getLogWindowImpl());
        }
    }

    public void toggleLog(Context context) {
        DockUtil.smartToggleDockableWindow(this.getLogWindowImpl(), context);
    }

    public void initialize() {
        LogManager.setLogManager(this);
        DockStation dockStation = DockStation.getDockStation();
        if (dockStation != null) {
            dockStation.registerDockableFactory("LogWindow", LogDockableFactory.getInstance());
        }
        JMenuItem jMenuItem = IdeMenus.createMenuItem(34, "oracle.ide.cmd.LogWindowCommand", IdeArb.getString(170), IdeMainWindow.ACTION_CATEGORY_VIEW, IdeArb.getInteger(171), IdeArb.getInstance(), 172, null, true, MenuConstants.WEIGHT_VIEW_LOG);
        Menubar menubar = Ide.getMenubar();
        JMenu jMenu = MenuManager.getJMenu("View");
        menubar.add(jMenuItem, jMenu, MenuConstants.SECTION_VIEW_SUPPORTING);
        IdeAction ideAction = IdeAction.find(EditorManagerImpl.SHOW_DROPDOWN_CMD_ID);
        ideAction.addController(this);
    }

    public void shutdown() {
    }

    public int getPageCount() {
        if (this._tabbedPage != null) {
            return this._tabbedPage.getPageCount();
        }
        return 0;
    }

    public LogPage[] getPages() {
        if (this._tabbedPage == null) {
            return new LogPage[0];
        }
        return this._tabbedPage.getPages();
    }

    public LogPage getSelectedPage() {
        if (this.getPageCount() > 0) {
            return this._tabbedPage.getSelectedPage();
        }
        return null;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == AbstractLogManager.CLEAR_LOG_CMD_ID) {
            LogPage logPage = this._tabbedPage.getSelectedPage();
            logPage.clearAll();
            return true;
        }
        if (n == AbstractLogManager.CLOSE_LOG_CMD_ID) {
            if (context != null && context.getView() instanceof LogPage) {
                this.closePage((LogPage)((Object)context.getView()));
            } else {
                this.closePage(this._tabbedPage.getSelectedPage());
            }
            return true;
        }
        if (n == AbstractLogManager.CLOSE_OTHER_LOGS_CMD_ID) {
            this.removeAll(this._tabbedPage.getSelectedPage());
            return true;
        }
        if (n == AbstractLogManager.CLOSE_ALL_LOGS_CMD_ID) {
            this.removeAll(null);
            return true;
        }
        if (n == 30 || n == 31) {
            return true;
        }
        if (n == 70) {
            this._tabbedPage.navigateLeft();
            return true;
        }
        if (n == 71) {
            this._tabbedPage.navigateRight();
            return true;
        }
        if (n == EditorManagerImpl.SHOW_DROPDOWN_CMD_ID) {
            if (context != null && context.getView() instanceof LogPage) {
                this._tabbedPage.displayDropDownMenu();
                return true;
            }
        } else {
            if (n == AbstractLogManager.OPEN_FILE_CMD_ID) {
                this.openPageFromFile();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == AbstractLogManager.CLOSE_OTHER_LOGS_CMD_ID) {
            boolean bl = false;
            if (this._tabbedPage.getPageCount() > 1) {
                bl = true;
            }
            ideAction.setEnabled(bl);
            return true;
        }
        if (n == AbstractLogManager.CLOSE_LOG_CMD_ID) {
            if (this.getSelectedPage() == this.getMsgPage()) {
                ideAction.setEnabled(false);
            } else {
                ideAction.setEnabled(true);
            }
            return true;
        }
        if (n == 30 || n == 31) {
            ideAction.setEnabled(false);
            return true;
        }
        if (n == AbstractLogManager.OPEN_FILE_CMD_ID) {
            List list = this.getLogRecognizers();
            if (list.size() > 0) {
                ideAction.setEnabled(true);
            } else {
                ideAction.setEnabled(false);
            }
            return true;
        }
        return false;
    }

    protected Context getContext(EventObject eventObject) {
        return this.getTabbedPage().getContext(eventObject);
    }

    protected TabbedPage getTabbedPage() {
        this.getLogWindowImpl();
        return this._tabbedPage;
    }

    private void removeAll(LogPage logPage) {
        if (this._tabbedPage == null) {
            return;
        }
        LogPage[] logPageArray = this._tabbedPage.getPages();
        int n = 0;
        while (n < logPageArray.length) {
            LogPage logPage2 = logPageArray[n];
            if (logPage2 != logPage && logPage2 != this.getMsgPage()) {
                this.closePage(logPage2);
            }
            ++n;
        }
        IdeUtil.tryToRestoreFocus(logPage != null ? logPage.getLogPageView().getGUI() : null);
    }

    private void closePage(LogPage logPage) {
        if (logPage != this.getMsgPage()) {
            this._tabbedPage.removePage(logPage);
            super.removePage(logPage);
            logPage.getLogPageView().close();
        }
    }

    private void openPageFromFile() {
        URL uRL = null;
        URLChooser uRLChooser = DialogUtil.newURLChooser();
        uRLChooser.clearChooseableURLFilters();
        List list = this.getLogRecognizers();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            LogRecognizer logRecognizer = (LogRecognizer)list.get(n2);
            uRLChooser.addChooseableURLFilter(logRecognizer.getFilter());
            ++n2;
        }
        if (uRLChooser.showOpenDialog((Component)((Object)Ide.getMainWindow())) != 0) {
            return;
        }
        uRL = uRLChooser.getSelectedURL();
        LogRecognizer logRecognizer = null;
        Class clazz = null;
        int n3 = 0;
        while (n3 < n) {
            LogRecognizer logRecognizer2 = (LogRecognizer)list.get(n3);
            clazz = logRecognizer2.recognize(uRL);
            if (clazz != null) {
                logRecognizer = logRecognizer2;
                break;
            }
            ++n3;
        }
        if (logRecognizer != null) {
            try {
                LogPage logPage = logRecognizer.create(uRL, clazz);
                logPage.getLogPageView().show();
            }
            catch (Exception exception) {
                this.showErrorDialog(LogArb.getString(34), LogArb.getString(33));
                exception.printStackTrace();
            }
        } else {
            this.showErrorDialog(LogArb.getString(32), LogArb.getString(33));
        }
    }

    private void showErrorDialog(String string, String string2) {
        JOptionPane.showMessageDialog((Component)((Object)Ide.getMainWindow()), string, string2, 0);
    }
}

