/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.log;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.TabbedWindow;
import oracle.ide.controls.TabbedWindowEvent;
import oracle.ide.controls.TabbedWindowListener;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.controls.customtab.CustomTabPage;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ide.layout.ViewId;
import oracle.ide.log.AbstractLogPage;
import oracle.ide.log.LogContext;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogOwner;
import oracle.ide.log.LogPage;
import oracle.ide.log.LogWindow;
import oracle.ide.resource.IdeArb;
import oracle.ide.resource.LogArb;
import oracle.ide.view.View;
import oracle.ideimpl.controls.FlatTabbedWindow;

public class TabbedPage
extends AbstractLogPage
implements LogOwner {
    protected static final String TABBED_PAGE_ID = "LogWindow";
    private FlatTabbedWindow _tabbedWindow;
    private static final int CLOSE_LOG_CMD_ID = Ide.findOrCreateCmdID("TP_CLOSE_CMD_ID");
    private static final int CLOSE_OTHER_LOGS_CMD_ID = Ide.findOrCreateCmdID("TP_CLOSE_OTHER_CMD_ID");
    private static final int CLOSE_ALL_LOGS_CMD_ID = Ide.findOrCreateCmdID("TP_CLOSE_ALL_CMD_ID");

    void $init$() {
        this._tabbedWindow = new FlatTabbedWindow(true);
    }

    protected TabbedPage() {
        super(new ViewId(TABBED_PAGE_ID, LogArb.getString(3)), null, false);
        this.$init$();
        this._tabbedWindow.setToolTipText(IdeArb.getString(170));
        this._tabbedWindow.setDisplayTabNavigators(true);
        this._tabbedWindow.addTabbedWindowListener(new 1());
        CustomTab customTab = this._tabbedWindow.getCustomTab();
        customTab.setGapBeforeTabs(-1);
        customTab.setMinTabWidth(45);
        customTab.setCloseAction(new TabCloseAction());
        customTab.addMouseListener(new CustomTabMouseListener(null));
    }

    public void addPage(LogPage logPage) {
        boolean bl = false;
        View view = Ide.getMainWindow().getLastActiveView();
        if (view == logPage.getLogPageView().owner()) {
            bl = true;
        }
        this._tabbedWindow.add(logPage.getTabName(), logPage.getTabIcon(), logPage.getLogPageView().getGUI(), logPage.getToolTip(), logPage, bl);
        logPage.setOwner(this);
    }

    public void removePage(LogPage logPage) {
        if (logPage.getLogPageView().owner() != null) {
            this._tabbedWindow.removeComponent(logPage.getLogPageView().getGUI());
            logPage.setOwner(null);
        }
    }

    public void setSelectedPage(LogPage logPage) {
        View view = Ide.getMainWindow().getLastActiveView();
        boolean bl = false;
        if (logPage.getLogPageView().owner() == view) {
            bl = true;
        }
        this._tabbedWindow.setActive(logPage.getLogPageView().getGUI(), bl);
    }

    public LogPage getSelectedPage() {
        if (this.getPageCount() == 0) {
            return LogManager.getLogManager().getMsgPage();
        }
        return (LogPage)this._tabbedWindow.getActiveData();
    }

    public int getPageCount() {
        return this._tabbedWindow.getCount();
    }

    public void navigateLeft() {
        this._tabbedWindow.navigateLeft();
    }

    public void navigateRight() {
        this._tabbedWindow.navigateRight();
    }

    public void displayDropDownMenu() {
        this._tabbedWindow.displayDropdownMenu();
    }

    public LogPage[] getPages() {
        TabbedWindow.PageInfo[] pageInfoArray = this._tabbedWindow.getPages();
        LogPage[] logPageArray = new LogPage[pageInfoArray.length];
        int n = 0;
        while (n < pageInfoArray.length) {
            TabbedWindow.PageInfo pageInfo = pageInfoArray[n];
            logPageArray[n] = (LogPage)pageInfo._data;
            ++n;
        }
        return logPageArray;
    }

    public CustomTabPage getTabPageForLogPage(LogPage logPage) {
        return this._tabbedWindow.getTabPageForComponent(logPage.getLogPageView().getGUI());
    }

    public void clearAll() {
        LogPage logPage = this.getSelectedPage();
        if (logPage != null) {
            logPage.clearAll();
        }
    }

    public void log(Object object) {
        LogPage logPage = this.getSelectedPage();
        if (logPage != null) {
            logPage.log(object);
        }
    }

    public String getTitleName() {
        LogPage logPage = this.getSelectedPage();
        if (logPage != null) {
            return logPage.getTitleName();
        }
        return super.getTitleName();
    }

    public void addMouseListener(MouseListener mouseListener) {
        this._tabbedWindow.addMouseListener(mouseListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this._tabbedWindow.removeMouseListener(mouseListener);
    }

    public void selectPage(LogPage logPage) {
        LogOwner logOwner = (LogOwner)((Object)this.owner());
        if (!logOwner.isClosed()) {
            this.owner().show();
        }
        this.setSelectedPage(logPage);
    }

    public boolean isClosed() {
        if (this.owner() == null) {
            return false;
        }
        return ((LogOwner)((Object)this.owner())).isClosed();
    }

    public void highlightPage(LogPage logPage) {
        this._tabbedWindow.highlightPage(logPage);
    }

    public View getLogOwnerView() {
        return this;
    }

    public Component getGUI() {
        return this._tabbedWindow;
    }

    public Context getContext(EventObject eventObject) {
        LogPage logPage = this.getSelectedPage();
        if (logPage != null) {
            return logPage.getLogPageView().getContext(eventObject);
        }
        return super.getContext(eventObject);
    }

    static FlatTabbedWindow ra$_tabbedWindow(TabbedPage tabbedPage) {
        return tabbedPage._tabbedWindow;
    }

    static int ra$CLOSE_LOG_CMD_ID() {
        return CLOSE_LOG_CMD_ID;
    }

    static int ra$CLOSE_OTHER_LOGS_CMD_ID() {
        return CLOSE_OTHER_LOGS_CMD_ID;
    }

    static int ra$CLOSE_ALL_LOGS_CMD_ID() {
        return CLOSE_ALL_LOGS_CMD_ID;
    }

    public final class 1
    implements TabbedWindowListener {
        public void activeChanged(TabbedWindowEvent tabbedWindowEvent) {
            LogWindow logWindow = (LogWindow)TabbedPage.this.owner();
            if (logWindow != null) {
                logWindow.updateTitle(null);
            }
        }
    }

    private final class CustomTabMouseListener
    extends MouseAdapter
    implements ContextMenuListener {
        private ContextMenu _contextMenu;
        private Controller _controller;
        private IdeAction _closeAction;
        private JMenuItem _closeMenuItem;
        private IdeAction _closeAllAction;
        private JMenuItem _closeAllMenuItem;
        private IdeAction _closeOthersAction;
        private JMenuItem _closeOthersMenuItem;

        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                DefaultCustomTabPage defaultCustomTabPage;
                LogPage logPage;
                int n = TabbedPage.ra$_tabbedWindow(TabbedPage.this).getCustomTab().getPageAt(mouseEvent.getPoint());
                if (n == -1) {
                    return;
                }
                if (this._contextMenu == null) {
                    this._contextMenu = new ContextMenu();
                    this._contextMenu.addContextMenuListener(this);
                    this._controller = new FlatTabbedWindowController(null);
                    this._closeAction = IdeAction.get(TabbedPage.ra$CLOSE_LOG_CMD_ID(), null, LogArb.getString(4), null, LogArb.getInteger(5), LogArb.getInstance(), 6, null, true);
                    this._closeMenuItem = this._contextMenu.createMenuItem(this._closeAction);
                    this._closeAction.addController(this._controller);
                    this._closeOthersAction = IdeAction.get(TabbedPage.ra$CLOSE_OTHER_LOGS_CMD_ID(), null, LogArb.getString(14), null, LogArb.getInteger(15), LogArb.getInstance(), 16, null, true);
                    this._closeOthersMenuItem = this._contextMenu.createMenuItem(this._closeOthersAction);
                    this._closeOthersAction.addController(this._controller);
                    this._closeAllAction = IdeAction.get(TabbedPage.ra$CLOSE_ALL_LOGS_CMD_ID(), null, LogArb.getString(17), null, LogArb.getInteger(18), LogArb.getInstance(), 19, null, true);
                    this._closeAllMenuItem = this._contextMenu.createMenuItem(this._closeAllAction);
                    this._closeAllAction.addController(this._controller);
                }
                boolean bl = (logPage = (LogPage)(defaultCustomTabPage = (DefaultCustomTabPage)TabbedPage.ra$_tabbedWindow(TabbedPage.this).getCustomTab().getPage(n)).getUserObject()) == LogManager.getLogManager().getMsgPage();
                this._closeAction.setEnabled(bl ^ true);
                int n2 = TabbedPage.ra$_tabbedWindow(TabbedPage.this).getCustomTab().getPageCount();
                this._closeAllAction.setEnabled(n2 > 1);
                if (n2 == 1 || n2 == 2 && !bl) {
                    this._closeOthersAction.setEnabled(false);
                } else {
                    this._closeOthersAction.setEnabled(true);
                }
                Context context = Context.newIdeContext();
                LogContext.setLogPage(context, logPage);
                context.setEvent(mouseEvent);
                this._contextMenu.show(context);
            }
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }

        public void menuWillShow(ContextMenu contextMenu) {
            contextMenu.add(this._closeMenuItem);
            contextMenu.add(this._closeAllMenuItem);
            contextMenu.add(this._closeOthersMenuItem);
        }

        public void menuWillHide(ContextMenu contextMenu) {
        }

        private CustomTabMouseListener() {
        }

        CustomTabMouseListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class FlatTabbedWindowController
    implements Controller {
        public boolean handleEvent(IdeAction ideAction, Context context) {
            int n = ideAction.getCommandId();
            if (n == TabbedPage.ra$CLOSE_LOG_CMD_ID()) {
                LogManager.getLogManager().removePage(LogContext.getLogPage(context));
                return true;
            }
            if (n == TabbedPage.ra$CLOSE_ALL_LOGS_CMD_ID()) {
                this.closeLogPages(TabbedPage.ra$CLOSE_ALL_LOGS_CMD_ID(), null);
                return true;
            }
            if (n == TabbedPage.ra$CLOSE_OTHER_LOGS_CMD_ID()) {
                this.closeLogPages(TabbedPage.ra$CLOSE_OTHER_LOGS_CMD_ID(), LogContext.getLogPage(context));
                return true;
            }
            return false;
        }

        private void closeLogPages(int n, LogPage logPage) {
            LogManager logManager = LogManager.getLogManager();
            LogPage[] logPageArray = logManager.getPages();
            int n2 = 0;
            while (n2 < logPageArray.length) {
                if (n != TabbedPage.ra$CLOSE_OTHER_LOGS_CMD_ID() || logPage != logPageArray[n2]) {
                    logManager.removePage(logPageArray[n2]);
                }
                ++n2;
            }
        }

        public boolean update(IdeAction ideAction, Context context) {
            return false;
        }

        private FlatTabbedWindowController() {
        }

        FlatTabbedWindowController(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class TabCloseAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            MenuSelectionManager.defaultManager().clearSelectedPath();
            DefaultCustomTabPage defaultCustomTabPage = (DefaultCustomTabPage)actionEvent.getSource();
            LogManager.getLogManager().removePage((LogPage)defaultCustomTabPage.getUserObject());
        }
    }
}

