/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.migration;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.ide.extension.Extension;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.ResourceUtils;

public final class MigrationDialog
extends JEWTDialog
implements VetoableChangeListener {
    private static final String HELP_TOPIC_BROWSE_DLG = "f1_migbrowse_html";
    private static final String EXTENSION = "Migrator";
    private ArrayList result;
    private boolean isManual;
    private final JPanel mainPanel;
    private final JMultiLineLabel prompt;
    private final JPanel centerPanel;
    private final JLabel versionLabel;
    private final JTextField versionField;
    private final JButton browseButton;
    private BorderLayout dialogBorderLayout;
    private GridBagLayout centerPanelLayout;
    private URL selection;
    private boolean vetoed;

    void $init$() {
        this.result = new ArrayList();
        this.mainPanel = new JPanel();
        this.prompt = new JMultiLineLabel();
        this.centerPanel = new JPanel();
        this.versionLabel = new JLabel();
        this.versionField = new JTextField();
        this.browseButton = new JButton();
        this.dialogBorderLayout = new BorderLayout(0, 8);
        this.centerPanelLayout = new GridBagLayout();
        this.selection = URLFactory.newDirURL(Ide.getSystemDirectory());
    }

    public MigrationDialog(Frame frame) {
        super(frame, IdeArb.getString(367), 3);
        this.$init$();
        try {
            this.jbInit();
            this.setContent(this.mainPanel);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void jbInit() throws Exception {
        this.addVetoableChangeListener(this);
        this.mainPanel.setLayout(this.dialogBorderLayout);
        this.prompt.setText(IdeArb.format(369, new String[]{IdeArb.getString(373)}));
        this.prompt.setPreferredColumns(60);
        ResourceUtils.resLabel(this.versionLabel, this.versionField, IdeArb.getString(371));
        this.versionField.setText(Ide.getSystemDirectory());
        ResourceUtils.resButton(this.browseButton, IdeArb.getString(377));
        this.browseButton.addActionListener(new 1());
        this.centerPanel.setLayout(this.centerPanelLayout);
        this.centerPanel.add((Component)this.versionLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.centerPanel.add((Component)this.versionField, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.centerPanel.add((Component)this.browseButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 8, 0, 0), 0, 0));
        this.mainPanel.add((Component)((Object)this.prompt), "North");
        this.mainPanel.add((Component)this.centerPanel, "Center");
    }

    public void setManualMigration(boolean bl) {
        this.isManual = bl;
        this.prompt.setText(bl ? IdeArb.getString(369) : IdeArb.getString(368));
    }

    public File getSource() {
        return new File(this.selection.getPath());
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if (this.vetoed) {
            this.vetoed = false;
            return;
        }
        if (!(URLFileSystem.exists(this.selection) && URLFileSystem.isDirectory(this.selection) && URLFileSystem.getFileName(this.selection).startsWith("system"))) {
            String string = IdeArb.format(380, URLFileSystem.getPlatformPathName(this.selection));
            JOptionPane.showMessageDialog((Component)((Object)this), string, IdeArb.getString(236), 2);
            this.vetoed = true;
            throw new PropertyVetoException(string, propertyChangeEvent);
        }
    }

    protected void dismissDialog(boolean bl) {
        if (!bl) {
            ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
            Collection collection = extensionRegistry.getExtensions();
            for (Extension extension : collection) {
                if (!this.isManual && !extensionRegistry.isNewlyInstalled(extension.getID())) continue;
                this.result.add(extension);
            }
            this.selection = URLFactory.newDirURL(this.versionField.getText());
        }
        super.dismissDialog(bl);
    }

    public Collection getSelectedExtensions() {
        return Collections.unmodifiableCollection(this.result);
    }

    private void browse(ActionEvent actionEvent) {
        URL uRL = this.selection;
        URL uRL2 = URLFactory.newDirURL(this.versionField.getText());
        if (uRL2 != null && URLFileSystem.isValid(uRL2)) {
            uRL = uRL2;
        }
        URLChooser uRLChooser = DialogUtil.newURLChooser(uRL);
        uRLChooser.setShowJarsAsDirs(false);
        uRLChooser.setSelectionScope(1);
        uRLChooser.setHelpID(null);
        if (uRLChooser.showOpenDialog((Component)((Object)this), IdeArb.getString(378)) == 0) {
            this.selection = uRLChooser.getSelectedURL();
            this.versionField.setText(URLFileSystem.getPlatformPathName(this.selection));
        }
    }

    static void mav$browse(MigrationDialog migrationDialog, ActionEvent actionEvent) {
        migrationDialog.browse(actionEvent);
    }

    public final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MigrationDialog.mav$browse(MigrationDialog.this, actionEvent);
        }
    }
}

