/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.migration;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.ide.extension.Extension;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeArgs;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.controls.SplashScreen;
import oracle.ide.migration.MigrationInfo;
import oracle.ide.migration.MigrationManager;
import oracle.ide.migration.Migrator;
import oracle.ide.migration.NodeMigrator;
import oracle.ide.migration.XMLMigrator;
import oracle.ide.model.DefaultFolder;
import oracle.ide.model.IdeSystemMigrator;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.FastStringBuffer;
import oracle.ide.util.ModelUtil;
import oracle.ideimpl.migration.MigrationDialog;
import oracle.ideimpl.migration.MigratorsHook;
import oracle.javatools.util.PlatformUtils;
import oracle.javatools.util.SwingUtils;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.NodeList;

public class MigrationManagerImpl
extends MigrationManager {
    private ArrayList _registrations;
    private ArrayList _migrators;
    private HashMap _map;
    private File _srcDir;
    private boolean _migrate;
    private boolean _done;
    private static MigrationManager _instance;

    void $init$() {
        this._registrations = new ArrayList();
        this._map = new HashMap();
    }

    public static synchronized MigrationManager getInstance() {
        if (_instance == null) {
            _instance = new MigrationManagerImpl();
        }
        return _instance;
    }

    private ArrayList getMigrators(Extension extension) {
        this.getMigrators();
        return (ArrayList)this._map.get(extension);
    }

    public synchronized List getMigrators() {
        if (this._migrators == null) {
            this.registerHookMigrators();
            int n = this._registrations.size();
            if (n <= 0) {
                this._migrators = new ArrayList();
            } else {
                this._migrators = new ArrayList();
                int n2 = 0;
                while (n2 < n) {
                    String string = this._registrations.get(n2).toString();
                    Migrator migrator = this.buildMigrator(string);
                    if (migrator != null) {
                        Extension extension = (Extension)this._registrations.get(n2 + 1);
                        ArrayList<Migrator> arrayList = this.getMigrators(extension);
                        if (arrayList == null) {
                            arrayList = new ArrayList<Migrator>();
                            this._map.put(extension, arrayList);
                        }
                        arrayList.add(migrator);
                        this._migrators.add(migrator);
                    }
                    n2 += 2;
                }
            }
        }
        return this._migrators;
    }

    private void registerHookMigrators() {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
        MigratorsHook migratorsHook = (MigratorsHook)extensionRegistry.getIdeHook(MigratorsHook.ELEMENT);
        if (migratorsHook != null) {
            Map map = migratorsHook.getMigratorClassesByExtension();
            for (Extension extension : map.keySet()) {
                Collection collection = (Collection)map.get(extension);
                for (String string : collection) {
                    this.registerMigrator(string, extension);
                }
            }
        }
    }

    private Migrator buildMigrator(String string) {
        Migrator migrator = null;
        try {
            Class<?> clazz = Class.forName(string);
            migrator = (Migrator)clazz.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return migrator;
    }

    public Migrator getMigrator(Class clazz) {
        List list = this.getMigrators();
        for (Migrator migrator : list) {
            if (clazz != migrator.getClass()) continue;
            return migrator;
        }
        return null;
    }

    public File getOracleHomeDirectory(File file) {
        block20: {
            try {
                String string = Ide.getInstallDirectory(file);
                if (string != null && ModelUtil.hasLength((String)string)) {
                    File file2 = new File(string);
                    File file3 = file2.getParentFile().getParentFile();
                    return file3;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            BufferedInputStream bufferedInputStream = null;
            try {
                try {
                    File file4 = new File(file, "palette.xml");
                    if (!file4.exists()) break block20;
                    bufferedInputStream = new BufferedInputStream(new FileInputStream(file4));
                    DOMParser dOMParser = new DOMParser();
                    dOMParser.parse((InputStream)bufferedInputStream);
                    XMLDocument xMLDocument = dOMParser.getDocument();
                    XMLElement xMLElement = (XMLElement)xMLDocument.getDocumentElement();
                    2 var10_11 = new 2(this, xMLElement);
                    NodeList nodeList = xMLElement.selectNodes("a:jsplibrary[a:prefix='jbo' or a:prefix='bc4juix' or a:prefix='uix']/a:location/text()", (NSResolver)var10_11);
                    File file5 = MigrationManagerImpl.findOracleHome(nodeList, 3);
                    if (file5 != null) {
                        File file6 = file5;
                        if (bufferedInputStream != null) {
                            try {
                                bufferedInputStream.close();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        return file6;
                    }
                    NodeList nodeList2 = xMLElement.selectNodes("a:jsplibrary[a:prefix='email' or a:prefix='fileaccess' or a:prefix='JESI' or a:prefix='jwcache' or a:prefix='database' or a:prefix='util' or a:prefix='XML' or a:prefix='EJB']/a:location/text()", (NSResolver)var10_11);
                    File file7 = MigrationManagerImpl.findOracleHome(nodeList2, 4);
                    if (bufferedInputStream != null) {
                        try {
                            bufferedInputStream.close();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    return file7;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            finally {
                if (bufferedInputStream != null) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    private static File findOracleHome(NodeList nodeList, int n) {
        int n2 = nodeList.getLength();
        int n3 = 0;
        while (n3 < n2) {
            org.w3c.dom.Node node = nodeList.item(n3);
            String string = node.getNodeValue();
            if (ModelUtil.hasLength((String)string)) {
                File file = new File(string);
                int n4 = 0;
                while (n4 < n) {
                    if (file == null) break;
                    file = file.getParentFile();
                    ++n4;
                }
                if (file != null) {
                    return file;
                }
            }
            ++n3;
        }
        return null;
    }

    public synchronized void registerMigrator(String string, Extension extension) {
        Migrator migrator;
        if (string == null || extension == null) {
            return;
        }
        if (!this._registrations.contains(string)) {
            this._registrations.add(string);
            this._registrations.add(extension);
        }
        if (this._migrators != null && (migrator = this.buildMigrator(string)) != null) {
            this._migrators.add(migrator);
            ArrayList<Migrator> arrayList = this.getMigrators(extension);
            if (arrayList == null) {
                arrayList = new ArrayList<Migrator>();
                this._map.put(extension, arrayList);
            }
            arrayList.add(migrator);
        }
    }

    public void migrate() {
        boolean bl;
        boolean bl2;
        IdeArgs ideArgs = Ide.getIdeArgs();
        this._migrate = bl2 = ideArgs.isMigrate();
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
        for (Extension extension : extensionRegistry.getExtensions()) {
            if (!extensionRegistry.isNewlyInstalled(extension.getID())) continue;
            this._migrate = true;
            break;
        }
        boolean bl3 = bl = System.getProperty("nomigrate", null) != null;
        if (!bl2 && bl) {
            this._migrate = false;
        }
        if (this._migrate && ideArgs.getCreateUI()) {
            this.migrate(bl2, extensionRegistry.getExtensions());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishMigration() {
        block10: {
            try {
                XMLMigrator xMLMigrator;
                XMLMigrator xMLMigrator2 = xMLMigrator = this._migrate ? (XMLMigrator)this.getMigrator(IdeSystemMigrator.class) : null;
                if (xMLMigrator == null || !xMLMigrator.isSelected(0)) break block10;
                MigrationManagerImpl migrationManagerImpl = this;
                synchronized (migrationManagerImpl) {
                    SwingUtilities.invokeLater(new WorkspacesMigrator(this));
                    while (!this._done) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (Throwable throwable) {
                            if (!(throwable instanceof ThreadDeath)) break;
                            throw (ThreadDeath)throwable;
                        }
                    }
                }
            }
            finally {
                MigrationManagerImpl.setMigrationManager(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean migrate(boolean bl, Collection collection) {
        List list = this.getMigrators();
        if (list == null || list.isEmpty()) {
            return true;
        }
        boolean bl2 = true;
        boolean bl3 = false;
        if (this._srcDir == null) {
            if (!bl) {
                Object object;
                if (PlatformUtils.isLinux()) {
                    SplashScreen.setVisible((boolean)false);
                    bl3 = true;
                }
                Object object2 = object = new Object();
                synchronized (object2) {
                    boolean[] blArray = new boolean[]{false};
                    SwingUtilities.invokeLater(new 1(this, object, blArray));
                    try {
                        object.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    bl2 = blArray[0];
                }
            }
            if (bl2) {
                MigrationDialog migrationDialog = new MigrationDialog(SwingUtils.getToplevelWindow());
                migrationDialog.setManualMigration(bl);
                migrationDialog.pack();
                bl2 = migrationDialog.runDialog();
                if (bl2) {
                    this._srcDir = migrationDialog.getSource();
                    collection = migrationDialog.getSelectedExtensions();
                }
                migrationDialog.dispose();
            }
        }
        if (bl2) {
            ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
            FastStringBuffer fastStringBuffer = new FastStringBuffer();
            for (Extension extension : collection) {
                Iterator iterator;
                ArrayList arrayList = this.getMigrators(extension);
                Iterator iterator2 = iterator = arrayList != null ? arrayList.iterator() : null;
                if (iterator == null) continue;
                File file = this.deduceSrcDir(this._srcDir, extension);
                URL uRL = extensionRegistry.getSystemDirectory(extension.getID());
                File file2 = new File(uRL.getPath());
                if (file == null || file2 == null || file.equals(file2)) continue;
                while (iterator.hasNext()) {
                    Migrator migrator = (Migrator)iterator.next();
                    int[] nArray = migrator.getMigrationCategories();
                    int n = 0;
                    while (n < nArray.length) {
                        int n2 = nArray[n];
                        migrator.setSelected(n2, migrator.canMigrate(n2, file));
                        ++n;
                    }
                    String[] stringArray = migrator.migrate(file, file2);
                    if (stringArray == null || stringArray.length <= 0) continue;
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        fastStringBuffer.append(stringArray[n3]);
                        fastStringBuffer.append("\n");
                        ++n3;
                    }
                    fastStringBuffer.append("\n");
                }
            }
            if (fastStringBuffer.getLength() > 0) {
                JMultiLineLabel jMultiLineLabel = new JMultiLineLabel(fastStringBuffer.toString());
                JScrollPane jScrollPane = new JScrollPane((Component)((Object)jMultiLineLabel));
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                jScrollPane.setBorder(BorderFactory.createEmptyBorder());
                JOptionPane jOptionPane = new JOptionPane(jScrollPane, 2);
                JDialog jDialog = jOptionPane.createDialog(SwingUtils.getToplevelWindow(), IdeArb.getString(367));
                jDialog.setResizable(true);
                jDialog.pack();
                if (jDialog.getWidth() > dimension.width / 3 || jDialog.getHeight() > dimension.height / 3) {
                    jDialog.setBounds(dimension.width / 3, dimension.height / 3, dimension.width / 3, dimension.height / 3);
                }
                jDialog.setVisible(true);
                jDialog.dispose();
            }
        }
        if (bl3) {
            SplashScreen.setVisible((boolean)true);
        }
        return bl2;
    }

    private File deduceSrcDir(File file, Extension extension) {
        URL uRL = URLFactory.newDirURL(file.getAbsolutePath());
        URL[] uRLArray = URLFileSystem.list(uRL);
        if (uRLArray == null) {
            return file;
        }
        String string = extension.getID() + ".";
        String string2 = extension.getVersion().toCanonicalString();
        URL uRL2 = null;
        int n = string.length();
        int n2 = 0;
        while (n2 < uRLArray.length) {
            uRL = uRLArray[n2];
            String string3 = URLFileSystem.getFileName(uRL);
            if (string3.startsWith(string) && URLFileSystem.isDirectory(uRL) && (string3 = string3.substring(n)) != null && !string3.equals(string2)) {
                if (uRL2 == null) {
                    if (Character.isDigit(string3.charAt(0))) {
                        uRL2 = uRL;
                    }
                } else {
                    String string4 = URLFileSystem.getFileName(uRL2).substring(n);
                    StringTokenizer stringTokenizer = new StringTokenizer(string4, ".");
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string3, ".");
                    while (stringTokenizer.hasMoreTokens()) {
                        if (stringTokenizer2.hasMoreTokens()) {
                            int n3 = 0;
                            int n4 = -1;
                            try {
                                n4 = Integer.parseInt(stringTokenizer2.nextToken());
                            }
                            catch (Exception exception) {
                                stringTokenizer2 = null;
                                break;
                            }
                            try {
                                n3 = Integer.parseInt(stringTokenizer.nextToken());
                            }
                            catch (Exception exception) {
                                uRL2 = uRL;
                                stringTokenizer2 = null;
                                break;
                            }
                            if (n3 > n4) {
                                stringTokenizer2 = null;
                                break;
                            }
                            if (n3 >= n4) continue;
                            uRL2 = uRL;
                            stringTokenizer2 = null;
                            break;
                        }
                        stringTokenizer2 = null;
                        break;
                    }
                    if (stringTokenizer2 != null && stringTokenizer2.hasMoreTokens()) {
                        uRL2 = uRL;
                    }
                }
            }
            ++n2;
        }
        return uRL2 != null ? new File(uRL2.getPath()) : file;
    }

    public MigrationManagerImpl() {
        this.$init$();
    }

    static void wa$_done(MigrationManagerImpl migrationManagerImpl, boolean bl) {
        migrationManagerImpl._done = bl;
    }

    public final class 2
    implements NSResolver {
        private final String uri;
        final /* synthetic */ MigrationManagerImpl this$0;
        private final /* synthetic */ XMLElement v$rootElem;

        void $init$() {
            this.uri = this.v$rootElem.getNamespaceURI();
        }

        public String resolveNamespacePrefix(String string) {
            return "a".equals(string) ? this.uri : null;
        }

        public 2(MigrationManagerImpl migrationManagerImpl, XMLElement xMLElement) {
            this.v$rootElem = xMLElement;
            this.this$0 = migrationManagerImpl;
            this.$init$();
        }
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ Object v$lock;
        private final /* synthetic */ boolean[] v$ret;
        final /* synthetic */ MigrationManagerImpl this$0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this.v$lock;
            synchronized (object) {
                try {
                    this.v$ret[0] = JOptionPane.showConfirmDialog(SwingUtils.getToplevelWindow(), IdeArb.getString(370), IdeArb.getString(367), 0, 3) == 0;
                }
                finally {
                    this.v$lock.notifyAll();
                }
            }
        }

        public 1(MigrationManagerImpl migrationManagerImpl, Object object, boolean[] blArray) {
            this.v$ret = blArray;
            this.v$lock = object;
            this.this$0 = migrationManagerImpl;
        }
    }

    private static final class WorkspacesMigrator
    implements Runnable {
        MigrationManagerImpl _manager;

        WorkspacesMigrator(MigrationManagerImpl migrationManagerImpl) {
            this._manager = migrationManagerImpl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            MigrationManagerImpl migrationManagerImpl = this._manager;
            synchronized (migrationManagerImpl) {
                try {
                    try {
                        Node[] nodeArray;
                        MigrationInfo[] migrationInfoArray;
                        DefaultFolder defaultFolder = null;
                        Iterator iterator = Ide.getSystem().getChildren();
                        if (iterator != null) {
                            while (iterator.hasNext()) {
                                Object e = iterator.next();
                                if (!(e instanceof Workspaces)) continue;
                                defaultFolder = (Workspaces)e;
                                break;
                            }
                        }
                        if (defaultFolder == null) {
                            MigrationManagerImpl.wa$_done(this._manager, true);
                            this._manager.notifyAll();
                            return;
                        }
                        ArrayList arrayList = new ArrayList();
                        iterator = defaultFolder.getChildren();
                        if (iterator != null) {
                            while (iterator.hasNext()) {
                                Object e = iterator.next();
                                if (!(e instanceof Workspace)) continue;
                                arrayList.add(e);
                            }
                        }
                        if (arrayList.size() == 0) {
                            MigrationManagerImpl.wa$_done(this._manager, true);
                            this._manager.notifyAll();
                            return;
                        }
                        NodeMigrator nodeMigrator = NodeMigrator.getNodeMigrator(NodeMigrator.getLookupKey((Node)arrayList.get(0)));
                        if (nodeMigrator != null && nodeMigrator.checkVersions(migrationInfoArray = nodeMigrator.getMigrationInfos(nodeArray = arrayList.toArray(new Node[arrayList.size()]))) == MigrationInfo.MIGRATION_PENDING) {
                            MigrationInfo[] migrationInfoArray2 = nodeMigrator.migrate(migrationInfoArray);
                            ArrayList<Node> arrayList2 = null;
                            int n = 0;
                            while (n < migrationInfoArray2.length) {
                                if (migrationInfoArray2[n].getMigrationStatus() != MigrationInfo.MIGRATION_DONE) {
                                    Node node = migrationInfoArray2[n].getNode();
                                    ((Workspaces)defaultFolder).remove(node);
                                    if (arrayList2 == null) {
                                        arrayList2 = new ArrayList<Node>();
                                    }
                                    arrayList2.add(node);
                                }
                                ++n;
                            }
                            if (arrayList2 != null && arrayList2.size() > 0) {
                                UpdateMessage.fireChildrenRemoved((Subject)((Object)defaultFolder), arrayList2);
                            }
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                finally {
                    MigrationManagerImpl.wa$_done(this._manager, true);
                    this._manager.notifyAll();
                }
                try {
                    Ide.getDefaultProject().save();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

