/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.navigation;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.navigation.DefaultNavigationPoint;
import oracle.ide.navigation.EditorNavigationPoint;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.navigation.NavigationPointEvent;
import oracle.ide.navigation.NavigationPointListener;
import oracle.ide.resource.IdeArb;
import oracle.ide.view.View;

public final class NavigationManagerImpl
extends NavigationManager
implements Addin,
NavigationPointListener,
EditorListener {
    private final Stack _STACK;
    private final HashMap _EDITOR_MAP;
    private final HashMap _ACTION_MAP;
    private final int _HISTORY_MAX;
    private int _navigationLevel;
    private int _stackPointer;
    private int _navigating;
    private NavigationPoint _lastEditLocation;

    void $init$() {
        this._STACK = new Stack();
        this._EDITOR_MAP = new HashMap();
        this._ACTION_MAP = new HashMap();
        this._HISTORY_MAX = 15;
        this._navigationLevel = 100;
        this._stackPointer = -1;
        this._navigating = 0;
    }

    public NavigationManagerImpl() {
        this.$init$();
        EditorManager editorManager = EditorManager.getEditorManager();
        if (editorManager != null) {
            editorManager.addEditorListener(this);
        }
        IdeSettings ideSettings = Ide.getSettings();
        EnvironOptions environOptions = (EnvironOptions)ideSettings.getData("environment-options");
        environOptions.addChangeListener(new 1());
        this.navigationLevelChanged(environOptions.getNavigationLevel());
    }

    public void initialize() {
        NavigationManager.setNavigationManager(this);
        AddinManager addinManager = AddinManager.getAddinManager();
        Action[] actionArray = new Action[]{};
        IdeAction ideAction = IdeAction.get(73, addinManager.getCommand(73, "oracle.ide.cmd.NotImplementedCommand"), IdeArb.getString(426), IdeMainWindow.ACTION_CATEGORY_NAVIGATE, IdeArb.getInteger(427), IdeArb.getInstance(), 428, null, false);
        ideAction.putValue("ActionMenuActions", actionArray);
        IdeAction ideAction2 = IdeAction.get(74, addinManager.getCommand(74, "oracle.ide.cmd.NotImplementedCommand"), IdeArb.getString(430), IdeMainWindow.ACTION_CATEGORY_NAVIGATE, IdeArb.getInteger(431), IdeArb.getInstance(), 432, null, false);
        ideAction2.putValue("ActionMenuActions", actionArray);
        IdeAction ideAction3 = IdeAction.get(75, addinManager.getCommand(75, "oracle.ide.cmd.NotImplementedCommand"), IdeArb.getString(434), IdeMainWindow.ACTION_CATEGORY_NAVIGATE, IdeArb.getInteger(435), IdeArb.getInstance(), 436, null, false);
        Menubar menubar = Ide.getMenubar();
        JMenu jMenu = MenuManager.getJMenu("Navigate");
        JMenuItem jMenuItem = menubar.createMenuItem(ideAction, 1.0f);
        JMenuItem jMenuItem2 = menubar.createMenuItem(ideAction2, MenuConstants.WEIGHT_NAVIGATE_FORWARD);
        JMenuItem jMenuItem3 = menubar.createMenuItem(ideAction3, MenuConstants.WEIGHT_NAVIGATE_GO_TO_LAST_EDIT);
        menubar.add(jMenuItem, jMenu, 1.0f);
        menubar.add(jMenuItem2, jMenu, 1.0f);
        menubar.add(jMenuItem3, jMenu, MenuConstants.SECTION_NAVIGATE_GOTO_ELEMENT);
    }

    public boolean canNavigateBack() {
        return this._stackPointer > 0;
    }

    public synchronized int navigateBack() throws Exception {
        int n = 1;
        try {
            ++this._navigating;
            if (this.canNavigateBack()) {
                this.updateNavigationPoint();
                NavigationPoint navigationPoint = (NavigationPoint)this._STACK.get(this._stackPointer - 1);
                n = navigationPoint.navigate();
                if (n == 0) {
                    --this._stackPointer;
                    this.updateHistory();
                }
            }
        }
        finally {
            --this._navigating;
        }
        return n;
    }

    public boolean canNavigateForward() {
        int n = this._STACK.size();
        return n > 0 && this._stackPointer < n - 1;
    }

    public synchronized int navigateForward() throws Exception {
        int n = 1;
        try {
            ++this._navigating;
            if (this.canNavigateForward()) {
                this.updateNavigationPoint();
                NavigationPoint navigationPoint = (NavigationPoint)this._STACK.get(this._stackPointer + 1);
                n = navigationPoint.navigate();
                if (n == 0) {
                    ++this._stackPointer;
                    this.updateHistory();
                }
            }
        }
        finally {
            --this._navigating;
        }
        return n;
    }

    public synchronized int navigateTo(NavigationPoint navigationPoint) throws Exception {
        int n = 1;
        try {
            ++this._navigating;
            if (navigationPoint != null) {
                if (this._navigating == 1) {
                    this.updateNavigationPoint();
                }
                if ((n = navigationPoint.navigate()) == 0 && this._navigating == 1) {
                    int n2 = this._STACK.size() - 1;
                    while (n2 > this._stackPointer) {
                        NavigationPoint navigationPoint2 = (NavigationPoint)this._STACK.pop();
                        navigationPoint2.removeNavigationPointListener(this);
                        this._ACTION_MAP.remove(navigationPoint2);
                        --n2;
                    }
                    this._STACK.push(navigationPoint);
                    navigationPoint.addNavigationPointListener(this);
                    if (this._STACK.size() > this._navigationLevel) {
                        NavigationPoint navigationPoint3 = (NavigationPoint)this._STACK.remove(0);
                        navigationPoint3.removeNavigationPointListener(this);
                        this._ACTION_MAP.remove(navigationPoint3);
                    } else {
                        ++this._stackPointer;
                    }
                    this.updateHistory();
                }
            }
        }
        finally {
            --this._navigating;
        }
        return n;
    }

    public synchronized int navigateTo(NavigationPoint navigationPoint, boolean bl) throws Exception {
        int n = 1;
        if (navigationPoint != null && (n = this.navigateTo(navigationPoint)) == 0 && bl) {
            this.setLastEdit((NavigationPoint)navigationPoint.copyTo(null));
        }
        return n;
    }

    public void registerEditorNavigationPoint(Class clazz, Class clazz2) {
        if (clazz2 != null) {
            if (clazz != null) {
                this._EDITOR_MAP.put(clazz2, clazz);
            } else {
                this._EDITOR_MAP.remove(clazz2);
            }
        }
    }

    public synchronized void setLastEdit(Context context) {
        EditorNavigationPoint editorNavigationPoint = this.createDefaultNavigationPoint(context);
        if (editorNavigationPoint != null) {
            try {
                editorNavigationPoint.navigate();
                editorNavigationPoint.refresh();
                this.setLastEdit(editorNavigationPoint);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public boolean canNavigateToLastEdit() {
        return this._lastEditLocation != null;
    }

    public synchronized int navigateToLastEdit() throws Exception {
        int n = 1;
        if (this._lastEditLocation != null) {
            n = this.navigateTo((NavigationPoint)this._lastEditLocation.copyTo(null));
        }
        return n;
    }

    private void setLastEdit(NavigationPoint navigationPoint) {
        if (navigationPoint != null) {
            try {
                navigationPoint.addNavigationPointListener(this);
                if (this._lastEditLocation != null) {
                    this._lastEditLocation.removeNavigationPointListener(this);
                }
                this._lastEditLocation = navigationPoint;
                this.updateLastEdit();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private EditorNavigationPoint createDefaultNavigationPoint(Context context) {
        View view;
        EditorNavigationPoint editorNavigationPoint = null;
        View view2 = view = context != null ? context.getView() : null;
        if (view == null && context != null) {
            Context context2;
            EditorManager editorManager = EditorManager.getEditorManager();
            Editor editor = editorManager != null ? editorManager.getCurrentEditor() : null;
            Context context3 = context2 = editor != null ? editor.getContext() : null;
            if (context2 != null && context2.getNode() == context.getNode()) {
                context = new Context(context);
                context.setView(editor);
                view = editor;
            }
        }
        if (view instanceof Editor) {
            try {
                Class<?> clazz = view.getClass();
                Class clazz2 = (Class)this._EDITOR_MAP.get(clazz);
                if (clazz2 == null) {
                    clazz = clazz.getSuperclass();
                    while (clazz != null && Editor.class.isAssignableFrom(clazz)) {
                        clazz2 = (Class)this._EDITOR_MAP.get(clazz);
                        if (clazz2 != null) break;
                        clazz = clazz.getSuperclass();
                    }
                    if (clazz2 == null) {
                        clazz2 = DefaultNavigationPoint.class;
                    }
                }
                editorNavigationPoint = (EditorNavigationPoint)clazz2.newInstance();
                editorNavigationPoint.setContext(context);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return editorNavigationPoint;
    }

    private synchronized void navigationLevelChanged(int n) {
        int n2 = this._STACK.size() - ++n;
        Object e = null;
        if (this._stackPointer < n2 && n > 0) {
            e = this._STACK.remove(this._stackPointer);
        }
        if (n2 > 0) {
            List list = this._STACK.subList(0, n2);
            ArrayList arrayList = new ArrayList(list);
            Iterator iterator = arrayList.iterator();
            if (iterator != null) {
                while (iterator.hasNext()) {
                    NavigationPoint navigationPoint = (NavigationPoint)iterator.next();
                    navigationPoint.removeNavigationPointListener(this);
                    this._ACTION_MAP.remove(navigationPoint);
                }
            }
            this._STACK.removeAll(arrayList);
            if (e != null) {
                this._STACK.add(0, e);
                this._stackPointer = 0;
            } else {
                this._stackPointer -= n2;
            }
        }
        this._navigationLevel = n;
    }

    private synchronized int jumpTo(NavigationPoint navigationPoint) throws Exception {
        int n = 1;
        int n2 = navigationPoint != null ? this._STACK.indexOf(navigationPoint) : -1;
        try {
            ++this._navigating;
            if (n2 >= 0) {
                if (this._navigating == 1) {
                    this.updateNavigationPoint();
                }
                if ((n = navigationPoint.navigate()) == 0 && this._navigating == 1) {
                    this._stackPointer = n2;
                    this.updateHistory();
                }
            }
        }
        finally {
            --this._navigating;
        }
        return n;
    }

    private void updateNavigationPoint() {
        NavigationPoint navigationPoint = this.getCurrentNavigationPoint();
        if (navigationPoint != null) {
            navigationPoint.refresh();
        }
    }

    private synchronized NavigationPoint getCurrentNavigationPoint() {
        return this._stackPointer >= 0 ? (NavigationPoint)this._STACK.get(this._stackPointer) : null;
    }

    private synchronized void updateHistory() {
        IdeAction ideAction;
        IdeAction ideAction2 = IdeAction.find(73);
        if (ideAction2 != null) {
            ArrayList<Action> arrayList = new ArrayList<Action>();
            int n = this._stackPointer > 15 ? this._stackPointer - 15 : 0;
            int n2 = this._stackPointer - 1;
            while (n2 >= n) {
                arrayList.add(this.findOrCreateAction((NavigationPoint)this._STACK.get(n2)));
                --n2;
            }
            ideAction2.putValue("ActionMenuActions", arrayList.toArray(new Action[arrayList.size()]));
            if (arrayList.size() > 0) {
                this.updateBackTooltip((Action)arrayList.get(0));
            } else {
                this.updateBackTooltip(null);
            }
            ideAction2.updateAction();
        }
        if ((ideAction = IdeAction.find(74)) != null) {
            ArrayList<Action> arrayList = new ArrayList<Action>();
            int n = this._STACK.size();
            int n3 = n - 1 - this._stackPointer > 15 ? this._stackPointer + 15 : n - 1;
            int n4 = this._stackPointer + 1;
            while (n4 <= n3) {
                arrayList.add(this.findOrCreateAction((NavigationPoint)this._STACK.get(n4)));
                ++n4;
            }
            ideAction.putValue("ActionMenuActions", arrayList.toArray(new Action[arrayList.size()]));
            if (arrayList.size() > 0) {
                this.updateForwardTooltip((Action)arrayList.get(0));
            } else {
                this.updateForwardTooltip(null);
            }
            ideAction.updateAction();
        }
    }

    private void updateBackTooltip(Action action) {
        IdeAction ideAction = IdeAction.find(73);
        if (ideAction != null) {
            if (action != null) {
                String string = (String)action.getValue("ShortDescription");
                ideAction.putValue("ShortDescription", IdeArb.format(429, new String[]{string}));
            } else {
                ideAction.putValue("ShortDescription", IdeArb.getString(426));
            }
        }
    }

    private void updateForwardTooltip(Action action) {
        IdeAction ideAction = IdeAction.find(74);
        if (ideAction != null) {
            if (action != null) {
                String string = (String)action.getValue("ShortDescription");
                ideAction.putValue("ShortDescription", IdeArb.format(433, new String[]{string}));
            } else {
                ideAction.putValue("ShortDescription", IdeArb.getString(430));
            }
        }
    }

    private void updateLastEdit() {
        IdeAction ideAction = IdeAction.find(75);
        if (ideAction != null) {
            ideAction.setEnabled(this.canNavigateToLastEdit());
        }
    }

    private synchronized Action findOrCreateAction(NavigationPoint navigationPoint) {
        Action action = null;
        if (navigationPoint != null && (action = (Action)this._ACTION_MAP.get(navigationPoint)) == null) {
            action = new HistoryAction(navigationPoint);
            this._ACTION_MAP.put(navigationPoint, action);
        }
        return action;
    }

    public void editorOpened(Editor editor) {
    }

    public void editorDeactivated(Editor editor) {
    }

    public void editorClosed(Editor editor) {
    }

    public synchronized void editorActivated(Editor editor) {
        if (this._navigating == 0) {
            View view;
            NavigationPoint navigationPoint = this.getCurrentNavigationPoint();
            Context context = navigationPoint != null ? navigationPoint.getContext() : null;
            View view2 = view = context != null ? context.getView() : null;
            if (view == editor) {
                return;
            }
            Context context2 = context = editor != null ? editor.getContext() : null;
            if (context != null) {
                try {
                    EditorNavigationPoint editorNavigationPoint = this.createDefaultNavigationPoint(context);
                    if (editorNavigationPoint != null) {
                        this.navigateTo(editorNavigationPoint);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public synchronized void expired(NavigationPointEvent navigationPointEvent) {
        NavigationPoint navigationPoint;
        NavigationPoint navigationPoint2 = navigationPoint = navigationPointEvent != null ? (NavigationPoint)navigationPointEvent.getSource() : null;
        if (navigationPoint != null) {
            int n = this._STACK.indexOf(navigationPoint);
            if (n >= 0) {
                navigationPoint.removeNavigationPointListener(this);
                this._STACK.remove(navigationPoint);
                this._ACTION_MAP.remove(navigationPoint);
                if (this._stackPointer >= n) {
                    --this._stackPointer;
                }
                this.updateHistory();
            } else if (navigationPoint == this._lastEditLocation) {
                navigationPoint.removeNavigationPointListener(this);
                this._lastEditLocation = null;
                this.updateLastEdit();
            }
        }
    }

    public synchronized void descriptionChanged(NavigationPointEvent navigationPointEvent) {
        Action action;
        NavigationPoint navigationPoint = navigationPointEvent != null ? (NavigationPoint)navigationPointEvent.getSource() : null;
        Action action2 = action = navigationPoint != null ? (Action)this._ACTION_MAP.get(navigationPoint) : null;
        if (action != null) {
            int n;
            Object object = navigationPoint.getIcon();
            if (action.getValue("SmallIcon") != object) {
                action.putValue("SmallIcon", object);
            }
            object = navigationPoint.getLongLabel();
            if (action.getValue("Name") != object) {
                action.putValue("Name", object);
            }
            object = navigationPoint.getShortLabel();
            if (action.getValue("ShortDescription") != object) {
                action.putValue("ShortDescription", object);
            }
            if ((n = this._STACK.indexOf(navigationPoint)) == this._stackPointer - 1) {
                this.updateBackTooltip(action);
            } else if (n == this._stackPointer + 1) {
                this.updateForwardTooltip(action);
            }
        }
    }

    static void mav$navigationLevelChanged(NavigationManagerImpl navigationManagerImpl, int n) {
        navigationManagerImpl.navigationLevelChanged(n);
    }

    static int mav$jumpTo(NavigationManagerImpl navigationManagerImpl, NavigationPoint navigationPoint) {
        return navigationManagerImpl.jumpTo(navigationPoint);
    }

    public final class 1
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            int n = ((EnvironOptions)changeEvent.getSource()).getNavigationLevel();
            NavigationManagerImpl.mav$navigationLevelChanged(NavigationManagerImpl.this, n);
        }
    }

    private final class HistoryAction
    extends ToggleAction {
        NavigationPoint point;

        HistoryAction(NavigationPoint navigationPoint) {
            super(navigationPoint.getLongLabel(), navigationPoint.getIcon());
            this.point = navigationPoint;
            this.putValue("ShortDescription", navigationPoint.getShortLabel());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                NavigationManagerImpl.mav$jumpTo(NavigationManagerImpl.this, this.point);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

