/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.navigator;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockingParam;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Connections;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.resource.IdeArb;
import oracle.ideimpl.resource.IdeImplMenuArb;
import oracle.ideri.navigator.DefaultNavigatorManager;
import oracle.ideri.navigator.DefaultNavigatorWindow;
import oracle.ideri.util.Product;

public class ConnectionNavigatorManager
extends DefaultNavigatorManager {
    private static final int TOGGLE_TOOLBAR_CMD_ID = Ide.findOrCreateCmdID("ConnectionNavigator.TOGGLE_TOOLBAR_CMD_ID");
    private static final String CONNECTION_NAVIGATOR_WINDOW_ID = "ConnectionNavigatorWindow";

    public void initialize() {
        super.initialize();
        IdeAction ideAction = this.getShowAction();
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = menubar.createMenuItem(ideAction, MenuConstants.WEIGHT_VIEW_CONNECTION_NAVIGATOR);
        JMenu jMenu = MenuManager.getJMenu("View");
        menubar.add(jMenuItem, jMenu, MenuConstants.SECTION_VIEW_NAVIGATOR);
    }

    protected String getViewCategory() {
        return CONNECTION_NAVIGATOR_WINDOW_ID;
    }

    protected String getAcceleratorFile() {
        return "oracle/ideimpl/navigator/cn-accelerators.xml";
    }

    protected String getDefaultName() {
        return "Connections";
    }

    protected IdeAction createShowNavigatorAction() {
        return IdeAction.get(66, AddinManager.getAddinManager().getCommand(66, "oracle.ide.cmd.NotImplementedCommand"), IdeArb.getString(161), IdeMainWindow.ACTION_CATEGORY_VIEW, IdeArb.getInteger(162), IdeArb.getInstance(), 163, null, true);
    }

    protected DockingParam createNavigatorDockingParam() {
        DockingParam dockingParam = new DockingParam();
        NavigatorManager navigatorManager = NavigatorManager.getWorkspaceNavigatorManager();
        if (navigatorManager.getNavigatorWindow() != null) {
            dockingParam.setTabbedWith(navigatorManager.getNavigatorWindow());
        } else {
            ExplorerManager explorerManager = ExplorerManager.getExplorerManager();
            Dockable dockable = null;
            if (explorerManager != null) {
                ViewId viewId = explorerManager.getDefaultViewId();
                dockable = DockStation.getDockStation().findDockable(viewId);
            }
            dockingParam.setPosition(dockable, 2, 0);
            NavigatorManager.setWorkspaceNavigatorManager(this);
        }
        return dockingParam;
    }

    protected float getToggleToolbarMenuWeight() {
        return MenuConstants.WEIGHT_VIEW_CONNECTION_NAVIGATOR;
    }

    protected IdeAction createToggleToolbarAction() {
        return IdeAction.get(TOGGLE_TOOLBAR_CMD_ID, null, IdeImplMenuArb.getString(7), IdeMainWindow.ACTION_CATEGORY_VIEW, IdeImplMenuArb.getInteger(8), IdeImplMenuArb.getInstance(), 4, null, true);
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_ideconnectionnavigator_html");
    }

    protected void configureNavigator(NavigatorWindow navigatorWindow) {
    }

    protected NavigatorWindow createNavigatorWindow() {
        boolean bl = Product.isRaptor() ^ true;
        Connections connections = (Connections)Ide.getSystem().getChild(Connections.class);
        if (connections != null) {
            return this.createNavigatorWindow(connections, bl, 1);
        }
        return null;
    }

    protected DefaultNavigatorWindow createNavigatorWindow(Context context, ViewId viewId) {
        return Product.isRaptor() ? new 1(context, viewId.getId()) : super.createNavigatorWindow(context, viewId);
    }

    public final class 1
    extends DefaultNavigatorWindow {
        public String getTitleName() {
            return this.getTabName();
        }

        public 1(Context context, String string) {
            super(context, string);
        }
    }
}

