/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.net;

import java.net.URLStreamHandlerFactory;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import oracle.ide.net.IdeURLStreamHandlerFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;

public final class URLFileSystemHook
extends ExtensionHook {
    private static final String NS = "http://xmlns.oracle.com/jdeveloper/hooks/urlfilesystem";
    private static final ElementName ELEMENT = new ElementName("http://xmlns.oracle.com/jdeveloper/hooks/urlfilesystem", "urlfilesystem-hook");
    private static final ElementName STREAMFACTORY = new ElementName("http://xmlns.oracle.com/jdeveloper/hooks/urlfilesystem", "streamfactory");
    private static final ElementName FSHELPER = new ElementName("http://xmlns.oracle.com/jdeveloper/hooks/urlfilesystem", "fshelper");
    private final ElementVisitor _streamFactoryHandler;
    private final ElementVisitor _helperHandler;

    void $init$() {
        this._streamFactoryHandler = new StreamFactoryHandler(null);
        this._helperHandler = new HelperHandler(null);
    }

    public void start(ElementStartContext elementStartContext) {
        elementStartContext.registerChildVisitor(STREAMFACTORY, this._streamFactoryHandler);
        elementStartContext.registerChildVisitor(FSHELPER, this._helperHandler);
    }

    public URLFileSystemHook() {
        this.$init$();
    }

    private class StreamFactoryHandler
    extends ElementVisitor {
        public void start(ElementStartContext elementStartContext) {
            String string = elementStartContext.getAttributeValue("class");
            if (string == null) {
                elementStartContext.getLogger().severe("Missing required attribute 'class'");
                return;
            }
            try {
                Class<?> clazz = Class.forName(string);
                URLStreamHandlerFactory uRLStreamHandlerFactory = (URLStreamHandlerFactory)clazz.newInstance();
                IdeURLStreamHandlerFactory.addFactory(uRLStreamHandlerFactory);
            }
            catch (Exception exception) {
                elementStartContext.getLogger().severe("Failed to create stream factory class " + string);
            }
        }

        private StreamFactoryHandler() {
        }

        StreamFactoryHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class HelperHandler
    extends ElementVisitor {
        public void start(ElementStartContext elementStartContext) {
            String string = elementStartContext.getAttributeValue("protocol");
            String string2 = elementStartContext.getAttributeValue("class");
            if (string == null) {
                elementStartContext.getLogger().severe("Required attribute protocol missing from helper");
                return;
            }
            if (string2 == null) {
                elementStartContext.getLogger().severe("Required attribute class missing from helper");
                return;
            }
            try {
                Class<?> clazz = Class.forName(string2);
                URLFileSystemHelper uRLFileSystemHelper = (URLFileSystemHelper)clazz.newInstance();
                URLFileSystem.registerHelper(string, uRLFileSystemHelper);
            }
            catch (Exception exception) {
                elementStartContext.getLogger().severe("Failed to create helper class " + string2);
            }
        }

        private HelperHandler() {
        }

        HelperHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

