/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseListener;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import oracle.ide.palette.PalettePage;
import oracle.ideimpl.palette.HorizontalScroll;
import oracle.ideimpl.palette.IconPanel;
import oracle.ideimpl.palette.PaletteItemImpl;
import oracle.ideimpl.palette.PaletteItemUI;
import oracle.ideimpl.palette.model.Item;
import oracle.ideimpl.resource.PaletteArb;

public class HorizontalPanel
extends IconPanel
implements MouseListener {
    private final JPanel _middlePanel;
    private final BorderLayout _borderLayout2;
    private final JPanel _toolbar;
    private HorizontalScroll _scrollPane;
    private final GridBagLayout _gridBagLayout1;
    private ImageIcon _activeLeftArrowIcon;
    private ImageIcon _activeRightArrowIcon;
    private final JButton _leftBtn;
    private final JButton _rightBtn;

    void $init$() {
        this._middlePanel = new JPanel();
        this._borderLayout2 = new BorderLayout();
        this._toolbar = new JPanel();
        this._gridBagLayout1 = new GridBagLayout();
        this._activeLeftArrowIcon = (ImageIcon)PaletteArb.getIcon(38);
        this._activeRightArrowIcon = (ImageIcon)PaletteArb.getIcon(36);
        this._leftBtn = new JButton(this._activeLeftArrowIcon);
        this._rightBtn = new JButton(this._activeRightArrowIcon);
    }

    public HorizontalPanel(PalettePage palettePage) {
        super(palettePage);
        this.$init$();
        this._toolbar.addMouseListener(this);
        this._leftBtn.addMouseListener(this);
        this._rightBtn.addMouseListener(this);
        this._leftBtn.setToolTipText("Scroll Left");
        this._rightBtn.setToolTipText("Scroll Right");
        this._toolbar.setLayout(new BoxLayout(this._toolbar, 0));
        this._scrollPane = new HorizontalScroll(this._toolbar, this._leftBtn, this._rightBtn);
    }

    public void setup(JComboBox jComboBox) {
        this._leftBtn.setBorderPainted(false);
        this._rightBtn.setBorderPainted(false);
        this._leftBtn.setMargin(new Insets(1, 1, 1, 1));
        this._rightBtn.setMargin(new Insets(1, 1, 1, 1));
        this._toolbar.setAutoscrolls(true);
        this._scrollPane.setBorder(null);
        this.setLayout(this._gridBagLayout1);
        this._middlePanel.setLayout(this._borderLayout2);
        this.add((Component)this._middlePanel, new GridBagConstraints(1, 0, 1, 1, 0.9, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this._middlePanel.add((Component)this._leftBtn, "West");
        this._middlePanel.add((Component)this._scrollPane, "Center");
        this._middlePanel.add((Component)this._rightBtn, "East");
        this._leftBtn.setVisible(false);
    }

    void removeChildren() {
        this._toolbar.removeAll();
    }

    public void addIconLabels(boolean bl) {
        for (PaletteItemUI paletteItemUI : this.getIconList()) {
            if (bl) {
                paletteItemUI.setText(paletteItemUI.getItem().getShortLabel());
            } else {
                paletteItemUI.setText("");
            }
            this._toolbar.add(paletteItemUI);
        }
    }

    public void useListView(boolean bl) {
        this.setListView(bl);
        Iterator iterator = this.getIconList().iterator();
        if (bl) {
            this.getPalettePage().setView("list");
        } else {
            this.getPalettePage().setView("icon");
        }
        while (iterator.hasNext()) {
            PaletteItemUI paletteItemUI = (PaletteItemUI)iterator.next();
            PaletteItemImpl paletteItemImpl = paletteItemUI.getItem();
            if (bl) {
                paletteItemUI.setText(paletteItemImpl.getShortLabel());
                continue;
            }
            paletteItemUI.setText("");
        }
        this._toolbar.revalidate();
    }

    public void addItem(Item item) {
        PaletteItemUI paletteItemUI = new PaletteItemUI(new PaletteItemImpl(item));
        this.getIconList().add(paletteItemUI);
        this._toolbar.add(paletteItemUI);
        this.useListView(this.getListView());
    }

    public void removeItem(Item item) {
        for (PaletteItemUI paletteItemUI : this.getIconList()) {
            if (paletteItemUI.getItem().getItem() != item) continue;
            this._toolbar.remove(paletteItemUI);
        }
    }

    public void removeActiveItem() {
        this._toolbar.remove(this._controller.getPaletteUI().getActivePaletteItemUI());
        this._toolbar.repaint();
        this._toolbar.validate();
    }

    public void validateScroll() {
    }
}

