/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JViewport;
import oracle.bali.ewt.button.ContinuousButtonModel;
import oracle.ideimpl.palette.PaletteScroll;

public class HorizontalScroll
extends PaletteScroll {
    private JButton _leftBtn;
    private JButton _rightBtn;
    private LeftButtonModel _leftModel;
    private RightButtonModel _rightModel;

    void $init$() {
        this._leftModel = null;
        this._rightModel = null;
    }

    public HorizontalScroll(JPanel jPanel, JButton jButton, JButton jButton2) {
        super(jPanel);
        this.$init$();
        this._leftBtn = jButton;
        this._rightBtn = jButton2;
        this._leftModel = new LeftButtonModel(this._leftBtn);
        this._rightModel = new RightButtonModel(this._rightBtn);
        jButton.addMouseListener(this);
        jButton2.addMouseListener(this);
        this.getHorizontalScrollBar().addAdjustmentListener(this);
    }

    public void moveLeft() {
    }

    public void moveRight() {
    }

    public boolean canMoveLeft() {
        return false;
    }

    public boolean canMoveRight() {
        return false;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this._leftBtn) {
            this._leftModel.setPressed(true);
        } else {
            this._rightModel.setPressed(true);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this._leftModel.setPressed(false);
        this._rightModel.setPressed(false);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        JViewport jViewport = this.getViewport();
        Rectangle rectangle = jViewport.getViewRect();
        double d = rectangle.getWidth();
        Dimension dimension = jViewport.getViewSize();
        double d2 = dimension.getWidth();
        Rectangle rectangle2 = new Rectangle(0, (int)(dimension.getHeight() - rectangle.getHeight()), (int)rectangle.getWidth(), (int)rectangle.getHeight());
        jViewport.scrollRectToVisible(rectangle2);
        if (rectangle.getX() == 0.0) {
            this._leftBtn.setVisible(false);
        } else {
            this._leftBtn.setVisible(true);
        }
        this._checkRight();
    }

    private void _checkRight() {
        JViewport jViewport = this.getViewport();
        Rectangle rectangle = jViewport.getViewRect();
        double d = rectangle.getWidth();
        if (d > 0.0) {
            Component[] componentArray = this.getPanel().getComponents();
            int n = 0;
            while (n < componentArray.length) {
                Rectangle rectangle2 = componentArray[n].getBounds();
                int n2 = (int)rectangle.getWidth() + rectangle.x;
                int n3 = rectangle2.x + (int)rectangle2.getWidth();
                if (n3 > n2) {
                    this._rightBtn.setVisible(true);
                } else {
                    this._rightBtn.setVisible(false);
                }
                ++n;
            }
        }
    }

    static JButton ra$_rightBtn(HorizontalScroll horizontalScroll) {
        return horizontalScroll._rightBtn;
    }

    public class LeftButtonModel
    extends ContinuousButtonModel {
        protected LeftButtonModel(AbstractButton abstractButton) {
            super(abstractButton, 200, null);
        }

        protected void processPulse() {
            boolean bl = false;
            Rectangle rectangle = null;
            JViewport jViewport = HorizontalScroll.this.getViewport();
            Rectangle rectangle2 = jViewport.getViewRect();
            double d = rectangle2.getWidth();
            if (d > 0.0) {
                Component[] componentArray = HorizontalScroll.this.getPanel().getComponents();
                int n = 0;
                while (n < componentArray.length) {
                    Rectangle rectangle3 = componentArray[n].getBounds();
                    if (!rectangle2.contains(rectangle3) && rectangle2.x > rectangle3.x) {
                        rectangle = rectangle3;
                    } else if (rectangle != null) {
                        HorizontalScroll.this.getPanel().scrollRectToVisible(rectangle);
                        break;
                    }
                    ++n;
                }
            }
        }
    }

    public class RightButtonModel
    extends ContinuousButtonModel {
        protected RightButtonModel(AbstractButton abstractButton) {
            super(abstractButton, 200, null);
        }

        protected void processPulse() {
            boolean bl = false;
            JViewport jViewport = HorizontalScroll.this.getViewport();
            Rectangle rectangle = jViewport.getViewRect();
            double d = rectangle.getWidth();
            if (d > 0.0) {
                Component[] componentArray = HorizontalScroll.this.getPanel().getComponents();
                int n = 0;
                while (n < componentArray.length) {
                    Rectangle rectangle2 = componentArray[n].getBounds();
                    int n2 = (int)rectangle.getWidth() + rectangle.x;
                    int n3 = rectangle2.x + (int)rectangle2.getWidth();
                    if (n3 > n2) {
                        HorizontalScroll.this.getPanel().scrollRectToVisible(rectangle2);
                        if (n != componentArray.length - 1) break;
                        HorizontalScroll.ra$_rightBtn(HorizontalScroll.this).setVisible(false);
                        break;
                    }
                    ++n;
                }
            }
        }
    }
}

