/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.palette.PalettePage;
import oracle.ideimpl.palette.PaletteController;
import oracle.ideimpl.palette.PaletteItemImpl;
import oracle.ideimpl.palette.PaletteItemUI;
import oracle.ideimpl.palette.PalettePageImpl;
import oracle.ideimpl.palette.model.Item;

public abstract class IconPanel
extends JPanel
implements Observer,
MouseListener {
    protected final PaletteController _controller;
    protected boolean _listView;
    protected ArrayList _iconList;
    protected PalettePage _palettePage;

    void $init$() {
        this._controller = PaletteController.getInstance();
        this._listView = false;
        this._iconList = new ArrayList();
    }

    public IconPanel(PalettePage palettePage) {
        this.$init$();
        this.addMouseListener(this);
        this.setPalettePage(palettePage);
        HelpSystem helpSystem = HelpSystem.getHelpSystem();
        if (helpSystem != null) {
            helpSystem.registerTopic(this, "f1_idecomponentpalette_html");
        }
    }

    abstract void removeChildren();

    public abstract void addIconLabels(boolean var1);

    public abstract void useListView(boolean var1);

    protected void setIconList(ArrayList arrayList) {
        this._iconList = arrayList;
    }

    public ArrayList getIconList() {
        return this._iconList;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this._controller.getPalette().setActivePage(this.getPalettePage());
        this._controller.tryPopup(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this._controller.getPalette().setActivePage(this.getPalettePage());
        this._controller.tryPopup(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof JButton) {
            ((JButton)mouseEvent.getSource()).setBorderPainted(true);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof JButton) {
            ((JButton)mouseEvent.getSource()).setBorderPainted(false);
        }
    }

    private void setPalettePage(PalettePage palettePage) {
        if (this._palettePage != null) {
            this._palettePage.detach(this);
        }
        this._palettePage = palettePage;
        if (this._palettePage != null) {
            this._palettePage.attach(this);
        }
    }

    public PalettePage getPalettePage() {
        return this._palettePage;
    }

    public void setListView(boolean bl) {
        this._listView = bl;
    }

    public boolean getListView() {
        return this._listView;
    }

    protected void refreshList() {
        this._iconList = new ArrayList();
        if (this._palettePage == null) {
            return;
        }
        Iterator iterator = this._palettePage.getPaletteItems().iterator();
        this._iconList.add(new PaletteItemUI(new PaletteItemImpl(true)));
        while (iterator.hasNext()) {
            PaletteItemImpl paletteItemImpl = (PaletteItemImpl)iterator.next();
            if (paletteItemImpl == null) continue;
            this._iconList.add(new PaletteItemUI(paletteItemImpl));
        }
        this.setIconList(this._iconList);
        this.removeChildren();
        this.addIconLabels(this.getListView());
    }

    protected void populateIconList() {
        if (this._iconList.size() == 0) {
            Iterator iterator = this._palettePage.getPaletteItems().iterator();
            this._iconList.add(new PaletteItemUI(new PaletteItemImpl(true)));
            while (iterator.hasNext()) {
                PaletteItemImpl paletteItemImpl = (PaletteItemImpl)iterator.next();
                if (paletteItemImpl == null) continue;
                this._iconList.add(new PaletteItemUI(paletteItemImpl));
            }
            this.setIconList(this._iconList);
        }
    }

    public abstract void addItem(Item var1);

    public abstract void removeActiveItem();

    public abstract void removeItem(Item var1);

    public void renameItem(String string, PaletteItemImpl paletteItemImpl) {
        for (PaletteItemUI paletteItemUI : this._iconList) {
            if (paletteItemUI.getItem().getShortLabel().equals(string)) {
                paletteItemUI.setItem(paletteItemImpl);
                paletteItemUI.showLabel(this.getListView());
            }
            paletteItemUI.validate();
        }
    }

    public abstract void setup(JComboBox var1);

    public void refreshListView() {
        this.useListView(this.getListView());
    }

    public abstract void validateScroll();

    public void update(Object object, UpdateMessage updateMessage) {
        PalettePageImpl palettePageImpl = (PalettePageImpl)object;
        this.setVisible(palettePageImpl.canShow());
        this.validateScroll();
        this.repaint();
    }

    public void detach() {
        if (this._palettePage != null) {
            this._palettePage.detach(this);
        }
    }
}

