/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette;

import java.awt.Component;
import java.net.URL;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.model.Element;
import oracle.ide.palette.Invokable;
import oracle.ide.palette.PaletteManager;
import oracle.ide.palette.PalettePage;
import oracle.ideimpl.palette.PaletteController;
import oracle.ideimpl.palette.PaletteImpl;
import oracle.ideimpl.palette.PaletteItemImpl;
import oracle.ideimpl.palette.PaletteManagerImpl;
import oracle.ideimpl.palette.palettexml.PaletteXML;
import oracle.ideimpl.palette.wizard.WizardManager;
import oracle.ideimpl.resource.PaletteArb;

public final class PaletteCommands {
    private static final WizardManager _wizardManager = WizardManager.getInstance();
    private final PaletteController _controller;
    private final PaletteImpl _palette;

    void $init$() {
        this._controller = PaletteController.getInstance();
        this._palette = PaletteImpl.getInstance();
    }

    public void invokeItemWizard(PalettePage palettePage) {
        this._palette.setEditPage(palettePage);
        String string = palettePage.getType();
        String[] stringArray = new String[]{"palette"};
        Invokable invokable = _wizardManager.getWizard(string);
        Context context = Ide.getMainWindow().getIdeMainWindowView().getContext();
        Element[] elementArray = new Element[]{palettePage};
        context.setSelection(elementArray);
        if (invokable != null) {
            invokable.invoke(context, stringArray);
            PaletteManagerImpl paletteManagerImpl = PaletteManagerImpl.getInstance();
            ((PaletteManager)paletteManagerImpl).updatePaletteUI();
        } else {
            MessageDialog.error((Component)((Object)Ide.getMainWindow()), "There is no editor associated with " + string + " pages.", "Error", null);
        }
    }

    public static boolean hasEditor(String string) {
        Invokable invokable = _wizardManager.getWizard(string);
        return invokable != null;
    }

    public boolean removePaletteItem() {
        String string;
        String string2 = this._controller.getPalette().getActiveItem().getShortLabel();
        PaletteItemImpl paletteItemImpl = (PaletteItemImpl)this._palette.getPaletteItem(string2, string = this._controller.getPalette().getActivePage().getShortLabel());
        boolean bl = paletteItemImpl.getCanRemove();
        if (!bl) {
            MessageDialog.error((Component)((Object)Ide.getMainWindow()), "This item must not be removed from the Component Palette.", "Error", null);
            return false;
        }
        boolean bl2 = MessageDialog.confirm((Component)((Object)Ide.getMainWindow()), PaletteArb.format(95, "\"" + string2 + "\"", "\"" + string + "\""), PaletteArb.getString(94), null, true);
        if (bl2) {
            this._palette.removeItem(string2, string);
            return true;
        }
        return false;
    }

    public boolean removePalettePage() {
        PalettePage palettePage = this._palette.getActivePage();
        String string = palettePage.getShortLabel();
        boolean bl = palettePage.getCanRemove();
        if (bl) {
            boolean bl2 = MessageDialog.confirm((Component)((Object)Ide.getMainWindow()), PaletteArb.format(93, "\"" + string + "\""), PaletteArb.getString(92), null, true);
            if (bl2) {
                this._palette.remove(this._palette.getActivePage());
                return true;
            }
        } else {
            MessageDialog.error((Component)((Object)Ide.getMainWindow()), "This page must not be removed from the Component Palette.", "Error", null);
        }
        return false;
    }

    public PaletteImpl getPalette() {
        return this._palette;
    }

    public URL getURLFromPackage(String string) {
        URL uRL = null;
        try {
            uRL = this.getClass().getResource(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return uRL;
    }

    public boolean pageIsValid(String string, Component component) {
        if (PaletteXML.getPage(string) != null) {
            MessageDialog.information(component, "Palette page \"" + string + "\" exists.  Please use a different name.", "Error", null);
            return false;
        }
        String string2 = string.trim();
        if (string2.length() == 0) {
            MessageDialog.information(component, "You must provide a name for your palette page.", "Error", null);
            return false;
        }
        return true;
    }

    public PaletteCommands() {
        this.$init$();
    }
}

