/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ImageIcon;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.net.URLFactory;
import oracle.ide.palette.Palette;
import oracle.ide.palette.PaletteEvent;
import oracle.ide.palette.PalettePage;
import oracle.ideimpl.palette.PageNotFoundPanel;
import oracle.ideimpl.palette.PaletteImpl;
import oracle.ideimpl.palette.PaletteItemUI;
import oracle.ideimpl.palette.PaletteManagerImpl;
import oracle.ideimpl.palette.PalettePageImpl;
import oracle.ideimpl.palette.PaletteUI;
import oracle.ideimpl.palette.PaletteWindowImpl;
import oracle.ideimpl.palette.model.History;
import oracle.ideimpl.palette.palettexml.PaletteXML;
import oracle.ideimpl.palette.wizard.WizardManager;

public class PaletteController
implements Controller {
    public static final int NEW_PALETTE_CMD_ID = Ide.findOrCreateCmdID("ComponentPaletteCommand");
    public static final int PALETTE_PROPERTIES_CMD_ID = Ide.findOrCreateCmdID("PaletteController.PALETTE_PROPERTIES_CMD_ID");
    private final PaletteImpl _palette;
    private final PaletteManagerImpl _mgr;
    private PaletteWindowImpl _paletteWindow;
    private PaletteUI _paletteUI;
    private final HashMap _historyHash;
    private static PaletteController _singleton;
    private static final Object __LOCK__;
    private boolean _stickyMode;
    public static final String java = "java";
    public static final String jsp = "jsp";

    static {
        __LOCK__ = new Object();
    }

    void $init$() {
        this._palette = PaletteImpl.getInstance();
        this._mgr = PaletteManagerImpl.getInstance();
        this._historyHash = new HashMap();
        this._stickyMode = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PaletteController getInstance() {
        Object object = __LOCK__;
        synchronized (object) {
            if (_singleton == null) {
                PaletteController paletteController;
                _singleton = paletteController = new PaletteController();
                PaletteController paletteController2 = paletteController;
                return paletteController2;
            }
        }
        return _singleton;
    }

    public void setPaletteUI(PaletteUI paletteUI) {
        this._paletteUI = paletteUI;
    }

    public PaletteUI getPaletteUI() {
        return this._paletteUI;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }

    protected void shutdown() {
        if (this._palette.getHasPopulated() && this._palette.isDirty() || PaletteXML.isDirty()) {
            if (!this._palette.getHasPopulated()) {
                this._palette.populate();
            }
            for (String string : this.getHistoryHash().keySet()) {
                String string2 = (String)this.getHistoryHash().get(string);
                History history = PaletteXML.getHistory(string);
                if (history == null) {
                    history = new History();
                    history.setPageType(string);
                    history.setPalettePage(string2);
                    PaletteXML.addHistory(history);
                    continue;
                }
                history.setPalettePage(string2);
            }
            try {
                PaletteXML.removeAllPages();
                Iterator iterator = this._palette.getChildren();
                while (iterator.hasNext()) {
                    PalettePage palettePage = (PalettePage)iterator.next();
                    if (!palettePage.isPersistent() || !(palettePage instanceof PalettePageImpl)) continue;
                    PalettePageImpl palettePageImpl = (PalettePageImpl)palettePage;
                    PaletteXML.addPage(palettePageImpl.getPageModel());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                PaletteXML.savePaletteXml();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void setPaletteWindow(PaletteWindowImpl paletteWindowImpl) {
        this._paletteWindow = paletteWindowImpl;
    }

    public PaletteWindowImpl getPaletteWindow() {
        return this._paletteWindow;
    }

    public boolean tryPopup(MouseEvent mouseEvent) {
        return this.getPaletteWindow().tryPopup(mouseEvent);
    }

    protected void fireItemPressed() {
        this.getPaletteWindow().fireItemPressed(new PaletteEvent(this._palette, "ITEM_PRESSED"));
    }

    public void reset() {
        if (!this.getStickyMode()) {
            Editor editor;
            if (this.getPaletteUI() != null && this.getPaletteUI().getActiveIconPanel() != null) {
                ArrayList arrayList = this.getPaletteUI().getActiveIconPanel().getIconList();
                for (PaletteItemUI paletteItemUI : arrayList) {
                    if (paletteItemUI.getItem().isPointer()) {
                        paletteItemUI.handleItem();
                        paletteItemUI.showSelectedMode();
                        continue;
                    }
                    paletteItemUI.showAsUnselected();
                }
            }
            if ((editor = EditorManager.getEditorManager().getCurrentEditor()) != null) {
                editor.getGUI().requestFocus();
            }
        }
    }

    public void addToHistoryHash(String string, String string2) {
        this._historyHash.put(string, string2);
    }

    HashMap getHistoryHash() {
        return this._historyHash;
    }

    public String getPalettePageName(String string) {
        String string2 = (String)this._historyHash.get(string);
        if (string2 == null) {
            string2 = this._mgr.getPageForDocument(string);
        }
        return string2;
    }

    public Palette getPalette() {
        return this._palette;
    }

    public void setStickyMode(boolean bl) {
        if (this.getStickyMode() && !bl) {
            this.getPaletteWindow().fireStickyModeDeactivated(new PaletteEvent(this._palette, "STICKY_MODE_DEACTIVATED"));
        }
        if (bl) {
            this.getPaletteWindow().fireStickyModeActivated(new PaletteEvent(this._palette, "STICKY_MODE_ACTIVATED"));
        }
        this._stickyMode = bl;
    }

    public boolean getStickyMode() {
        return this._stickyMode;
    }

    public void refreshPalette() {
        if (this.getPaletteUI() != null && this.getPaletteUI().getActiveIconPanel() != null && !(this.getPaletteUI().getActiveIconPanel() instanceof PageNotFoundPanel)) {
            boolean bl = this.getPaletteUI().getActiveIconPanel().getListView();
            this.getPaletteUI().getActiveIconPanel().useListView(bl);
            this.getPaletteUI().refreshCombo();
        }
    }

    public void refreshPaletteUI() {
        if (this.getPaletteUI() != null && this.getPaletteUI().getActiveIconPanel() != null && !(this.getPaletteUI().getActiveIconPanel() instanceof PageNotFoundPanel)) {
            this.getPaletteUI().refreshCombo();
        }
    }

    public ImageIcon getDefinedImage(String string) {
        try {
            Toolkit toolkit;
            Image image;
            URL uRL = null;
            int n = string.indexOf("!");
            uRL = n != -1 ? ((string = string.replace('\\', '/')).indexOf("file:") != -1 ? new URL("jar:" + string) : new URL("jar:file:/" + string)) : this.getClass().getResource(string);
            if (uRL == null) {
                File file = new File(string);
                uRL = file.exists() ? file.toURL() : URLFactory.newURL(string);
            }
            if (uRL != null && (image = (toolkit = Toolkit.getDefaultToolkit()).getImage(uRL)) != null) {
                ImageIcon imageIcon = new ImageIcon(image);
                return imageIcon;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Vector getList() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("All");
        Iterator iterator = WizardManager.getInstance().getTypes();
        while (iterator.hasNext()) {
            vector.addElement((String)iterator.next());
        }
        return vector;
    }

    public PaletteController() {
        this.$init$();
    }
}

