/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette;

import java.awt.dnd.DropTargetListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableEvent;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockableListener;
import oracle.ide.docking.DockingParam;
import oracle.ide.docking.Site;
import oracle.ide.docking.TitleChangeListener;
import oracle.ide.inspector.InspectorManager;
import oracle.ide.layout.Layout;
import oracle.ide.layout.ViewId;
import oracle.ide.util.PropertyAccess;
import oracle.ideimpl.palette.PaletteWindowImpl;
import oracle.ideimpl.resource.PaletteArb;

public class PaletteDockableFactory
implements DockableFactory {
    static DockableProxy DOCKABLE_PROXY;
    public static final String WEB_EDITING_LAYOUT_BASE_NAME = "Web Editing";

    public PaletteDockableFactory() {
        DockStation.getDockStation().registerDockableFactory("ComponentPalette", this);
    }

    public void install() {
        InspectorManager inspectorManager = InspectorManager.getInspectorManager();
        ViewId viewId = inspectorManager.getDefaultViewId();
        DockStation dockStation = DockStation.getDockStation();
        Dockable dockable = dockStation.findDockable(viewId);
        DockingParam dockingParam = new DockingParam();
        if (dockable != null) {
            dockingParam.setPosition(dockable, 2);
        } else {
            dockingParam.setPosition(1);
        }
        Dockable dockable2 = this.getDockable(null);
        dockStation.dock(dockable2, dockingParam);
    }

    public Dockable getDockable(ViewId viewId) {
        if (DOCKABLE_PROXY == null) {
            DOCKABLE_PROXY = new DockableProxy();
        }
        return DOCKABLE_PROXY;
    }

    private static class DockableProxy
    implements DockableListener,
    Dockable {
        private PaletteWindowImpl _paletteWindow;
        private PropertyAccess _properties;
        private Site _site;
        private String _title;

        void $init$() {
            this._site = new Site();
        }

        DockableProxy() {
            this.$init$();
            DockStation.getDockStation().addDockableListener(this, this);
        }

        public String getTitleName() {
            if (this._title == null) {
                this._title = PaletteArb.getString(27);
            }
            return this._title;
        }

        public String getTabName() {
            return PaletteArb.getString(28);
        }

        public Icon getTabIcon() {
            return PaletteArb.getIcon(30);
        }

        public String getUniqueName() {
            return "ComponentPalette";
        }

        public int getType() {
            return 0;
        }

        public Site getSite() {
            return this._site;
        }

        public void setSite(Site site) {
            this._site = site;
        }

        public JComponent getHostedComponent() {
            if (this._paletteWindow == null) {
                this._paletteWindow = PaletteWindowImpl.getInstance();
                this._paletteWindow.loadLayout(this._properties);
                this._properties = null;
                this._paletteWindow.checkIfPopulated();
            }
            return this._paletteWindow.getHostedComponent();
        }

        public void addTitleChangeListener(TitleChangeListener titleChangeListener) {
            if (this._paletteWindow != null) {
                this._paletteWindow.addTitleChangeListener(titleChangeListener);
            }
        }

        public void removeTitleChangeListener(TitleChangeListener titleChangeListener) {
            if (this._paletteWindow != null) {
                this._paletteWindow.removeTitleChangeListener(titleChangeListener);
            }
        }

        public void saveLayout(PropertyAccess propertyAccess) {
            if (this._paletteWindow != null) {
                this._paletteWindow.saveLayout(propertyAccess);
            }
        }

        public void loadLayout(PropertyAccess propertyAccess) {
            if (this._paletteWindow != null) {
                this._paletteWindow.loadLayout(propertyAccess);
            }
        }

        public void dockableHidden(DockableEvent dockableEvent) {
            if (this._paletteWindow != null) {
                this._paletteWindow.dockableHidden(dockableEvent);
            }
        }

        public void dockableShown(DockableEvent dockableEvent) {
            if (this._paletteWindow != null) {
                this._paletteWindow.dockableShown(dockableEvent);
            }
        }

        public DropTargetListener getTabDropListener() {
            return null;
        }

        public String getMenuTitle() {
            return this.getTabName();
        }

        public int getDefaultVisibility(Layout layout) {
            String string = layout.getProperty("Layout.ShowPalette", null);
            String string2 = layout.getProperty("Layout.RaisePalette", null);
            return (Boolean.valueOf(string) != false ? 1 : 0) | (Boolean.valueOf(string2) != false ? 4 : 0);
        }
    }
}

