/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.ide.model.Element;
import oracle.ide.palette.PaletteItem;
import oracle.ide.palette.PaletteModelListener;
import oracle.ide.palette.PalettePage;
import oracle.ideimpl.palette.PaletteItemImpl;
import oracle.ideimpl.palette.PaletteManagerImpl;
import oracle.ideimpl.palette.PalettePageImpl;
import oracle.ideimpl.palette.PaletteWindowImpl;
import oracle.ideimpl.palette.model.Page;
import oracle.ideimpl.palette.model.Palette;
import oracle.ideimpl.palette.palettexml.PaletteXML;
import oracle.ideimpl.resource.PaletteArb;

public final class PaletteImpl
extends oracle.ide.palette.Palette {
    private final String _title;
    private final ArrayList _list;
    private ArrayList _palettePages;
    private PaletteItemImpl _activeItem;
    private PalettePage _activePage;
    private boolean _hasPopulated;
    private String _pageType;
    private PalettePage _editPage;
    private boolean _isDirty;
    private static PaletteImpl _singleton = new PaletteImpl();

    void $init$() {
        this._title = PaletteArb.getString(27);
        this._list = new ArrayList();
        this._palettePages = new ArrayList();
        this._hasPopulated = false;
        this._isDirty = false;
    }

    public static PaletteImpl getInstance() {
        return _singleton;
    }

    public PaletteImpl() {
        this.$init$();
        this.setShortLabel(this.getTitle());
        this.setLongLabel(this.getTitle());
    }

    public Iterator getChildren() {
        if (!this._hasPopulated) {
            this.populate();
        }
        return this._palettePages.iterator();
    }

    public boolean add(Element element) {
        PalettePage palettePage = (PalettePage)element;
        boolean bl = this._palettePages.add(element);
        if (bl) {
            this.firePalettePageAdded(palettePage);
            this._isDirty = true;
        }
        return bl;
    }

    public PalettePage addPage(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, String string4) {
        if (this.getPalettePage(string) != null) {
            return this.getPalettePage(string);
        }
        Page page = new Page();
        page.setName(string);
        page.setShowForTypes(string2);
        page.setType(string3);
        page.setCanRemove(bl);
        page.setTechnologyScope(string4);
        if (bl2) {
            page.setView("list");
        } else {
            page.setView("icon");
        }
        PalettePageImpl palettePageImpl = new PalettePageImpl(page);
        ((PalettePage)palettePageImpl).setIsPersistent(bl3);
        this.add(palettePageImpl);
        return palettePageImpl;
    }

    public PalettePage addPage(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3) {
        if (this.getPalettePage(string) != null) {
            return this.getPalettePage(string);
        }
        Page page = new Page();
        page.setName(string);
        page.setShowForTypes(string2);
        page.setType(string3);
        page.setCanRemove(bl);
        if (bl2) {
            page.setView("list");
        } else {
            page.setView("icon");
        }
        PalettePageImpl palettePageImpl = new PalettePageImpl(page);
        ((PalettePage)palettePageImpl).setIsPersistent(bl3);
        this.add(palettePageImpl);
        return palettePageImpl;
    }

    public boolean removePage(String string) {
        PalettePage palettePage = this.getPalettePage(string);
        if (palettePage != null) {
            return this.remove(palettePage);
        }
        return false;
    }

    public boolean remove(Element element) {
        PalettePage palettePage = (PalettePage)element;
        boolean bl = this._palettePages.remove(element);
        if (bl) {
            this.firePalettePageRemoved(palettePage);
            this._isDirty = true;
        }
        return bl;
    }

    public void removeItem(String string, String string2) {
        PalettePage palettePage = this.getPalettePage(string2);
        for (PaletteItemImpl paletteItemImpl : palettePage.getPaletteItems()) {
            if (!paletteItemImpl.getShortLabel().equals(string)) continue;
            palettePage.remove(paletteItemImpl);
            this.firePaletteItemRemoved(paletteItemImpl);
            this._isDirty = true;
            break;
        }
    }

    public void addItem(PaletteItem paletteItem) {
        this.getEditPage().add(paletteItem);
        this._isDirty = true;
    }

    public void addItems(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.getEditPage().add((PaletteItem)iterator.next());
        }
    }

    public boolean canRemove(Element element) {
        return true;
    }

    public boolean canAdd(Element element) {
        return true;
    }

    public boolean containsChild(Element element) {
        return this._palettePages.contains(element);
    }

    public int size() {
        return this._palettePages.size();
    }

    public void removeAll() {
        this._palettePages.clear();
    }

    public void populate() {
        Palette palette = PaletteXML.getPalette();
        if (palette != null) {
            Page[] pageArray = palette.getPage();
            if (pageArray != null) {
                int n = 0;
                while (n < pageArray.length) {
                    this.add(new PalettePageImpl(pageArray[n]));
                    ++n;
                }
            }
            this.setHasPopulated(true);
            PaletteManagerImpl.getInstance().addDeferredPages();
            this._isDirty = false;
        }
    }

    public void setActiveItem(PaletteItem paletteItem) {
        this._activeItem = (PaletteItemImpl)paletteItem;
        PaletteWindowImpl.getInstance().updateSelection();
    }

    public PaletteItem getActiveItem() {
        return this._activeItem;
    }

    public void setActivePage(PalettePage palettePage) {
        this._activePage = palettePage;
    }

    public PalettePage getActivePage() {
        return this._activePage;
    }

    public PalettePage getPalettePage(String string) {
        Iterator iterator = this.getChildren();
        while (iterator.hasNext()) {
            PalettePage palettePage = (PalettePage)iterator.next();
            if (!palettePage.getShortLabel().equals(string)) continue;
            return palettePage;
        }
        return null;
    }

    public PalettePage getPalettePage(String string, String string2) {
        Iterator iterator = this.getChildren();
        while (iterator.hasNext()) {
            PalettePage palettePage = (PalettePage)iterator.next();
            if (!palettePage.getShortLabel().equals(string) || !palettePage.getType().equals(string2)) continue;
            return palettePage;
        }
        return null;
    }

    public PaletteItem getPaletteItem(String string, String string2) {
        PalettePage palettePage = this.getPalettePage(string2);
        for (PaletteItemImpl paletteItemImpl : palettePage.getPaletteItems()) {
            if (!paletteItemImpl.getShortLabel().equalsIgnoreCase(string)) continue;
            return paletteItemImpl;
        }
        return null;
    }

    public boolean getHasPopulated() {
        return this._hasPopulated;
    }

    private void setHasPopulated(boolean bl) {
        this._hasPopulated = bl;
    }

    public void addPaletteModelListener(PaletteModelListener paletteModelListener) {
        this._list.add(paletteModelListener);
    }

    public void removePaletteModelListener(PaletteModelListener paletteModelListener) {
        this._list.remove(paletteModelListener);
    }

    public void firePalettePageAdded(PalettePage palettePage) {
        for (PaletteModelListener paletteModelListener : this._list) {
            paletteModelListener.palettePageAdded(palettePage);
        }
    }

    public void firePalettePageRemoved(PalettePage palettePage) {
        for (PaletteModelListener paletteModelListener : this._list) {
            paletteModelListener.palettePageRemoved(palettePage);
        }
    }

    public void firePaletteItemAdded(PaletteItem paletteItem) {
        for (PaletteModelListener paletteModelListener : this._list) {
            paletteModelListener.paletteItemAdded(paletteItem);
        }
    }

    public void firePaletteItemRemoved(PaletteItem paletteItem) {
        for (PaletteModelListener paletteModelListener : this._list) {
            paletteModelListener.paletteItemRemoved(paletteItem);
        }
    }

    public void firePaletteItemRenamed(String string, PaletteItem paletteItem) {
        for (PaletteModelListener paletteModelListener : this._list) {
            paletteModelListener.paletteItemRenamed(string, paletteItem);
        }
    }

    public void firePalettePageRenamed(String string, PalettePage palettePage) {
        for (PaletteModelListener paletteModelListener : this._list) {
            paletteModelListener.palettePageRenamed(string, palettePage);
        }
    }

    public String getTitle() {
        return this._title;
    }

    public ArrayList getList() {
        return this._list;
    }

    public void setPalettePages(ArrayList arrayList) {
        this._palettePages = arrayList;
    }

    public ArrayList getPalettePages() {
        return this._palettePages;
    }

    public void setSingleton(PaletteImpl paletteImpl) {
        _singleton = paletteImpl;
    }

    public PaletteImpl getSingleton() {
        return _singleton;
    }

    public void setPageType(String string) {
        this._pageType = string;
    }

    public String getPageType() {
        return this._pageType;
    }

    public void setEditPage(PalettePage palettePage) {
        this._editPage = palettePage;
    }

    public PalettePage getEditPage() {
        return this._editPage;
    }

    public boolean isDirty() {
        return this._isDirty;
    }

    public void setDirty(boolean bl) {
        this._isDirty = bl;
    }
}

