/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.InputEvent;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.EventObject;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ide.palette.Invokable;
import oracle.ide.palette.PaletteInvokable;
import oracle.ide.palette.PaletteItem;
import oracle.ide.palette.PaletteTransferable;
import oracle.ideimpl.palette.PaletteController;
import oracle.ideimpl.palette.model.Item;
import oracle.ideimpl.resource.PaletteArb;

public final class PaletteItemImpl
extends PaletteItem
implements Transferable {
    private static final DataFlavor[] FLAVORS = new DataFlavor[]{PaletteItem.PALETTE_ITEM_FLAVOR, DataFlavor.stringFlavor};
    private static final String DEFAULT_ICON = "/oracle/ideimpl/icons/images/palette/missingdefault.png";
    private boolean reset;
    private Item _item;
    private String _classpath;
    private String _info;
    private boolean _isPointer;
    private PaletteInvokable paletteInvokable;
    private final PaletteController _controller;
    private boolean _canShow;
    private String initializer;
    private String _iconURL;

    void $init$() {
        this.reset = false;
        this._isPointer = false;
        this.paletteInvokable = null;
        this._controller = PaletteController.getInstance();
        this._canShow = true;
    }

    public PaletteItemImpl(Item item) {
        this.$init$();
        this.setItem(item);
        try {
            this.setProperties();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public PaletteItemImpl(boolean bl) {
        this.$init$();
        if (bl) {
            this.reset = bl;
            this.setIcon(PaletteArb.getIcon(39));
            this.setClassPath(null);
            this.setShortLabel("Pointer");
            this.setLongLabel("Pointer");
            this.setIsPointer(true);
        }
    }

    private void setProperties() throws Exception {
        this.setLongLabel(this.getItem().getLongLabel());
        this.setShortLabel(this.getItem().getShortLabel());
        if (this.getItem().getBeanInfo() != null) {
            this.useBeanInfo();
        } else {
            this.setIcon(this.getItem().getIcon());
        }
        this.setInitializer(this.getItem().getInfo());
    }

    public String getClassName() {
        return this.getLongLabel();
    }

    public String getClassPath() {
        String string = this.getItem().getInfo();
        if (string == null) {
            return null;
        }
        int n = string.indexOf(",");
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    public String getLibrary() {
        return this.getItem().getLibrary();
    }

    public void setClassPath(String string) {
        this._classpath = string;
    }

    public boolean isResetItem() {
        return this.reset;
    }

    public boolean mayHaveChildren() {
        return false;
    }

    private void setInfo(String string) {
        this._info = string;
    }

    public String getInfo() {
        return this._info;
    }

    public Icon getIcon() {
        if (this._iconURL != null) {
            this.useDefinedImage(this._iconURL);
            if (this.icon == null) {
                this.useDefinedImage(DEFAULT_ICON);
            }
            this._iconURL = null;
        }
        return this.icon;
    }

    public void setIcon(String string) {
        this._iconURL = string;
    }

    public void setItem(Item item) {
        this._item = item;
    }

    public Item getItem() {
        return this._item;
    }

    private void useBeanInfo() {
        try {
            Class<?> clazz = Class.forName(this.getItem().getLongLabel());
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            ImageIcon imageIcon = new ImageIcon(beanInfo.getIcon(1));
            if (imageIcon != null) {
                this.setIcon(imageIcon);
            }
        }
        catch (Exception exception) {
            String string = this.getItem().getIcon();
            if (string == null) {
                string = DEFAULT_ICON;
            }
            this.useDefinedImage(string);
        }
    }

    private void useDefinedImage(String string) {
        if (string == null) {
            return;
        }
        try {
            Toolkit toolkit;
            Image image;
            File file;
            URL uRL = null;
            int n = string.indexOf("!");
            uRL = n != -1 ? ((string = string.replace('\\', '/')).indexOf("file:") == -1 ? new URL("jar:file:/" + string) : new URL("jar:" + string)) : this.getClass().getResource(string);
            if (uRL == null && (file = new File(string)).exists()) {
                uRL = file.toURL();
            }
            if (uRL != null && (image = (toolkit = Toolkit.getDefaultToolkit()).getImage(uRL)) != null) {
                this.setIcon(new ImageIcon(image));
            }
        }
        catch (Exception exception) {
            this.useDefaultIcon();
        }
    }

    private void useDefaultIcon() {
        URL uRL = this.getClass().getResource(DEFAULT_ICON);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.getImage(uRL);
        if (image != null) {
            this.setIcon(new ImageIcon(image));
        }
    }

    private void setIsPointer(boolean bl) {
        this._isPointer = bl;
    }

    public boolean isPointer() {
        return this._isPointer;
    }

    public void setCanShow(boolean bl) {
        this._canShow = bl;
        this.notifyObservers(this, null);
    }

    public boolean canShow() {
        return this._canShow;
    }

    public void setEditor(String string) {
        this._item.setEditor(string);
    }

    public String getEditor() {
        return this._item.getEditor();
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor == DataFlavor.stringFlavor) {
            Transferable transferable = this.getTrans(false, null);
            if (transferable == null) {
                return "";
            }
            return transferable.getTransferData(dataFlavor);
        }
        if (this.isDataFlavorSupported(dataFlavor)) {
            return this;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return FLAVORS;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        if (dataFlavor == DataFlavor.stringFlavor) {
            return true;
        }
        return PaletteItem.PALETTE_ITEM_FLAVOR == dataFlavor;
    }

    public Transferable getTrans(boolean bl, InputEvent inputEvent) {
        Context context = this._controller.getPaletteWindow().getContext();
        Element[] elementArray = new Element[]{this};
        context.setSelection(elementArray);
        String string = "";
        string = this._item.getInfo() == null ? "No Info!" : this._item.getInfo();
        try {
            Object obj;
            String string2 = this.getItem().getEditor();
            if (string2 != null && (obj = Class.forName(string2).newInstance()) instanceof PaletteTransferable) {
                PaletteTransferable paletteTransferable = (PaletteTransferable)obj;
                paletteTransferable.setContext(context);
                if (bl) {
                    Transferable transferable = paletteTransferable.getOptionalTransferable();
                    return transferable;
                }
                PaletteTransferable paletteTransferable2 = paletteTransferable;
                return paletteTransferable2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.paletteInvokable = (PaletteInvokable)Class.forName("oracle.jdevimpl.palette.PaletteProxy").newInstance();
            Object object = this.paletteInvokable.getPaletteEditor(context);
            if (object instanceof Transferable) {
                Transferable transferable = (Transferable)object;
                if (this.getItem().getType().equals("html") || this.getItem().getCodeSnippet() != null || this.getItem().getType().equalsIgnoreCase("custom")) {
                    string = this.getItem().getEditor();
                }
                if (object instanceof Invokable) {
                    EventObject eventObject = context.getEvent();
                    context.setEvent(inputEvent);
                    boolean bl2 = ((Invokable)object).invoke(context, new String[]{string, this.getShortLabel(), "DND"});
                    context.setEvent(eventObject);
                }
                Transferable transferable2 = transferable;
                return transferable2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    protected PaletteInvokable getPaletteInvokable() {
        return this.paletteInvokable;
    }

    public void setTechnologyScope(String string) {
        this._item.setTechnologyScope(string);
    }

    public String getTechnologyScope() {
        return this._item.getTechnologyScope();
    }

    public boolean getCanRemove() {
        return this._item.getCanRemove();
    }

    public boolean hasItem() {
        return this._item != null;
    }

    public String getItemIcon() {
        return this._item.getIcon();
    }

    public void setItemIcon(String string) {
        this._item.setIcon(string);
    }

    public String getItemShortLabel() {
        return this._item.getShortLabel();
    }

    public void setItemShortLabel(String string) {
        this._item.setShortLabel(string);
    }

    public String getItemLongLabel() {
        return this._item.getLongLabel();
    }

    public void setItemLongLabel(String string) {
        this._item.setLongLabel(string);
    }

    public String getItemInfo() {
        return this._item.getInfo();
    }

    public void setItemInfo(String string) {
        this._item.setInfo(string);
    }

    public String getItemType() {
        return this._item.getType();
    }

    public void setItemType(String string) {
        this._item.setType(string);
    }

    public float getItemWeight() {
        return this._item.getWeight();
    }

    public void setItemWeight(float f) {
        this._item.setWeight(f);
    }

    public String getItemEditor() {
        return this._item.getEditor();
    }

    public void setItemEditor(String string) {
        this._item.setEditor(string);
    }

    public String getItemLibrary() {
        return this._item.getLibrary();
    }

    public void setItemLibrary(String string) {
        this._item.setLibrary(string);
    }

    public String getItemBeanInfo() {
        return this._item.getBeanInfo();
    }

    public void setItemBeanInfo(String string) {
        this._item.setBeanInfo(string);
    }

    public String getItemCodeSnippet() {
        return this._item.getCodeSnippet();
    }

    public void setItemCodeSnippet(String string) {
        this._item.setCodeSnippet(string);
    }

    public boolean getItemIsPersistent() {
        return this._item.getIsPersistent();
    }

    public void setItemIsPersistent(boolean bl) {
        this._item.setIsPersistent(bl);
    }

    public String getItemHelpable() {
        return this._item.getHelpable();
    }

    public void setItemHelpable(String string) {
        this._item.setHelpable(string);
    }

    public String getItemProjectConfiguration() {
        return this._item.getProjectConfiguration();
    }

    public void setItemProjectConfiguration(String string) {
        this._item.setProjectConfiguration(string);
    }

    public String getItemTechnologyScope() {
        return this._item.getTechnologyScope();
    }

    public void setItemTechnologyScope(String string) {
        this._item.setTechnologyScope(string);
    }

    public boolean getItemCanRemove() {
        return this._item.getCanRemove();
    }

    public void setItemCanRemove(boolean bl) {
        this._item.setCanRemove(bl);
    }

    public String getInitializer() {
        return this.initializer;
    }

    public void setInitializer(String string) {
        try {
            if (string != null) {
                int n = string.indexOf(";");
                int n2 = string.indexOf("]");
                if (n >= 0) {
                    this.initializer = string.substring(n + 1, n2);
                }
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }
}

