/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.border.SoftBevelBorder;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.palette.Invokable;
import oracle.ide.palette.PaletteEvent;
import oracle.ide.palette.PaletteItem;
import oracle.ide.palette.PaletteTransferable;
import oracle.ideimpl.palette.PaletteController;
import oracle.ideimpl.palette.PaletteItemImpl;
import oracle.javatools.util.PlatformUtils;

public class PaletteItemUI
extends JButton
implements Observer,
DragGestureListener,
DragSourceListener,
KeyListener,
ActionListener,
MouseListener {
    private final PaletteController _controller;
    private PaletteItemImpl _item;
    private Icon _icon;
    private String _itemLabel;
    private Border _defaultBorder;
    private Color _defaultBackground;
    private Color _defaultForeground;
    private String _type;
    private DragSource _dragSource;
    private boolean IS_POPUP;
    private boolean _selected;
    boolean ignoreMouseReleased;
    private Object _droppedObject;
    private static final boolean macosxDisableDnD = PlatformUtils.isMac() && !PlatformUtils.isAtLeastMacTiger();

    void $init$() {
        this._controller = PaletteController.getInstance();
        this.IS_POPUP = false;
        this._selected = false;
        this.ignoreMouseReleased = false;
        this._droppedObject = null;
    }

    public PaletteItemUI(PaletteItemImpl paletteItemImpl) {
        this.$init$();
        this._item = paletteItemImpl;
        if (this._item.getItem() != null) {
            this._type = this._item.getItem().getType();
        }
        this._item.attach(this);
        this._icon = paletteItemImpl.getIcon();
        this._itemLabel = paletteItemImpl.getShortLabel();
        this.setContentAreaFilled(false);
        this._decorate();
        if (this._icon != null) {
            this.setIcon(this._icon);
            if (this.getAccessibleContext().getAccessibleIcon()[0] != null && this._itemLabel != null) {
                this.getAccessibleContext().getAccessibleIcon()[0].setAccessibleIconDescription(this._itemLabel);
                this.getAccessibleContext().setAccessibleName(this._itemLabel);
                this.getAccessibleContext().setAccessibleDescription(this._itemLabel);
            }
        }
        this._defaultBackground = this.getBackground();
        this._defaultForeground = this.getForeground();
        this._defaultBorder = BorderFactory.createLineBorder(this._defaultBackground, 3);
        this.setBorder(this._defaultBorder);
        this.setRequestFocusEnabled(false);
        this.addFocusListener(new 1());
        this._dragSource = new DragSource();
        this._dragSource.createDefaultDragGestureRecognizer(this, 1, this);
    }

    public void detach() {
        this._item.detach(this);
    }

    public PaletteItemImpl getItem() {
        return this._item;
    }

    public PaletteItem getPaletteItem() {
        return this._item;
    }

    public void setItem(PaletteItemImpl paletteItemImpl) {
        this._item = paletteItemImpl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.getItem().isPointer()) {
            this.hideAll();
            this._controller.getPalette().setActiveItem(this._item);
            if (this._controller.getStickyMode()) {
                this._controller.setStickyMode(false);
            }
            this._controller.fireItemPressed();
        }
    }

    protected void handleItem() {
        Editor editor = EditorManager.getEditorManager().getCurrentEditor();
        if (editor != null && editor.getContext() != null && editor.getContext().getNode() != null && editor.getContext().getNode().isReadOnly() && !this.getItem().isPointer()) {
            return;
        }
        this._controller.getPalette().setActiveItem(this._item);
        this._controller.fireItemPressed();
        if (this.getItem().isPointer()) {
            if (this._controller.getStickyMode()) {
                this._controller.setStickyMode(false);
            }
        } else {
            try {
                this.invoke();
                if (this.isWebBased()) {
                    this._controller.reset();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void invoke() throws Exception {
        Invokable invokable = (Invokable)Class.forName("oracle.jdevimpl.palette.PaletteProxy").newInstance();
        invokable.invoke(this._controller.getPaletteWindow().getContext(), new String[0]);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if ((mouseEvent.isShiftDown() || mouseEvent.getClickCount() == 2) && !this.isWebBased()) {
            this._controller.setStickyMode(true);
            if (!this.getItem().isPointer()) {
                this.showStickyMode();
            }
        } else if (!mouseEvent.isPopupTrigger() && !this.ignoreMouseReleased) {
            this.handleItem();
            this._controller.setStickyMode(false);
        } else {
            this._tryPopup(mouseEvent);
            this.showAsUnselected();
        }
        this.IS_POPUP = false;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiers() == 16) {
            return;
        }
        if (!this.isSelected() && mouseEvent.getClickCount() == 0) {
            this.setBorder(new SoftBevelBorder(0));
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiers() == 16) {
            return;
        }
        if (!this.isSelected()) {
            this.setBackground(this._defaultBackground);
            this.setForeground(this._defaultForeground);
            this.setBorder(this._defaultBorder);
            this.showEnabled();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.hideAll();
        this.showSelectedMode();
        this._controller.getPalette().setActiveItem(this._item);
        this.ignoreMouseReleased = mouseEvent.isPopupTrigger();
        this._tryPopup(mouseEvent);
    }

    private void _tryPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this._setActivePage();
            this._controller.getPaletteUI().setActivePaletteItemUI(this);
            this._controller.getPalette().setActiveItem(this._item);
            this._controller.tryPopup(mouseEvent);
            this.IS_POPUP = true;
        }
    }

    private void showEnabled() {
        Enumeration<AbstractButton> enumeration = this._controller.getPaletteUI().getButtonGroup().getElements();
        while (enumeration.hasMoreElements()) {
            PaletteItemUI paletteItemUI = (PaletteItemUI)enumeration.nextElement();
            if (!paletteItemUI.isSelected()) continue;
        }
    }

    public void hideAll() {
        ArrayList arrayList = this._controller.getPaletteUI().getActiveIconPanel().getIconList();
        for (PaletteItemUI paletteItemUI : arrayList) {
            paletteItemUI.showAsUnselected();
        }
    }

    public void showLabel(boolean bl) {
        if (bl) {
            this.setText(this._itemLabel);
        } else {
            this.setText("");
        }
        this.getAccessibleContext().setAccessibleDescription(this._itemLabel);
    }

    public boolean isWebBased() {
        if (this._type != null) {
            return this._type.equals("jsptag") || this._type.equals("XsqlTag") || this._type.equals("html") || this._type.equals("jsp");
        }
        return false;
    }

    private final void _decorate() {
        this.setVerticalTextPosition(0);
        this.setHorizontalAlignment(2);
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.setToolTipText(this._getToolText());
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        int n = (int)this.getAlignmentX();
        int n2 = (int)this.getAlignmentY();
        return new Point(n, n2 + 50);
    }

    private String _getToolText() {
        String string = "";
        string = this._item != null && this._item.getItem() != null && this._item.getItem().getType().equals("jsptag") && this._item.getItem().getInfo() != null ? this._item.getItem().getInfo() + ":" + this._itemLabel : (this._item != null && this._item.getItem() != null && this._item.getItem().getType().equals("html") ? this._item.getItem().getInfo() : (this._item != null && this._item.getItem() != null && this._item.getItem().getType().equals("JavaBean") ? this._item.getItem().getLongLabel() : (this._item != null && this._item.getItem() != null ? this._item.getItem().getLongLabel() : this._itemLabel)));
        return string;
    }

    private final void _setActivePage() {
        String string = (String)this._controller.getPaletteUI().getPageComboBox().getSelectedItem();
        this._controller.getPalette().setActivePage(this._controller.getPalette().getPalettePage(string));
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.setSelected(true);
            this.handleItem();
            this.setBorder(this._defaultBorder);
            this._controller.getPaletteWindow().fireDefaultCreate(new PaletteEvent(this._controller.getPalette(), "CREATE_DEFAULT"));
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void showSelectedMode() {
        this.setSelected(true);
        this.setBorder(new SoftBevelBorder(1));
        this._controller.getPaletteUI().requestFocus();
    }

    public void showStickyMode() {
        this.hideAll();
        this.setSelected(true);
        this.setBorder(new SoftBevelBorder(1));
        this.setBackground(new Color(213, 218, 222));
        this._controller.getPalette().setActiveItem(this._item);
        this._controller.fireItemPressed();
    }

    public void showAsUnselected() {
        this.setSelected(false);
        this.setBorder(this._defaultBorder);
        this.setBackground(this._defaultBackground);
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        this._controller.getPaletteUI().setActivePaletteItemUI(this);
        this._controller.getPalette().setActiveItem(this._item);
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        if (dragSourceDropEvent.getDropSuccess()) {
            Context context = this._controller.getPaletteWindow().getContext();
            Element[] elementArray = new Element[]{this._item};
            context.setSelection(elementArray);
            if (this._item.getPaletteInvokable() != null) {
                this._item.getPaletteInvokable().configure(context);
            }
            if (this._droppedObject != null && this._droppedObject instanceof PaletteTransferable) {
                ((PaletteTransferable)this._droppedObject).postConfigure(context);
            }
        } else {
            this.ignoreMouseReleased = true;
        }
        this._controller.reset();
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        PaletteItemImpl paletteItemImpl;
        Transferable transferable;
        if (!this._controller.getPalette().getActivePage().getDraggable() || this.getItem().isPointer() || macosxDisableDnD) {
            return;
        }
        boolean bl = false;
        InputEvent inputEvent = dragGestureEvent.getTriggerEvent();
        if (4 == inputEvent.getModifiers() || 8 == inputEvent.getModifiers()) {
            bl = true;
        }
        if ((transferable = (paletteItemImpl = this._item).getTrans(bl, inputEvent)) != null) {
            this._droppedObject = transferable;
            this._dragSource.startDrag(dragGestureEvent, null, transferable, this);
        } else {
            this._droppedObject = null;
            this._dragSource.startDrag(dragGestureEvent, null, this._item, this);
        }
    }

    public void setSelected(boolean bl) {
        this._selected = bl;
    }

    public boolean isSelected() {
        return this._selected;
    }

    public void update(Object object, UpdateMessage updateMessage) {
        PaletteItemImpl paletteItemImpl = (PaletteItemImpl)object;
        this.setVisible(paletteItemImpl.canShow());
        this.repaint();
    }

    static Border ra$_defaultBorder(PaletteItemUI paletteItemUI) {
        return paletteItemUI._defaultBorder;
    }

    public final class 1
    implements FocusListener {
        public void focusGained(FocusEvent focusEvent) {
            JViewport jViewport;
            Rectangle rectangle;
            PaletteItemUI.this.setBorder(new SoftBevelBorder(0));
            Component component = (Component)focusEvent.getSource();
            Rectangle rectangle2 = component.getBounds();
            Container container = component.getParent();
            Container container2 = ((Component)container).getParent();
            if (container2 instanceof JViewport && !(rectangle = (jViewport = (JViewport)container2).getViewRect()).contains(rectangle2)) {
                jViewport.setViewPosition(new Point(rectangle2.x, rectangle2.y));
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            PaletteItemUI.this.setBorder(PaletteItemUI.ra$_defaultBorder(PaletteItemUI.this));
        }
    }
}

