/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.palette.Invokable;
import oracle.ide.palette.Palette;
import oracle.ide.palette.PaletteContext;
import oracle.ide.palette.PaletteDisplayableListener;
import oracle.ide.palette.PaletteItem;
import oracle.ide.palette.PaletteListener;
import oracle.ide.palette.PaletteManager;
import oracle.ide.palette.PalettePage;
import oracle.ide.palette.PaletteWindow;
import oracle.ide.util.ModelUtil;
import oracle.ideimpl.palette.IconPanel;
import oracle.ideimpl.palette.PaletteController;
import oracle.ideimpl.palette.PaletteDockableFactory;
import oracle.ideimpl.palette.PaletteHandler;
import oracle.ideimpl.palette.PaletteImpl;
import oracle.ideimpl.palette.PaletteItemImpl;
import oracle.ideimpl.palette.PaletteItemUI;
import oracle.ideimpl.palette.PaletteManagerShutdownHook;
import oracle.ideimpl.palette.PalettePageImpl;
import oracle.ideimpl.palette.PaletteUI;
import oracle.ideimpl.palette.PaletteWindowImpl;
import oracle.ideimpl.palette.model.Item;
import oracle.ideimpl.palette.wizard.WizardManager;
import oracle.ideimpl.resource.PaletteArb;

public class PaletteManagerImpl
extends PaletteManager
implements Addin,
Controller {
    private IdeAction action;
    private PaletteWindowImpl paletteWindow;
    private final PaletteImpl palette;
    public static final int PALETTE_WIZARD_CMD = Ide.findOrCreateCmdID("PaletteWizardCommand");
    private final HashMap _editorPageMappings;
    private final ArrayList _paletteDisplayableList;
    private PaletteContext universalContext;

    void $init$() {
        this.action = null;
        this.palette = PaletteImpl.getInstance();
        this._editorPageMappings = new HashMap();
        this._paletteDisplayableList = new ArrayList();
        this.universalContext = null;
    }

    public static PaletteManagerImpl getInstance() {
        return (PaletteManagerImpl)PaletteManager.getPaletteManager();
    }

    private PaletteManagerImpl() {
        this.$init$();
        this._editorPageMappings.put("jsp", "HTML");
        this._editorPageMappings.put("html", "HTML");
    }

    void addDeferredPages() {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
        PaletteHandler paletteHandler = (PaletteHandler)extensionRegistry.getIdeHook(PaletteHandler.ELEMENT);
        paletteHandler.createPages(this.palette);
    }

    public void initialize() {
        PaletteManager.setPaletteManager(this);
        this.action = IdeAction.get(PaletteController.NEW_PALETTE_CMD_ID, null, PaletteArb.getString(27), IdeMainWindow.ACTION_CATEGORY_VIEW, PaletteArb.getInteger(29), PaletteArb.getInstance(), 30, null, true);
        this.action.addController(this);
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = menubar.createMenuItem(this.action, MenuConstants.WEIGHT_VIEW_COMPONENT_PALETTE);
        menubar.add(jMenuItem, MenuManager.getJMenu("View"), MenuConstants.SECTION_VIEW_SUPPORTING);
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), "oracle/ideimpl/palette/accelerators.xml");
        new PaletteDockableFactory();
        ExitCommand.addShutdownHook(new PaletteManagerShutdownHook());
    }

    public PaletteWindow getPaletteWindow() {
        if (this.paletteWindow == null) {
            this.paletteWindow = PaletteWindowImpl.getInstance();
        }
        return this.paletteWindow;
    }

    public Palette getPalette() {
        return this.palette;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == PaletteController.NEW_PALETTE_CMD_ID) {
            PaletteWindowImpl.getInstance().show();
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == PaletteController.NEW_PALETTE_CMD_ID) {
            if (PaletteWindowImpl.instanceExists() && PaletteWindowImpl.getInstance().isVisible()) {
                ideAction.setState(true);
            } else {
                ideAction.setState(false);
            }
            return true;
        }
        return false;
    }

    public void registerPaletteWizard(String string, Invokable invokable) {
        WizardManager.register(string, invokable);
    }

    public boolean showPalettePage(String string) {
        PaletteUI paletteUI = (PaletteUI)this.getPaletteWindow().getGUI();
        if (paletteUI != null) {
            return paletteUI.showPalettePage(string);
        }
        return false;
    }

    public boolean removePage(String string) {
        return this.getPalette().removePage(string);
    }

    public void addPaletteItem(String string, String string2, String string3, boolean bl, String string4, String string5, String string6, String string7, String string8, String string9, boolean bl2) {
        PalettePage palettePage = this.getPalette().getPalettePage(string);
        if (palettePage != null) {
            Item item = PalettePageImpl.createPaletteItem(string2, string3, bl, string4, string5, string6, string7, string8);
            item.setHelpable(string9);
            PaletteItemImpl paletteItemImpl = new PaletteItemImpl(item);
            palettePage.add(paletteItemImpl);
        }
        if (bl2) {
            this.updatePaletteUI();
        }
    }

    public void removePaletteItem(String string, String string2, boolean bl) {
        PalettePage palettePage = this.getPalette().getPalettePage(string);
        if (palettePage != null) {
            palettePage.remove(this.getItemFromPage(string2, string));
        }
        if (bl) {
            this.updatePaletteUI();
        }
    }

    public void updatePaletteUI() {
        PaletteController paletteController = PaletteController.getInstance();
        PaletteUI paletteUI = paletteController.getPaletteUI();
        if (paletteUI != null) {
            IconPanel iconPanel = paletteUI.getActiveIconPanel();
            if (iconPanel != null) {
                iconPanel.refreshList();
            }
            paletteUI.refreshCombo();
        }
    }

    public PalettePage addPage(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3) {
        return this.getPalette().addPage(string, string2, string3, bl, bl2, bl3);
    }

    public PalettePage getPage(String string) {
        return this.getPalette().getPalettePage(string);
    }

    public void setPageAsDefault(String string, String string2) {
        this._editorPageMappings.put(string, string2);
    }

    public String getPageForDocument(String string) {
        if (this._editorPageMappings.containsKey(string)) {
            return (String)this._editorPageMappings.get(string);
        }
        return null;
    }

    public void resetPalette() {
        PaletteController paletteController = PaletteController.getInstance();
        paletteController.setStickyMode(false);
        paletteController.reset();
    }

    public final void activateItem(PaletteItem paletteItem, boolean bl) {
        PaletteController paletteController = PaletteController.getInstance();
        Enumeration<AbstractButton> enumeration = paletteController.getPaletteUI().getButtonGroup().getElements();
        while (enumeration.hasMoreElements()) {
            PaletteItemUI paletteItemUI = (PaletteItemUI)enumeration.nextElement();
            if (paletteItemUI.getItem() == paletteItem) {
                if (bl) {
                    paletteItemUI.showStickyMode();
                    continue;
                }
                paletteItemUI.showSelectedMode();
                continue;
            }
            paletteItemUI.showAsUnselected();
        }
    }

    public final PaletteItem getItemFromPage(String string, String string2) {
        PaletteItemImpl paletteItemImpl = (PaletteItemImpl)this.palette.getPaletteItem(string, string2);
        return paletteItemImpl;
    }

    public void markDirty(boolean bl) {
        this.palette.setDirty(bl);
    }

    public void syncPalette(Context context) {
        if (this.getPaletteWindow() != null) {
            if (context != null) {
                ((PaletteWindowImpl)this.getPaletteWindow())._syncPalette(context);
            } else {
                ((PaletteWindowImpl)this.getPaletteWindow())._syncPalette();
            }
        }
    }

    public void addPaletteListener(PaletteListener paletteListener) {
        this.getPaletteWindow().addPaletteListener(paletteListener);
    }

    public void removePaletteListener(PaletteListener paletteListener) {
        this.getPaletteWindow().removePaletteListener(paletteListener);
    }

    public void setUniversalContext(PaletteContext paletteContext) {
        this.universalContext = paletteContext;
    }

    public PaletteContext getUniversalContext() {
        return this.universalContext;
    }

    public void addPaletteDisplayableListener(PaletteDisplayableListener paletteDisplayableListener) {
        this._paletteDisplayableList.add(paletteDisplayableListener);
    }

    public void removePaletteDisplayableListener(PaletteDisplayableListener paletteDisplayableListener) {
        this._paletteDisplayableList.remove(paletteDisplayableListener);
    }

    protected Iterator getPaletteDisplayables() {
        return this._paletteDisplayableList.iterator();
    }

    public Iterator getPalettePagesByType(String string) {
        ArrayList<PalettePage> arrayList = new ArrayList<PalettePage>();
        Iterator iterator = this.getPalette().getChildren();
        while (iterator.hasNext()) {
            PalettePage palettePage = (PalettePage)iterator.next();
            if (!ModelUtil.areEqual((Object)palettePage.getType(), (Object)string)) continue;
            arrayList.add(palettePage);
        }
        return arrayList.iterator();
    }

    public void refreshPalette() {
        PaletteController paletteController = PaletteController.getInstance();
        paletteController.refreshPalette();
    }

    public void refreshPaletteUI() {
        PaletteController paletteController = PaletteController.getInstance();
        paletteController.refreshPaletteUI();
    }
}

