/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.ide.model.Element;
import oracle.ide.palette.PaletteItem;
import oracle.ide.palette.PalettePage;
import oracle.ideimpl.palette.DeferredItem;
import oracle.ideimpl.palette.PaletteController;
import oracle.ideimpl.palette.PaletteItemImpl;
import oracle.ideimpl.palette.model.Item;
import oracle.ideimpl.palette.model.Page;

public final class PalettePageImpl
extends PalettePage {
    private ArrayList _paletteItems;
    private boolean listView;
    private boolean _isPersistent;
    private Page _page;

    void $init$() {
        this._paletteItems = null;
        this.listView = false;
        this._isPersistent = true;
    }

    public PalettePageImpl(Page page) {
        this.$init$();
        this._page = page;
        this.setName(page.getName());
        this.setLongLabel(page.getName());
    }

    public Page getPage() {
        return this._page;
    }

    protected Page getPageModel() {
        return this._page;
    }

    public void addPaletteItem(String string, String string2, boolean bl, String string3, String string4, String string5, String string6, String string7) {
        Item item = PalettePageImpl.createPaletteItem(string, string2, bl, string3, string4, string5, string6, string7);
        PaletteItemImpl paletteItemImpl = new PaletteItemImpl(item);
        this.add(paletteItemImpl);
    }

    public void addPaletteItem(String string, String string2, boolean bl, String string3, String string4, String string5, String string6, String string7, String string8) {
        Item item = PalettePageImpl.createPaletteItem(string, string2, bl, string3, string4, string5, string6, string7);
        item.setHelpable(string8);
        PaletteItemImpl paletteItemImpl = new PaletteItemImpl(item);
        this.add(paletteItemImpl);
    }

    public ArrayList getPaletteItems() {
        if (this._paletteItems == null) {
            this._paletteItems = this.getItemsFromPage(this._page);
        }
        return this._paletteItems;
    }

    public boolean add(Element element) {
        if (!this.getPaletteItems().contains(element)) {
            PaletteItemImpl paletteItemImpl = (PaletteItemImpl)element;
            int n = this._page.addItem(paletteItemImpl.getItem());
            this.getPaletteItems().add(n, element);
            try {
                PaletteController.getInstance().getPaletteUI().getPageMap().remove(this.getShortLabel());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public boolean remove(Element element) {
        PaletteItemImpl paletteItemImpl = (PaletteItemImpl)element;
        this._page.removeItem(paletteItemImpl.getItem());
        if (this.getPaletteItems().remove(element)) {
            try {
                PaletteController.getInstance().getPaletteUI().getPageMap().remove(this.getShortLabel());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public boolean canRemove(Element element) {
        return true;
    }

    public boolean canAdd(Element element) {
        return true;
    }

    public boolean containsChild(Element element) {
        return this.getPaletteItems().contains(element);
    }

    public int size() {
        return this.getPaletteItems().size();
    }

    public void removeAll() {
        this._page.removeAll();
        this.getPaletteItems().clear();
        try {
            PaletteController.getInstance().getPaletteUI().getPageMap().remove(this.getShortLabel());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object getData() {
        return this;
    }

    public void setListView(boolean bl) {
        this.listView = bl;
    }

    public boolean isListView() {
        return this.listView;
    }

    public Iterator getChildren() {
        return this.getPaletteItems().iterator();
    }

    void addPaletteItem(String string, String string2, boolean bl, boolean bl2, String string3, String string4, String string5, String string6, String string7, String string8) {
        Item item = PalettePageImpl.createPaletteItem(string, string2, bl, string3, string4, string5, string6, string7);
        item.setHelpable(string8);
        item.setCanRemove(bl2);
        PaletteItemImpl paletteItemImpl = new PaletteItemImpl(item);
        this.add(paletteItemImpl);
    }

    private ArrayList getItemsFromPage(Page page) {
        ArrayList<PaletteItemImpl> arrayList = new ArrayList<PaletteItemImpl>();
        Item[] itemArray = page.getItem();
        int n = itemArray != null ? itemArray.length : 0;
        int n2 = 0;
        while (n2 < n) {
            if (this.getTechnologyScope() != null) {
                itemArray[n2].setTechnologyScope(this.getTechnologyScope());
            }
            arrayList.add(new PaletteItemImpl(itemArray[n2]));
            ++n2;
        }
        return arrayList;
    }

    public Page getFinishPage() {
        int n = this.getPaletteItems().size();
        Iterator iterator = this.getPaletteItems().iterator();
        Item[] itemArray = new Item[n];
        int n2 = 0;
        while (iterator.hasNext()) {
            itemArray[n2] = ((PaletteItemImpl)iterator.next()).getItem();
            ++n2;
        }
        this._page.setItem(itemArray);
        return this._page;
    }

    public void setIsPersistent(boolean bl) {
        this._isPersistent = bl;
    }

    public boolean isPersistent() {
        return this._isPersistent;
    }

    public boolean canShow() {
        String string = this._page.getCanShow();
        return !string.equals("false");
    }

    public void setCanShow(boolean bl) {
        String string = "false";
        if (bl) {
            string = "true";
        }
        this._page.setCanShow(string);
    }

    public void setPaletteContext(String string) {
        this._page.setPaletteContext(string);
    }

    public String getPaletteContext() {
        return this._page.getPaletteContext();
    }

    public void setName(String string) {
        this.setShortLabel(string);
        this._page.setName(string);
    }

    public String getName() {
        return this.getShortLabel();
    }

    public void setShowForTypes(String string) {
        this._page.setShowForTypes(string);
    }

    public String getShowForTypes() {
        return this._page.getShowForTypes();
    }

    public void setType(String string) {
        this._page.setType(string);
    }

    public String getType() {
        return this._page.getType();
    }

    public void setView(String string) {
        this._page.setView(string);
    }

    public String getView() {
        return this._page.getView();
    }

    public void setCanRemove(boolean bl) {
        this._page.setCanRemove(bl);
    }

    public boolean getCanRemove() {
        return this._page.getCanRemove();
    }

    public void setPageEditor(String string) {
        this._page.setPageEditor(string);
    }

    public String getPageEditor() {
        return this._page.getPageEditor();
    }

    public void setProjectConfigurator(String string) {
        this._page.setProjectConfiguration(string);
    }

    public String getProjectConfigurator() {
        return this._page.getProjectConfiguration();
    }

    public void setTechnologyScope(String string) {
        this._page.setTechnologyScope(string);
    }

    public String getTechnologyScope() {
        return this._page.getTechnologyScope();
    }

    public void setDraggable(boolean bl) {
        this._page.setDraggable(bl);
    }

    public boolean getDraggable() {
        return this._page.getDraggable();
    }

    static Item createPaletteItem(DeferredItem deferredItem) {
        Item item = new Item();
        if (deferredItem.getIcon() == null) {
            item.setBeanInfo("1");
        } else {
            item.setIcon(deferredItem.getIcon());
        }
        item.setInfo(deferredItem.getInfo());
        item.setIsPersistent(deferredItem.isPersistent());
        item.setCanRemove(deferredItem.canRemove());
        item.setLongLabel(deferredItem.getLongLabel());
        item.setShortLabel(deferredItem.getShortLabel());
        item.setType(deferredItem.getType());
        item.setEditor(deferredItem.getEditor());
        item.setLibrary(deferredItem.getLibrary());
        item.setHelpable(deferredItem.getHelpable());
        item.setTechnologyScope(deferredItem.getTechnologyScope());
        try {
            item.setWeight(Float.parseFloat(deferredItem.getWeight()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return item;
    }

    static Item createPaletteItem(String string, String string2, boolean bl, String string3, String string4, String string5, String string6, String string7) {
        Item item = new Item();
        if (string == null) {
            item.setBeanInfo("1");
        } else {
            item.setIcon(string);
        }
        item.setInfo(string2);
        item.setIsPersistent(bl);
        item.setLongLabel(string3);
        item.setShortLabel(string4);
        item.setType(string5);
        item.setEditor(string6);
        item.setLibrary(string7);
        return item;
    }

    public PaletteItem getPaletteItem(String string) {
        for (PaletteItemImpl paletteItemImpl : this.getPaletteItems()) {
            if (!paletteItemImpl.getShortLabel().equalsIgnoreCase(string)) continue;
            return paletteItemImpl;
        }
        return null;
    }
}

