/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.config.DocumentExtensions;
import oracle.ide.controls.SortedComboBoxModel;
import oracle.ide.model.Element;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.net.URLFileSystem;
import oracle.ide.palette.PaletteContext;
import oracle.ide.palette.PaletteItem;
import oracle.ide.palette.PaletteManager;
import oracle.ide.palette.PaletteModelListener;
import oracle.ide.palette.PalettePage;
import oracle.ide.util.ModelUtil;
import oracle.ideimpl.palette.IconPanel;
import oracle.ideimpl.palette.PageNotFoundPanel;
import oracle.ideimpl.palette.PaletteComboBox;
import oracle.ideimpl.palette.PaletteController;
import oracle.ideimpl.palette.PaletteImpl;
import oracle.ideimpl.palette.PaletteItemImpl;
import oracle.ideimpl.palette.PaletteItemUI;
import oracle.ideimpl.palette.PaletteManagerImpl;
import oracle.ideimpl.palette.PalettePageImpl;
import oracle.ideimpl.palette.PanelFactory;
import oracle.ideimpl.palette.model.History;
import oracle.ideimpl.palette.model.Palette;
import oracle.ideimpl.palette.palettexml.PaletteXML;
import oracle.ideimpl.resource.PaletteArb;

public class PaletteUI
extends JPanel
implements PaletteModelListener,
ComponentListener {
    private final BorderLayout _defaultLayout;
    private SortedSet _pageItems;
    private final PaletteComboBox _pageComboBox;
    private final ButtonGroup _buttonGroup;
    private JPanel _displayPanel;
    private final PaletteController _controller;
    private final PaletteImpl _palette;
    private PaletteItemUI _paletteItemUI;
    private IconPanel _activeIconPanel;
    private PanelFactory _panelFactory;
    private boolean _vertical;
    private final HashMap _pageMap;
    private Context _currentContext;
    public static boolean FILTERED = true;
    private boolean hasInitialized;

    void $init$() {
        this._defaultLayout = new BorderLayout();
        this._pageItems = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        this._pageComboBox = new PaletteComboBox(PaletteUI.getComboBoxModel(Collections.EMPTY_LIST));
        this._buttonGroup = new ButtonGroup();
        this._displayPanel = new JPanel();
        this._controller = PaletteController.getInstance();
        this._palette = PaletteImpl.getInstance();
        this._panelFactory = new PanelFactory();
        this._vertical = true;
        this._pageMap = new HashMap();
    }

    public PaletteUI() {
        this.$init$();
        super.setPreferredSize(new Dimension(20, 20));
        this.setBorder(BorderFactory.createEmptyBorder());
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this._defaultLayout);
        this._displayPanel.setLayout(new BorderLayout());
        this._palette.addPaletteModelListener(this);
        this.addKeyListener(new 2());
        this.add((Component)this._displayPanel, "Center");
        this._controller.setPaletteUI(this);
        this.addComponentListener(this);
        AccessibleContext accessibleContext = this._pageComboBox.getAccessibleContext();
        if (accessibleContext != null) {
            String string = PaletteArb.getString(27);
            accessibleContext.setAccessibleName(string);
        }
        this._setupDisplayPanel();
    }

    protected void initialize() {
        Palette palette;
        if (!this.hasInitialized && (palette = PaletteXML.getPalette()) != null) {
            History[] historyArray = palette.getHistory();
            if (historyArray != null) {
                int n = historyArray != null ? historyArray.length : 0;
                int n2 = 0;
                while (n2 < n) {
                    this._controller.addToHistoryHash(historyArray[n2].getPageType(), historyArray[n2].getPalettePage());
                    ++n2;
                }
            }
            this.hasInitialized = true;
        }
    }

    public void showType(Context context, String string, boolean bl) {
        this.initialize();
        string = PaletteUI.convertAlias(string);
        this._currentContext = context;
        this._palette.setPageType(string);
        String string2 = this._controller.getPalettePageName(string);
        PalettePage palettePage = this._palette.getPalettePage(string2);
        Collection collection = this._getPalettePagesForActiveAddins(string, context);
        this._pageItems.clear();
        this._pageItems.addAll(collection);
        int n = this._pageItems.size();
        if (n > 0) {
            this._pageComboBox.setModel(PaletteUI.getComboBoxModel(this._pageItems));
            String string3 = this._pageComboBox.getItemAt(0).toString();
            if (string2 != null && palettePage != null && this._pageItems.contains(string2)) {
                string3 = string2;
            }
            this.showPanelAndSelect(string3);
        } else {
            this.showPagesNotFound();
        }
    }

    protected boolean showPalettePage(String string) {
        if (this._pageItems.contains(string)) {
            this.showPanelAndSelect(string);
            return true;
        }
        return false;
    }

    public void comboBoxChanged() {
        String string = this._pageComboBox.getSelectedString();
        if (string == null) {
            return;
        }
        PalettePage palettePage = this._palette.getPalettePage(string);
        if (this.getActiveIconPanel() == null || this.getActiveIconPanel()._palettePage != palettePage) {
            this._controller.addToHistoryHash(PaletteUI.getSuffix(this._currentContext), string);
            this.showPanel(string, this.getIfVertical());
            this._palette.setDirty(true);
        }
    }

    protected JComboBox getPageComboBox() {
        return this._pageComboBox;
    }

    public void setActivePaletteItemUI(PaletteItemUI paletteItemUI) {
        this._paletteItemUI = paletteItemUI;
    }

    public PaletteItemUI getActivePaletteItemUI() {
        return this._paletteItemUI;
    }

    public void setActiveIconPanel(IconPanel iconPanel) {
        this._activeIconPanel = iconPanel;
    }

    public IconPanel getActiveIconPanel() {
        return this._activeIconPanel;
    }

    protected HashMap getPageMap() {
        return this._pageMap;
    }

    private boolean _checkTechnologyScopes(String[] stringArray, String string) {
        if (string == null) {
            return false;
        }
        List<String> list = Arrays.asList(stringArray);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!list.contains(string2) && FILTERED) continue;
            return true;
        }
        return false;
    }

    private boolean _checkForPaletteContext(Collection collection, PalettePage palettePage, Context context) {
        Element[] elementArray = new Element[]{palettePage};
        context.setSelection(elementArray);
        String string = palettePage.getPaletteContext();
        if (string != null) {
            try {
                PaletteContext paletteContext = (PaletteContext)Class.forName(string).newInstance();
                if (paletteContext.canShowPage(context)) {
                    collection.add(palettePage.getShortLabel());
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private void _checkSyntaxContext(Collection collection, PalettePage palettePage, Context context) {
        Element[] elementArray = new Element[]{palettePage};
        context.setSelection(elementArray);
        try {
            PaletteContext paletteContext = this.getSyntaxContext();
            if (paletteContext.canShowPage(context)) {
                collection.add(palettePage.getShortLabel());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean _checkForShowForTypes(PalettePage palettePage, String string) {
        String string2 = palettePage.getShowForTypes();
        if (string2 == null) {
            string2 = PaletteUI.getType(palettePage);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            boolean bl = this.isCorrectNode(string3, string);
            if (!bl || !palettePage.canShow()) continue;
            try {
                boolean bl2 = true;
                return bl2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private Collection _getPalettePagesForActiveAddins(String string, Context context) {
        Iterator iterator = this._getPalettePages(string, context);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            arrayList.add(string2);
        }
        return arrayList;
    }

    private Iterator _getPalettePages(String string, Context context) {
        HashSet<String> hashSet = new HashSet<String>();
        if (context == null || context.getProject() == null) {
            return hashSet.iterator();
        }
        Iterator iterator = this._palette.getChildren();
        while (iterator.hasNext()) {
            boolean bl;
            int n;
            PalettePage palettePage = (PalettePage)iterator.next();
            String string2 = palettePage instanceof PalettePageImpl ? ((PalettePageImpl)palettePage).getTechnologyScope() : null;
            String[] stringArray = TechnologyScopeConfiguration.getInstance(context.getProject()).getTechnologyScope().getTechnologyKeys();
            int n2 = n = stringArray != null ? stringArray.length : 0;
            if (this.getSyntaxContext() != null) {
                this._checkSyntaxContext(hashSet, palettePage, context);
            }
            if (palettePage.getShowForTypes() != null || palettePage.getType() != null) {
                boolean bl2 = this._checkForShowForTypes(palettePage, string);
                if (bl2) {
                    if (n == 0 || string2 == null) {
                        hashSet.add(palettePage.getShortLabel());
                    } else {
                        boolean bl3 = this._checkTechnologyScopes(stringArray, string2);
                        if (palettePage.getShortLabel().equals("HTML") && (string.equals("jsp") || string.equals("html"))) {
                            hashSet.add(palettePage.getShortLabel());
                        } else if (bl3) {
                            hashSet.add(palettePage.getShortLabel());
                        }
                    }
                }
            } else if (n > 0 && (bl = this._checkTechnologyScopes(stringArray, string2))) {
                hashSet.add(palettePage.getShortLabel());
            }
            this._checkForPaletteContext(hashSet, palettePage, context);
        }
        Iterator iterator2 = hashSet.iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator2.hasNext()) {
            arrayList.add((String)iterator2.next());
        }
        Collections.sort(arrayList);
        return arrayList.iterator();
    }

    private boolean isPageShownForType(PalettePage palettePage, String string, Context context) {
        boolean bl;
        int n;
        if (context == null || context.getProject() == null) {
            return true;
        }
        String string2 = palettePage instanceof PalettePageImpl ? ((PalettePageImpl)palettePage).getTechnologyScope() : null;
        String[] stringArray = TechnologyScopeConfiguration.getInstance(context.getProject()).getTechnologyScope().getTechnologyKeys();
        int n2 = n = stringArray != null ? stringArray.length : 0;
        if (this.getSyntaxContext() != null && this._checkSyntaxContext(palettePage, context)) {
            return true;
        }
        if (palettePage.getShowForTypes() != null || palettePage.getType() != null) {
            boolean bl2 = this._checkForShowForTypes(palettePage, string);
            if (bl2) {
                if (n == 0 || string2 == null) {
                    return true;
                }
                boolean bl3 = this._checkTechnologyScopes(stringArray, string2);
                if (palettePage.getShortLabel().equals("HTML") && (string.equals("jsp") || string.equals("html"))) {
                    return true;
                }
                if (bl3) {
                    return true;
                }
            }
        } else if (n > 0 && (bl = this._checkTechnologyScopes(stringArray, string2))) {
            return true;
        }
        return this._checkForPaletteContext(palettePage, context);
    }

    private boolean _checkSyntaxContext(PalettePage palettePage, Context context) {
        Element[] elementArray = new Element[]{palettePage};
        context.setSelection(elementArray);
        try {
            PaletteContext paletteContext = this.getSyntaxContext();
            if (paletteContext.canShowPage(context)) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    private boolean _checkForPaletteContext(PalettePage palettePage, Context context) {
        Element[] elementArray = new Element[]{palettePage};
        context.setSelection(elementArray);
        String string = palettePage.getPaletteContext();
        if (string != null) {
            try {
                PaletteContext paletteContext = (PaletteContext)Class.forName(string).newInstance();
                if (paletteContext.canShowPage(context)) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public void componentResized(ComponentEvent componentEvent) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        boolean bl = this.getIfVertical();
        if (n2 < 80) {
            this.setIfVertical(false);
        } else {
            this.setIfVertical(true);
        }
        if (!(SwingUtilities.getWindowAncestor(this) instanceof IdeMainWindow)) {
            this.setIfVertical(true);
        }
        if (bl != this.getIfVertical()) {
            if (this._palette.getActivePage() != null) {
                PalettePage palettePage = this._palette.getActivePage();
                String string = palettePage.getShortLabel();
                this._setupDisplayPanel();
                this.showPanel(string, this.getIfVertical());
            } else {
                this.showPagesNotFound();
            }
        }
        SwingUtilities.invokeLater(new 1());
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void setIfVertical(boolean bl) {
        this._vertical = bl;
    }

    public boolean getIfVertical() {
        return this._vertical;
    }

    protected void showPanelAndSelect(String string) {
        this.showPanel(string, this.getIfVertical());
        this._pageComboBox.setSelectedItem(string);
    }

    protected void showPanel(String string, boolean bl) {
        Component component;
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        boolean bl2 = false;
        if (keyboardFocusManager != null && (component = keyboardFocusManager.getFocusOwner()) != null && SwingUtilities.isDescendingFrom(component, this)) {
            if (component != this._pageComboBox) {
                this.requestFocus();
            }
            bl2 = true;
        }
        if (this.getActiveIconPanel() != null) {
            this.getActiveIconPanel().detach();
            this._displayPanel.remove(this.getActiveIconPanel());
        }
        PalettePage palettePage = this._palette.getPalettePage(string);
        IconPanel iconPanel = this._panelFactory.getIconPanel(palettePage, bl);
        iconPanel.setup(this._pageComboBox);
        String string2 = palettePage.getView();
        if (string2 == null || string2.equals("list")) {
            iconPanel.useListView(true);
        } else {
            iconPanel.useListView(false);
        }
        this._palette.setActivePage(palettePage);
        this._addPageComboBoxToPanel();
        this._displayPanel.add((Component)iconPanel, "Center");
        this.setActiveIconPanel(iconPanel);
        if (bl2) {
            this._pageComboBox.requestFocus();
        }
        this.validateTree();
        this.repaint();
        iconPanel.validateScroll();
        this._pageComboBox.setToolTipText(PaletteArb.getString(109));
    }

    private void _setupDisplayPanel() {
        this._displayPanel.setLayout(new BorderLayout());
        this.add((Component)this._displayPanel, "Center");
        this._displayPanel.removeAll();
        this._addPageComboBoxToPanel();
    }

    private void _addPageComboBoxToPanel() {
        if (this._pageComboBox.getParent() == null) {
            if (this.getIfVertical()) {
                this._displayPanel.add((Component)this._pageComboBox, "North");
            } else {
                this._displayPanel.setLayout(new BoxLayout(this.getDisplayPanel(), 0));
                this._pageComboBox.setMaximumSize(new Dimension(1000, 20));
                this._displayPanel.add(this._pageComboBox);
            }
        }
    }

    protected ButtonGroup getButtonGroup() {
        return this._buttonGroup;
    }

    public void paletteItemRemoved(PaletteItem paletteItem) {
        if (this.getActiveIconPanel() == null) {
            return;
        }
        PaletteItemImpl paletteItemImpl = (PaletteItemImpl)paletteItem;
        if (this.getActiveIconPanel() != null) {
            this.getActiveIconPanel().removeItem(paletteItemImpl.getItem());
            if (!(this.getActiveIconPanel() instanceof PageNotFoundPanel)) {
                this._panelFactory.removeItem(this.getActiveIconPanel().getPalettePage().getShortLabel(), paletteItemImpl);
                this.getActiveIconPanel().invalidate();
                this.getActiveIconPanel().repaint();
            }
        }
    }

    public void palettePageAdded(PalettePage palettePage) {
        if (this._currentContext != null) {
            this.getActiveIconPanel().revalidate();
            this.revalidate();
            String string = PaletteUI.getSuffix(this._currentContext);
            if (this.isPageShownForType(palettePage, string, this._currentContext)) {
                String string2;
                boolean bl;
                String string3 = palettePage.getShortLabel();
                this._pageItems.add(string3);
                boolean bl2 = bl = this._pageComboBox.getItemCount() == 0;
                if (!bl && ModelUtil.areEqual((Object)string3, (Object)(string2 = this._controller.getPalettePageName(string)))) {
                    bl = true;
                }
                this._pageComboBox.addItem(string3);
                if (bl) {
                    this.showPanelAndSelect(string3);
                }
            }
        }
    }

    public void palettePageRemoved(PalettePage palettePage) {
        String string = palettePage.getShortLabel();
        boolean bl = this._pageItems.contains(string);
        if (bl) {
            this._pageMap.remove(string);
            this._pageItems.remove(string);
            if (this._pageComboBox.getItemCount() > 1 && ModelUtil.areEqual((Object)this._pageComboBox.getSelectedString(), (Object)string)) {
                Object e = this._pageComboBox.getItemAt(0);
                String string2 = ModelUtil.areEqual(e, (Object)string) ? (String)this._pageComboBox.getItemAt(1) : (String)this._pageComboBox.getItemAt(0);
                this.showPanelAndSelect(string2);
            }
            this._pageComboBox.removeItem(string);
            if (this._pageComboBox.getItemCount() == 0) {
                this.showPagesNotFound();
            }
        }
    }

    public void paletteItemAdded(PaletteItem paletteItem) {
        PaletteItemImpl paletteItemImpl = (PaletteItemImpl)paletteItem;
        this.getActiveIconPanel().addItem(paletteItemImpl.getItem());
    }

    public void palettePageRenamed(String string, PalettePage palettePage) {
        Object v;
        if (this._pageItems.contains(string)) {
            this._pageItems.remove(string);
            String string2 = palettePage.getShortLabel();
            this._pageItems.add(string2);
            this._pageComboBox.removeItem(string);
            this._pageComboBox.addItem(string2);
            this._pageComboBox.setSelectedItem(palettePage.getShortLabel());
        }
        if ((v = this._pageMap.get(string)) != null) {
            this._pageMap.put(palettePage.getShortLabel(), v);
        }
    }

    public void paletteItemRenamed(String string, PaletteItem paletteItem) {
    }

    public void updateItem(PalettePage palettePage, PaletteItemImpl paletteItemImpl) {
        for (PaletteItemUI paletteItemUI : this._panelFactory.getPageIcons(palettePage)) {
            if (paletteItemUI.getItem() != paletteItemImpl) continue;
            paletteItemUI.setItem(paletteItemImpl);
            paletteItemUI.setIcon(paletteItemImpl.getIcon());
            if (!(palettePage instanceof PalettePageImpl) || !((PalettePageImpl)palettePage).isListView()) break;
            paletteItemUI.setText(paletteItemImpl.getShortLabel());
            break;
        }
        this.invalidate();
        this.repaint();
    }

    protected void showPagesNotFound() {
        PageNotFoundPanel pageNotFoundPanel = new PageNotFoundPanel(null);
        this._palette.setActivePage(null);
        this._displayPanel.removeAll();
        this._displayPanel.setLayout(new BorderLayout());
        this.setActiveIconPanel(pageNotFoundPanel);
        this._palette.setPageType(null);
        this._displayPanel.add((Component)pageNotFoundPanel, "Center");
        this.validateTree();
        this.repaint();
    }

    public void setDisplayPanel(JPanel jPanel) {
        this._displayPanel = jPanel;
    }

    public JPanel getDisplayPanel() {
        return this._displayPanel;
    }

    public void refreshCombo() {
        String string = this._pageComboBox.getSelectedString();
        if (string == null) {
            return;
        }
        this.showPanel(string, this.getIfVertical());
    }

    public void clearContext() {
        this._currentContext = null;
    }

    private void this_keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            PaletteManager.getPaletteManager().resetPalette();
        }
    }

    private PaletteContext getSyntaxContext() {
        return PaletteManagerImpl.getInstance().getUniversalContext();
    }

    private boolean isCorrectNode(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        DocumentExtensions documentExtensions = (DocumentExtensions)Ide.getSettings().getData("document-extensions-options");
        DocumentExtensions.DocRecord docRecord = documentExtensions.findDocumentFromExtension("." + string2);
        if (docRecord == null) {
            return false;
        }
        for (DocumentExtensions.ExtInfo extInfo : docRecord.getExtensions()) {
            String string3 = extInfo.getExtension();
            if (!string3.equals("." + string)) continue;
            return true;
        }
        return false;
    }

    private static String getSuffix(Context context) {
        if (context == null || context.getNode() == null) {
            return "";
        }
        URL uRL = context.getNode().getURL();
        String string = URLFileSystem.getSuffix(uRL);
        int n = string.lastIndexOf(".");
        if (n != -1) {
            return PaletteUI.convertAlias(string.substring(n + 1));
        }
        return "";
    }

    private static String getType(PalettePage palettePage) {
        return PaletteUI.convertAlias(palettePage.getType());
    }

    private static String convertAlias(String string) {
        if (string.startsWith("jsp") || string.startsWith("tag")) {
            return "jsp";
        }
        return string;
    }

    private static ComboBoxModel getComboBoxModel(Collection collection) {
        SortedComboBoxModel sortedComboBoxModel = new SortedComboBoxModel();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            sortedComboBoxModel.addElement(iterator.next());
        }
        return sortedComboBoxModel;
    }

    static void mav$this_keyPressed(PaletteUI paletteUI, KeyEvent keyEvent) {
        paletteUI.this_keyPressed(keyEvent);
    }

    public final class 2
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            PaletteUI.mav$this_keyPressed(PaletteUI.this, keyEvent);
        }
    }

    public final class 1
    implements Runnable {
        public void run() {
            if (PaletteUI.this.getActiveIconPanel() != null) {
                PaletteUI.this.getActiveIconPanel().validateScroll();
                PaletteUI.this.validate();
                PaletteUI.this.repaint();
            }
        }
    }
}

