/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.DockableEvent;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.ide.help.Helpable;
import oracle.ide.model.Element;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.palette.ADAPaletteListener;
import oracle.ide.palette.Palette;
import oracle.ide.palette.PaletteContext;
import oracle.ide.palette.PaletteDisplayableListener;
import oracle.ide.palette.PaletteEvent;
import oracle.ide.palette.PaletteItem;
import oracle.ide.palette.PaletteListener;
import oracle.ide.palette.PalettePage;
import oracle.ide.palette.PaletteWindow;
import oracle.ide.resource.IdeIcons;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ideimpl.palette.IconPanel;
import oracle.ideimpl.palette.PageNotFoundPanel;
import oracle.ideimpl.palette.PaletteCommands;
import oracle.ideimpl.palette.PaletteController;
import oracle.ideimpl.palette.PaletteDockableFactory;
import oracle.ideimpl.palette.PaletteImpl;
import oracle.ideimpl.palette.PaletteItemImpl;
import oracle.ideimpl.palette.PaletteItemUI;
import oracle.ideimpl.palette.PaletteManagerImpl;
import oracle.ideimpl.palette.PaletteUI;
import oracle.ideimpl.palette.model.Item;
import oracle.ideimpl.palette.wizard.NewPageWizard;
import oracle.ideimpl.palette.wizard.PaletteDlg;
import oracle.ideimpl.resource.PaletteArb;

public class PaletteWindowImpl
extends PaletteWindow
implements Controller,
ContextMenuListener,
EditorListener,
ActionListener,
Observer,
ActiveViewListener {
    private static PaletteController controller = PaletteController.getInstance();
    private PaletteCommands _commands;
    public static PaletteUI paletteUI = new PaletteUI();
    private PaletteImpl palette;
    private String title;
    private static ContextMenu contextMenu;
    private static ContextMenuListener contextMenuListener;
    private final int SHOW_PROPERTIES_COMMAND;
    private IdeAction _showPropertiesAction;
    private JMenuItem PROPERTIES_MENU;
    private final int LIST_VIEW_COMMAND;
    private IdeAction _listViewAction;
    private JMenuItem LIST_VIEW_MENU;
    private final int HELP_COMMAND;
    private IdeAction _helpAction;
    private JMenuItem HELP_MENU;
    private final int ADD_ITEM_COMMAND;
    private IdeAction _addItemAction;
    private JMenuItem ADD_ITEM_MENU;
    private final int REMOVE_ITEM_COMMAND;
    private IdeAction _removeItemAction;
    private JMenuItem REMOVE_ITEM_MENU;
    private final int ADD_PAGE_COMMAND;
    private IdeAction _addPageAction;
    private JMenuItem ADD_PAGE_MENU;
    private final int REMOVE_PAGE_COMMAND;
    private IdeAction _removePageAction;
    private JMenuItem REMOVE_PAGE_MENU;
    private JMenu SORT_BY;
    private JRadioButtonMenuItem SHOW_ALL;
    private JRadioButtonMenuItem FILTER_PAGE;
    private static boolean resetElement;
    private final ArrayList _list;
    private final ArrayList _adaList;
    private PaletteDlg _wizard;
    private static boolean OPENED;
    private Object _activeProject;
    private Editor _currentEditor;
    private static PaletteWindowImpl singleton;

    static {
        resetElement = false;
        OPENED = false;
        singleton = new PaletteWindowImpl();
    }

    void $init$() {
        this._commands = new PaletteCommands();
        this.palette = PaletteImpl.getInstance();
        this.SHOW_PROPERTIES_COMMAND = Ide.findOrCreateCmdID("oracle.ideimpl.palette.SHOWPROPERTIES");
        this.LIST_VIEW_COMMAND = Ide.findOrCreateCmdID("oracle.ideimpl.palette.LISTVIEW");
        this.HELP_COMMAND = Ide.findOrCreateCmdID("oracle.ideimpl.palette.HELP");
        this.ADD_ITEM_COMMAND = Ide.findOrCreateCmdID("oracle.ideimpl.palette.ADDITEM");
        this.REMOVE_ITEM_COMMAND = Ide.findOrCreateCmdID("oracle.ideimpl.palette.REMOVEITEM");
        this.ADD_PAGE_COMMAND = Ide.findOrCreateCmdID("oracle.ideimpl.palette.ADDPAGE");
        this.REMOVE_PAGE_COMMAND = Ide.findOrCreateCmdID("oracle.ideimpl.palette.REMOVEPAGE");
        this.SHOW_ALL = new JRadioButtonMenuItem(PaletteArb.getString(105));
        this.FILTER_PAGE = new JRadioButtonMenuItem(PaletteArb.getString(106));
        this._list = new ArrayList();
        this._adaList = new ArrayList();
        this._wizard = null;
        this._activeProject = null;
        this._currentEditor = null;
    }

    private PaletteWindowImpl() {
        this.$init$();
        this.initialize();
        controller.setPaletteWindow(this);
        this.palette.attach(this);
        this.SHOW_ALL.addActionListener(this);
        this.FILTER_PAGE.addActionListener(this);
    }

    public static PaletteWindowImpl getInstance() {
        return singleton;
    }

    public static boolean instanceExists() {
        return singleton != null;
    }

    public Context getContext(EventObject eventObject) {
        Context context = Context.newIdeContext(this, eventObject);
        Editor editor = this.getEditor();
        if (editor != null && editor.getContext() != null && editor.getContext().getNode() != null) {
            context.setNode(editor.getContext().getNode());
            context.setProject(editor.getContext().getProject());
            context.setWorkspace(editor.getContext().getWorkspace());
        }
        return context;
    }

    public PaletteItem getSelectedItem() {
        return (PaletteItem)this.getContext().getElement();
    }

    public Component getGUI() {
        return paletteUI;
    }

    public Palette getPalette() {
        return this.palette;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_idecomponentpalette_html");
    }

    public void initialize() {
        this.title = PaletteArb.getString(27);
    }

    public Controller getController() {
        return controller;
    }

    public String getTitle() {
        if (this.title == null) {
            this.title = PaletteArb.getString(27);
        }
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getTabName() {
        return PaletteArb.getString(28);
    }

    public String getTitleName() {
        return "Component Palette";
    }

    protected Element[] getSelectionFromUI() {
        PaletteItem paletteItem = this.palette.getActiveItem();
        if (paletteItem == null) {
            return new Element[0];
        }
        return new Element[]{paletteItem};
    }

    public void activeViewChanged(ActiveViewEvent activeViewEvent) {
        Editor editor;
        if (activeViewEvent.getNewView() == null) {
            return;
        }
        if (activeViewEvent.getNewView().getContext().getProject() != null) {
            activeViewEvent.getNewView().getContext().getProject().attach(this);
        }
        if ((editor = this.getEditor()) != null && activeViewEvent.getNewView() instanceof Editor) {
            this._synchronizePalette(editor);
        }
    }

    public Editor getEditor() {
        return EditorManager.getEditorManager().getCurrentEditor();
    }

    public void showType(String string) {
        paletteUI.showType(this.getContext(), string, false);
    }

    public void reset() {
        controller.reset();
    }

    public void checkIfPopulated() {
        if (!this.palette.getHasPopulated()) {
            long l = System.currentTimeMillis();
            this.palette.populate();
            paletteUI.initialize();
        }
    }

    public void stateChange(int n) {
        if (n == 1) {
            this.checkIfPopulated();
            if (!OPENED) {
                this.firePaletteOpened(new PaletteEvent(this.palette, "PALETTE_OPENED"));
                OPENED = true;
                EditorManager.getEditorManager().addEditorListener(this);
                Editor editor = this.getEditor();
                this._syncPalette();
                this._synchronizePalette(editor);
            }
        } else if (n == 3) {
            this.firePaletteClosed(new PaletteEvent(this.palette, "PALETTE_CLOSED"));
        }
        super.stateChange(n);
    }

    public void show() {
        this.checkIfPopulated();
        super.show();
        DockStation.getDockStation().activateDockable(PaletteDockableFactory.DOCKABLE_PROXY);
        GraphicsUtils.focusComponentOrChild(paletteUI, true);
    }

    public void update(Object object, UpdateMessage updateMessage) {
        if (updateMessage.getMessageID() == UpdateMessage.PROPERTY_SET && updateMessage.containsProperty("technologyScope")) {
            this._forceSynchronization(this.getEditor());
        }
    }

    private final void triggerPopup(Context context) {
        this.getContextMenu().show(context);
    }

    public synchronized ContextMenu getContextMenu() {
        if (contextMenu == null) {
            contextMenu = new ContextMenu();
            contextMenuListener = this;
            contextMenu.addContextMenuListener(contextMenuListener);
        }
        return contextMenu;
    }

    public boolean tryPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            if (mouseEvent.getSource() instanceof IconPanel) {
                this.resetElement(true);
            } else {
                this.resetElement(false);
            }
            this.triggerPopup(this.getContext(mouseEvent));
            return true;
        }
        return false;
    }

    private void resetElement(boolean bl) {
        resetElement = bl;
    }

    private void changeList() {
        String string = "";
        boolean bl = paletteUI.getActiveIconPanel().getListView();
        string = bl ? "icon" : "list";
        PalettePage palettePage = this.palette.getActivePage();
        paletteUI.getActiveIconPanel().useListView(bl ^ true);
        if (palettePage != null) {
            palettePage.setView(string);
            paletteUI.showPanel(palettePage.getName(), paletteUI.getIfVertical());
        }
        this.palette.setDirty(true);
    }

    public void dockableShown(DockableEvent dockableEvent) {
        super.dockableShown(dockableEvent);
        Ide.getMainWindow().addActiveViewListener(this);
    }

    public void dockableHidden(DockableEvent dockableEvent) {
        super.dockableHidden(dockableEvent);
        Ide.getMainWindow().removeActiveViewListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.FILTER_PAGE) {
            this.setFiltered(true);
        } else if (object == this.SHOW_ALL) {
            this.setFiltered(false);
        } else {
            paletteUI.comboBoxChanged();
            this.fireSelectionChanged(new PaletteEvent(this.palette, "SELECTION_CHANGED"));
        }
    }

    public void addPaletteListener(PaletteListener paletteListener) {
        this._list.add(paletteListener);
    }

    public void removePaletteListener(PaletteListener paletteListener) {
        this._list.remove(paletteListener);
    }

    public void addADAPaletteListener(ADAPaletteListener aDAPaletteListener) {
        this._adaList.add(aDAPaletteListener);
    }

    public void removeADAPaletteListener(ADAPaletteListener aDAPaletteListener) {
        this._adaList.remove(aDAPaletteListener);
    }

    public void firePaletteOpened(PaletteEvent paletteEvent) {
        for (PaletteListener paletteListener : this._list) {
            paletteListener.paletteOpened(paletteEvent);
        }
    }

    public void firePaletteClosed(PaletteEvent paletteEvent) {
        for (PaletteListener paletteListener : this._list) {
            paletteListener.paletteClosed(paletteEvent);
        }
    }

    public void fireSelectionChanged(PaletteEvent paletteEvent) {
        ArrayList arrayList = (ArrayList)this._list.clone();
        for (PaletteListener paletteListener : arrayList) {
            paletteListener.selectionChanged(paletteEvent);
        }
    }

    public void fireItemPressed(PaletteEvent paletteEvent) {
        ArrayList arrayList = (ArrayList)this._list.clone();
        for (PaletteListener paletteListener : arrayList) {
            paletteListener.itemPressed(paletteEvent);
        }
    }

    public void fireStickyModeActivated(PaletteEvent paletteEvent) {
        ArrayList arrayList = (ArrayList)this._list.clone();
        for (PaletteListener paletteListener : arrayList) {
            paletteListener.stickyModeActivated(paletteEvent);
        }
    }

    public void fireStickyModeDeactivated(PaletteEvent paletteEvent) {
        ArrayList arrayList = (ArrayList)this._list.clone();
        for (PaletteListener paletteListener : arrayList) {
            paletteListener.stickyModeDeactivated(paletteEvent);
        }
    }

    public void fireDefaultCreate(PaletteEvent paletteEvent) {
        for (ADAPaletteListener aDAPaletteListener : this._adaList) {
            aDAPaletteListener.defaultCreate(paletteEvent);
        }
    }

    private String getSuffix(URL uRL) {
        String string = URLFileSystem.getSuffix(uRL);
        int n = string.lastIndexOf(".");
        if (n != -1) {
            return string.substring(n + 1);
        }
        return "";
    }

    public String getEditorSuffix() {
        Editor editor = this.getEditor();
        if (editor != null) {
            URL uRL = editor.getContext().getNode().getURL();
            return this.getSuffix(uRL);
        }
        return "";
    }

    public void _syncPalette() {
        this._syncPalette(this.getContext());
    }

    private void _synchronizePalette(Editor editor) {
        if (editor == null || editor.getContext() == null || editor.getContext().getNode() == null) {
            return;
        }
        if (this._currentEditor != null && editor == this._currentEditor) {
            return;
        }
        this._currentEditor = editor;
        URL uRL = editor.getContext().getNode().getURL();
        Context context = this.getContext();
        context.setNode(editor.getContext().getNode());
        context.setProject(editor.getContext().getProject());
        PaletteContext.setEditor(context, editor);
        if (uRL != null) {
            String string = this.getSuffix(uRL);
            paletteUI.getPageComboBox().removeActionListener(this);
            paletteUI.showType(context, string, false);
            paletteUI.getPageComboBox().addActionListener(this);
        } else {
            paletteUI.showPagesNotFound();
        }
        Iterator iterator = PaletteManagerImpl.getInstance().getPaletteDisplayables();
        while (iterator.hasNext()) {
            PaletteDisplayableListener paletteDisplayableListener = (PaletteDisplayableListener)iterator.next();
            paletteDisplayableListener.paletteDisplayed(context, editor);
        }
    }

    protected void _syncPalette(Context context) {
        boolean bl = false;
        if (this._activeProject != null && context.getProject() != null && context.getProject() != this._activeProject) {
            bl = true;
        }
        this._activeProject = context.getProject();
        this._synchronizePalette(this.getEditor());
    }

    private void _forceSynchronization(Editor editor) {
        if (editor != null && editor.getContext() != null && editor.getContext().getNode() != null) {
            URL uRL = editor.getContext().getNode().getURL();
            if (uRL != null) {
                String string = this.getSuffix(uRL);
                paletteUI.getPageComboBox().removeActionListener(this);
                Context context = this.getContext();
                context.setNode(editor.getContext().getNode());
                context.setProject(editor.getContext().getProject());
                PaletteContext.setEditor(context, editor);
                paletteUI.showType(context, string, false);
                paletteUI.getPageComboBox().addActionListener(this);
            }
        } else {
            paletteUI.showPagesNotFound();
        }
    }

    private void addMnemonics(JMenuItem jMenuItem, String string) {
        int n = string.indexOf("&");
        String string2 = "";
        if (n > -1) {
            string2 = string.substring(0, n);
            if (string.length() > n) {
                string2 = string2 + string.substring(n + 1);
            }
            jMenuItem.setMnemonic((int)string.charAt(n + 1));
        } else {
            string2 = string;
        }
        jMenuItem.setText(string2);
        jMenuItem.setIcon(IdeIcons.getIcon(0));
    }

    public void editorOpened(Editor editor) {
    }

    public void editorActivated(Editor editor) {
        this._synchronizePalette(editor);
    }

    public void editorDeactivated(Editor editor) {
    }

    public void editorClosed(Editor editor) {
        int n;
        if (editor != null && editor == this._currentEditor) {
            this._currentEditor = null;
            paletteUI.clearContext();
        }
        if ((n = EditorManager.getEditorManager().getAllEditors().size()) == 0) {
            paletteUI.showPagesNotFound();
        }
    }

    private void setFiltered(boolean bl) {
        PaletteUI.FILTERED = bl;
        this.FILTER_PAGE.setSelected(bl);
        this.SHOW_ALL.setSelected(bl ^ true);
        paletteUI.showType(this.getContext(), this.palette.getPageType(), false);
    }

    private void addMnemonics(IdeAction ideAction, String string) {
        int n = string.indexOf("&");
        ideAction.putValue("MnemonicKey", new Integer(string.charAt(n + 1)));
    }

    private IdeAction getAction(int n, String string, String string2) {
        IdeAction ideAction = IdeAction.get(n, string, string2);
        ideAction.addController(this);
        this.addMnemonics(ideAction, string2);
        return ideAction;
    }

    public void menuWillShow(ContextMenu contextMenu) {
        this._buildMenu(contextMenu);
        Context context = contextMenu.getContext();
        PaletteWindowImpl.contextMenu.add((Component)this.PROPERTIES_MENU, MenuConstants.SECTION_COMP_PALETTE_PROPERTIES);
        PaletteWindowImpl.contextMenu.add((Component)this.ADD_PAGE_MENU, 1.0f);
        Object object = context.getEvent().getSource();
        if (!(object instanceof PageNotFoundPanel)) {
            Palette palette = controller.getPalette();
            PalettePage palettePage = palette.getActivePage();
            boolean bl = palettePage.isPersistent();
            PaletteWindowImpl.contextMenu.add((Component)this.REMOVE_PAGE_MENU, 1.0f);
            if (bl) {
                PaletteWindowImpl.contextMenu.add((Component)this.ADD_ITEM_MENU, MenuConstants.SECTION_COMP_PALETTE_COMPONENT);
            }
            this.SORT_BY.add(this.SHOW_ALL);
            this.SORT_BY.add(this.FILTER_PAGE);
            if (object instanceof PaletteItemUI) {
                PaletteItemUI paletteItemUI;
                Item item;
                if (bl) {
                    PaletteWindowImpl.contextMenu.add((Component)this.REMOVE_ITEM_MENU, MenuConstants.SECTION_COMP_PALETTE_COMPONENT);
                }
                if ((item = (paletteItemUI = (PaletteItemUI)object).getItem().getItem()) != null) {
                    String string = item.getHelpable();
                    String string2 = item.getType();
                    if (string != null || string2.equals("jsptag") || string2.equals("html") || string2.equals("css")) {
                        PaletteWindowImpl.contextMenu.add((Component)this.HELP_MENU, MenuConstants.SECTION_HELP_ABOUT);
                    }
                }
            }
            PaletteWindowImpl.contextMenu.add((Component)this.LIST_VIEW_MENU, MenuConstants.SECTION_COMP_PALETTE_VIEW);
            PaletteWindowImpl.contextMenu.add((Component)this.SORT_BY, MenuConstants.SECTION_COMP_PALETTE_VIEW);
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction == this._showPropertiesAction) {
            this._wizard = new PaletteDlg();
            this._wizard.invoke(this.getContext());
            return true;
        }
        if (ideAction == this._listViewAction) {
            this.changeList();
        } else if (ideAction == this._addItemAction) {
            this._commands.invokeItemWizard(controller.getPalette().getActivePage());
        } else if (ideAction == this._removeItemAction) {
            this._commands.removePaletteItem();
        } else if (ideAction == this._addPageAction) {
            try {
                new NewPageWizard().invoke(this.getEditorSuffix(), this.getContext(), controller.getList());
            }
            catch (Exception exception) {}
        } else if (ideAction == this._removePageAction) {
            this._commands.removePalettePage();
        } else if (ideAction == this._helpAction) {
            PaletteItemImpl paletteItemImpl = (PaletteItemImpl)this.palette.getActiveItem();
            Item item = paletteItemImpl.getItem();
            PaletteItem paletteItem = this.getSelectedItem();
            if (item.getHelpable() != null) {
                Helpable helpable = null;
                try {
                    helpable = (Helpable)Class.forName(item.getHelpable()).newInstance();
                    if (helpable != null) {
                        HelpSystem.getHelpSystem().showHelp(helpable.getHelpInfo());
                    }
                }
                catch (Exception exception) {
                    HelpSystem.getHelpSystem().showHelp(new HelpInfo(item.getHelpable()));
                }
            } else if (paletteItem != null) {
                if (paletteItemImpl.getItem().getType().equals("html")) {
                    String string = paletteItemImpl.getShortLabel().toLowerCase();
                    String string2 = string.replaceAll(" ", "");
                    String string3 = string2.replaceAll(":", "");
                    HelpSystem.getHelpSystem().showHelp(new HelpInfo("f1_html" + string3 + "_html"));
                } else if (paletteItemImpl.getItem().getType().equals("css")) {
                    String string = paletteItem.getShortLabel().toLowerCase();
                    String string4 = "f1_css" + string + "_html";
                    HelpSystem.getHelpSystem().showHelp(new HelpInfo(string4));
                } else {
                    String string = paletteItem.getClassPath().toLowerCase();
                    String string5 = paletteItem.getShortLabel().toLowerCase();
                    String string6 = "f1_jsp" + string + string5 + "_html";
                    HelpSystem.getHelpSystem().showHelp(new HelpInfo(string6));
                }
            }
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        if (ideAction == this._removePageAction || ideAction == this._addItemAction || ideAction == this._removeItemAction) {
            Palette palette = controller.getPalette();
            PalettePage palettePage = palette.getActivePage();
            ideAction.setEnabled(palettePage.isPersistent());
            return true;
        }
        return false;
    }

    private void _buildMenu(ContextMenu contextMenu) {
        if (this.HELP_MENU == null) {
            this._helpAction = this.getAction(this.HELP_COMMAND, null, PaletteArb.getString(62));
            this.HELP_MENU = contextMenu.createMenuItem(this._helpAction, MenuConstants.WEIGHT_COMP_PALETTE_HELP);
        }
        if (this.ADD_ITEM_MENU == null) {
            this._addItemAction = this.getAction(this.ADD_ITEM_COMMAND, null, PaletteArb.getString(86));
            this.ADD_ITEM_MENU = contextMenu.createMenuItem(this._addItemAction, MenuConstants.WEIGHT_COMP_PALETTE_ADD_COMP);
        }
        if (this.REMOVE_ITEM_MENU == null) {
            this._removeItemAction = this.getAction(this.REMOVE_ITEM_COMMAND, null, PaletteArb.getString(87));
            this.REMOVE_ITEM_MENU = contextMenu.createMenuItem(this._removeItemAction, MenuConstants.WEIGHT_COMP_PALETTE_REMOVE_COMP);
        }
        if (this.ADD_PAGE_MENU == null) {
            this._addPageAction = this.getAction(this.ADD_PAGE_COMMAND, null, PaletteArb.getString(88));
            this.ADD_PAGE_MENU = contextMenu.createMenuItem(this._addPageAction, 1.0f);
        }
        if (this.REMOVE_PAGE_MENU == null) {
            this._removePageAction = this.getAction(this.REMOVE_PAGE_COMMAND, null, PaletteArb.getString(89));
            this.REMOVE_PAGE_MENU = contextMenu.createMenuItem(this._removePageAction, MenuConstants.WEIGHT_COMP_PALETTE_REMOVE_COMP);
        }
        IdeAction.remove(this.LIST_VIEW_COMMAND);
        this._listViewAction = !paletteUI.getActiveIconPanel().getListView() ? this.getAction(this.LIST_VIEW_COMMAND, null, PaletteArb.getString(23)) : this.getAction(this.LIST_VIEW_COMMAND, null, PaletteArb.getString(61));
        this.LIST_VIEW_MENU = contextMenu.createMenuItem(this._listViewAction, MenuConstants.WEIGHT_COMP_PALETTE_TOGGLE_VIEW);
        if (this.SORT_BY == null) {
            this.SORT_BY = contextMenu.createSubMenu(PaletteArb.getString(104), new Integer(0), MenuConstants.WEIGHT_COMP_PALETTE_TOGGLE_VIEW);
            this.addMnemonics(this.SORT_BY, PaletteArb.getString(104));
            this.addMnemonics(this.SHOW_ALL, PaletteArb.getString(105));
            this.addMnemonics(this.FILTER_PAGE, PaletteArb.getString(106));
        }
        if (this.PROPERTIES_MENU == null) {
            this._showPropertiesAction = this.getAction(this.SHOW_PROPERTIES_COMMAND, null, PaletteArb.getString(31));
            this.PROPERTIES_MENU = contextMenu.createMenuItem(this._showPropertiesAction, MenuConstants.WEIGHT_COMP_PALETTE_PROPERTIES);
        }
    }

    public void addToHistoryHash(String string, String string2) {
        controller.addToHistoryHash(string, string2);
    }

    public boolean isPanelActive() {
        try {
            if (paletteUI.getActiveIconPanel() != null) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public PaletteItem getActivePanelItem() {
        PaletteItem paletteItem;
        try {
            paletteItem = paletteUI.getActivePaletteItemUI().getPaletteItem();
        }
        catch (Exception exception) {
            paletteItem = null;
        }
        return paletteItem;
    }

    public ArrayList getActivePanelItemList() {
        ArrayList<PaletteItem> arrayList = new ArrayList<PaletteItem>();
        try {
            ArrayList arrayList2 = paletteUI.getActiveIconPanel().getIconList();
            for (PaletteItemUI paletteItemUI : arrayList2) {
                PaletteItem paletteItem = paletteItemUI.getPaletteItem();
                arrayList.add(paletteItem);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    private void setPanelItem(int n, PaletteItem paletteItem, boolean bl) {
        try {
            ArrayList arrayList = paletteUI.getActiveIconPanel().getIconList();
            for (PaletteItemUI paletteItemUI : arrayList) {
                if (paletteItem != paletteItemUI.getPaletteItem()) continue;
                if (n == 0) {
                    paletteItemUI.setSelected(bl);
                    continue;
                }
                paletteItemUI.setEnabled(bl);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setActivePanelItemSelected(PaletteItem paletteItem, boolean bl) {
        this.setPanelItem(0, paletteItem, bl);
    }

    public void setActivePanelItemEnabled(PaletteItem paletteItem, boolean bl) {
        this.setPanelItem(1, paletteItem, bl);
    }
}

