/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import oracle.ide.palette.PalettePage;
import oracle.ideimpl.palette.HorizontalPanel;
import oracle.ideimpl.palette.IconPanel;
import oracle.ideimpl.palette.PaletteController;
import oracle.ideimpl.palette.PaletteItemImpl;
import oracle.ideimpl.palette.PaletteItemUI;
import oracle.ideimpl.palette.VerticalPanel;
import oracle.ideimpl.palette.model.Item;
import oracle.ideimpl.resource.PaletteArb;

public final class PanelFactory {
    final PaletteController _control;
    private HashMap _pageMap;

    void $init$() {
        this._control = PaletteController.getInstance();
        this._pageMap = null;
    }

    private HashMap getPageMap() {
        if (this._pageMap == null) {
            this._pageMap = this._control.getPaletteUI().getPageMap();
        }
        return this._pageMap;
    }

    public IconPanel getIconPanel(PalettePage palettePage, boolean bl) {
        this.getPageMap();
        if (bl) {
            VerticalPanel verticalPanel = new VerticalPanel(palettePage);
            verticalPanel.setIconList(this.getPageIcons(palettePage));
            verticalPanel.addIconLabels(false);
            return verticalPanel;
        }
        HorizontalPanel horizontalPanel = new HorizontalPanel(palettePage);
        horizontalPanel.setIconList(this.getPageIcons(palettePage));
        horizontalPanel.addIconLabels(false);
        return horizontalPanel;
    }

    protected ArrayList getPageIcons(PalettePage palettePage) {
        String string = palettePage.getShortLabel();
        if (this.getPageMap().containsKey(string)) {
            ArrayList arrayList = (ArrayList)this.getPageMap().get(string);
            int n = palettePage.getPaletteItems().size();
            int n2 = arrayList.size() - 1;
            if (palettePage.getType().equals("java")) {
                n2 = arrayList.size() - 2;
            }
            if (n != n2) {
                this._populate(palettePage);
            }
        } else {
            this._populate(palettePage);
        }
        ArrayList arrayList = (ArrayList)this.getPageMap().get(string);
        1 var7_7 = new 1();
        String string2 = palettePage.getType();
        if (string2.equals("jsp") || string2.equals("jspx") || string2.equals("java") || string2.equals("html") || string2.equals("htm")) {
            Collections.sort(arrayList, var7_7);
        }
        return arrayList;
    }

    private void _populate(PalettePage palettePage) {
        ArrayList<PaletteItemUI> arrayList = new ArrayList<PaletteItemUI>();
        Iterator iterator = palettePage.getPaletteItems().iterator();
        String[] stringArray = new String[]{"jsp", "css", "snippet", "html"};
        String string = palettePage.getType();
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            if (string.startsWith(string2)) {
                bl = true;
            }
            ++n;
        }
        if (!bl) {
            arrayList.add(new PaletteItemUI(new PaletteItemImpl(true)));
        }
        if (palettePage.getType().equals("java")) {
            Item item = new Item();
            item.setShortLabel(PaletteArb.getString(10));
            item.setLongLabel(PaletteArb.getString(11));
            item.setType("JavaBean");
            item.setEditor("oracle.jdevimpl.uieditor.DynamicItemEditor");
            PaletteItemImpl paletteItemImpl = new PaletteItemImpl(item);
            paletteItemImpl.setIcon(PaletteArb.getIcon(30));
            arrayList.add(new PaletteItemUI(paletteItemImpl));
        }
        while (iterator.hasNext()) {
            PaletteItemImpl paletteItemImpl = (PaletteItemImpl)iterator.next();
            if (paletteItemImpl == null || !paletteItemImpl.canShow()) continue;
            arrayList.add(new PaletteItemUI(paletteItemImpl));
        }
        ArrayList arrayList2 = this.getPageMap().put(palettePage.getShortLabel(), arrayList);
        if (arrayList2 != null) {
            int n2 = 0;
            int n3 = arrayList2.size();
            while (n2 < n3) {
                PaletteItemUI paletteItemUI = (PaletteItemUI)arrayList2.get(n2);
                paletteItemUI.detach();
                ++n2;
            }
        }
    }

    public void addItem(String string, PaletteItemImpl paletteItemImpl) {
        if (this.getPageMap().containsKey(string)) {
            ArrayList arrayList = (ArrayList)this.getPageMap().get(string);
            arrayList.add(new PaletteItemUI(paletteItemImpl));
        }
    }

    public void removeItem(String string, PaletteItemImpl paletteItemImpl) {
        if (this.getPageMap().containsKey(string)) {
            ArrayList arrayList = (ArrayList)this.getPageMap().get(string);
            for (PaletteItemUI paletteItemUI : arrayList) {
                if (paletteItemUI.getItem() != paletteItemImpl) continue;
                arrayList.remove(paletteItemUI);
                break;
            }
        }
    }

    public PanelFactory() {
        this.$init$();
    }

    public final class 1
    implements Comparator {
        public int compare(Object object, Object object2) {
            PaletteItemUI paletteItemUI = (PaletteItemUI)object;
            if (paletteItemUI.getItem().isPointer()) {
                return 0;
            }
            PaletteItemUI paletteItemUI2 = (PaletteItemUI)object2;
            String string = paletteItemUI.getItem().getShortLabel();
            String string2 = paletteItemUI2.getItem().getShortLabel();
            int n = string.length();
            int n2 = string2.length();
            int n3 = 0;
            int n4 = Math.min(n, n2);
            while (n3 < n4) {
                char c;
                char c2 = string.charAt(n3);
                if (c2 != (c = string2.charAt(n3))) {
                    return c2 - c;
                }
                ++n3;
            }
            return n - n2;
        }
    }
}

