/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.MouseListener;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import oracle.ide.controls.VerticalFlowLayout;
import oracle.ide.palette.PalettePage;
import oracle.ideimpl.palette.CenterPanel;
import oracle.ideimpl.palette.IconPanel;
import oracle.ideimpl.palette.PaletteItemImpl;
import oracle.ideimpl.palette.PaletteItemUI;
import oracle.ideimpl.palette.model.Item;

public class VerticalPanel
extends IconPanel
implements MouseListener {
    private BorderLayout borderLayout1;
    private JScrollPane _verticalScroll;
    private CenterPanel _middlePanel;

    void $init$() {
        this.borderLayout1 = new BorderLayout();
        this._middlePanel = new CenterPanel();
    }

    public VerticalPanel(PalettePage palettePage) {
        super(palettePage);
        this.$init$();
        this._middlePanel.addMouseListener(this);
    }

    public void setup(JComboBox jComboBox) {
        this._verticalScroll = new JScrollPane(this._middlePanel);
        this._verticalScroll.getVerticalScrollBar().setBlockIncrement(50);
        this._verticalScroll.getVerticalScrollBar().setUnitIncrement(20);
        this._verticalScroll.setBorder(null);
        this.setLayout(this.borderLayout1);
        this.add((Component)this._verticalScroll, "Center");
    }

    void removeChildren() {
        this._middlePanel.removeAll();
    }

    public void addIconLabels(boolean bl) {
        for (PaletteItemUI paletteItemUI : this.getIconList()) {
            if (bl) {
                paletteItemUI.setText(paletteItemUI.getItem().getShortLabel());
            } else {
                paletteItemUI.setText("");
            }
            this._middlePanel.add(paletteItemUI);
        }
    }

    public void useListView(boolean bl) {
        this.setListView(bl);
        Iterator iterator = this.getIconList().iterator();
        if (bl) {
            this._middlePanel.setLayout(new VerticalFlowLayout(0, 0, 0, true, false));
            this.getPalettePage().setView("list");
        } else {
            this._middlePanel.setLayout(new FlowLayout(0));
            this.getPalettePage().setView("icon");
        }
        while (iterator.hasNext()) {
            PaletteItemUI paletteItemUI = (PaletteItemUI)iterator.next();
            if (bl) {
                paletteItemUI.setText(paletteItemUI.getItem().getShortLabel());
            } else {
                paletteItemUI.setText("");
            }
            if (paletteItemUI.getItem().getItem() == null || !paletteItemUI.getItem().getItem().getType().equals("jsptag")) continue;
            String string = paletteItemUI.getItem().getLongLabel();
            if (string != null && string.length() > 100) {
                String string2 = string.substring(0, 50);
                String string3 = string.substring(50, 100);
                String string4 = string.substring(100);
                string = string2 + "<br>" + string3 + "<br>" + string4;
            }
            if (string == null || string.equals("No Info!")) {
                paletteItemUI.setToolTipText("<html><b>" + paletteItemUI.getItem().getItem().getInfo() + ":" + paletteItemUI.getItem().getShortLabel() + "</b></html>");
                continue;
            }
            paletteItemUI.setToolTipText("<html><b>" + paletteItemUI.getItem().getItem().getInfo() + ":" + paletteItemUI.getItem().getShortLabel() + "</b><br>" + string + "</html>");
        }
    }

    public void addItem(Item item) {
        PaletteItemUI paletteItemUI = new PaletteItemUI(new PaletteItemImpl(item));
        this.getIconList().add(paletteItemUI);
        this._middlePanel.add(paletteItemUI);
        this.useListView(this.getListView());
    }

    public void removeItem(Item item) {
        for (PaletteItemUI paletteItemUI : this.getIconList()) {
            if (paletteItemUI.getItem().getItem() != item) continue;
            this._middlePanel.remove(paletteItemUI);
        }
    }

    public void removeActiveItem() {
        this._middlePanel.remove(this._controller.getPaletteUI().getActivePaletteItemUI());
        this._middlePanel.repaint();
        this._middlePanel.validate();
    }

    public void validateScroll() {
    }
}

