/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette.model;

import java.util.Map;
import oracle.ide.Ide;
import oracle.ide.util.macro.StringMacroConverter;
import oracle.ideimpl.palette.model.Addin;
import oracle.ideimpl.palette.model.History;
import oracle.ideimpl.palette.model.Jsplibrary;
import oracle.ideimpl.palette.model.Page;
import oracle.ideimpl.palette.palettexml.PaletteXML;

public class Palette {
    private Page[] _page;
    private Addin[] _addin;
    private Jsplibrary[] _jsplibrary;
    private History[] _history;

    public Palette() {
    }

    public Palette(Palette palette) {
        this();
        if (palette != null) {
            Palette.copy(palette, this);
        }
    }

    public static void copy(Palette palette, Palette palette2) {
        if (palette._page != null) {
            int n = palette._page.length;
            palette2._page = new Page[n];
            int n2 = 0;
            while (n2 < n) {
                palette2._page[n2] = new Page(palette._page[n2]);
                ++n2;
            }
        }
        if (palette._addin != null) {
            int n = palette._addin.length;
            palette2._addin = new Addin[n];
            int n3 = 0;
            while (n3 < n) {
                palette2._addin[n3] = new Addin(palette._addin[n3]);
                ++n3;
            }
        }
        if (palette._jsplibrary != null) {
            int n = palette._jsplibrary.length;
            palette2._jsplibrary = new Jsplibrary[n];
            int n4 = 0;
            while (n4 < n) {
                palette2._jsplibrary[n4] = new Jsplibrary(palette._jsplibrary[n4]);
                ++n4;
            }
        }
        if (palette._history != null) {
            int n = palette._history.length;
            palette2._history = new History[n];
            int n5 = 0;
            while (n5 < n) {
                palette2._history[n5] = new History(palette._history[n5]);
                ++n5;
            }
        }
    }

    public Page[] getPage() {
        return this._page;
    }

    public void setPage(Page[] pageArray) {
        this._page = pageArray;
    }

    public Addin[] getAddin() {
        return this._addin;
    }

    public void setAddin(Addin[] addinArray) {
        this._addin = addinArray;
    }

    public Jsplibrary[] getJsplibrary() {
        if (!PaletteXML.BUILD_SYSTEM && !PaletteXML.SAVING) {
            int n = this._jsplibrary != null ? this._jsplibrary.length : 0;
            int n2 = 0;
            while (n2 < n) {
                Jsplibrary jsplibrary = this._jsplibrary[n2];
                this._convert(jsplibrary);
                ++n2;
            }
        }
        return this._jsplibrary;
    }

    public void setJsplibrary(Jsplibrary[] jsplibraryArray) {
        this._jsplibrary = jsplibraryArray;
    }

    public History[] getHistory() {
        return this._history;
    }

    public void setHistory(History[] historyArray) {
        this._history = historyArray;
    }

    private void _convert(Jsplibrary jsplibrary) {
        Map map = Ide.getMacros();
        StringMacroConverter stringMacroConverter = StringMacroConverter.getConverter(1);
        map.put("oracle.home", Ide.getOracleHomeDirectory());
        String string = jsplibrary.getClassesURL();
        if (string != null) {
            string = stringMacroConverter.expandString(jsplibrary.getClassesURL(), map);
            string = string.replace('\\', '/');
            jsplibrary.setClassesURL(string);
        }
        String string2 = stringMacroConverter.expandString(jsplibrary.getTldURL(), map);
        if (jsplibrary.getIcon() != null) {
            String string3 = stringMacroConverter.expandString(jsplibrary.getIcon(), map);
            string3 = string3.replace('\\', '/');
        }
        string2 = string2.replace('\\', '/');
        jsplibrary.setTldURL(string2);
    }
}

