/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette.palettexml;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.net.URLFactory;
import oracle.ide.util.ModelUtil;
import oracle.ide.xml.XMLUtil;
import oracle.ideimpl.palette.model.Addin;
import oracle.ideimpl.palette.model.History;
import oracle.ideimpl.palette.model.Item;
import oracle.ideimpl.palette.model.Jsplibrary;
import oracle.ideimpl.palette.model.Page;
import oracle.ideimpl.palette.model.Palette;
import oracle.xml.parser.v2.XMLDocument;

public class PaletteXML {
    private static URL _url;
    private static Object2Dom _o2d;
    private static Palette _palette;
    public static boolean BUILD_SYSTEM;
    public static boolean SAVING;
    private static boolean _isDirty;

    static {
        _o2d = Object2Dom.newInstanceForSchemaCompiledBeans();
        BUILD_SYSTEM = true;
        SAVING = false;
        _isDirty = false;
    }

    public static final boolean isDirty() {
        return _isDirty;
    }

    public static final void setDirty() {
        _isDirty = true;
    }

    public static Palette getPaletteFromURL(URL uRL) {
        Palette palette = null;
        try {
            palette = (Palette)_o2d.toObject(uRL, Palette.class);
        }
        catch (IOException iOException) {
            System.err.println("Problem creating palette object.");
            iOException.printStackTrace();
        }
        return palette;
    }

    public static void main(String[] stringArray) {
        try {
            File file = new File("c:\\palette.xml");
            PaletteXML.loadPaletteXml(file.toURL());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void loadPaletteXml(URL uRL) {
        PaletteXML.setURL(uRL);
        try {
            PaletteXML.setPalette((Palette)_o2d.toObject(uRL, Palette.class));
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
    }

    public static void init() {
        try {
            try {
                ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
                URL uRL = extensionRegistry.getSystemDirectory(Ide.getProductID());
                PaletteXML.setURL(URLFactory.newURL(uRL, "palette.xml"));
                PaletteXML.loadPaletteXml(PaletteXML.getURL());
                BUILD_SYSTEM = false;
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
        }
        finally {
            if (_palette == null) {
                _palette = new Palette();
            }
        }
    }

    public static void addPage(Page page) {
        Page[] pageArray = PaletteXML.getPalette().getPage();
        int n = pageArray != null ? pageArray.length : 0;
        Page[] pageArray2 = new Page[n + 1];
        if (pageArray != null) {
            System.arraycopy(pageArray, 0, pageArray2, 0, n);
        }
        pageArray2[n] = page;
        PaletteXML.getPalette().setPage(pageArray2);
    }

    public static void removePage(Page page) {
        Page[] pageArray = PaletteXML.getPalette().getPage();
        ArrayList<Page> arrayList = new ArrayList<Page>();
        int n = pageArray != null ? pageArray.length : 0;
        Page[] pageArray2 = new Page[n - 1];
        if (pageArray != null) {
            int n2 = 0;
            while (n2 < n) {
                arrayList.add(pageArray[n2]);
                ++n2;
            }
            arrayList.remove(page);
            int n3 = arrayList.size();
            int n4 = 0;
            while (n4 < n3) {
                pageArray2[n4] = (Page)arrayList.get(n4);
                ++n4;
            }
            PaletteXML.getPalette().setPage(pageArray2);
        }
    }

    public static void removeAllPages() {
        Page[] pageArray = PaletteXML.getPalette().getPage();
        int n = pageArray != null ? pageArray.length : 0;
        int n2 = 0;
        while (n2 < n) {
            PaletteXML.removePage(pageArray[n2]);
            ++n2;
        }
    }

    public static void addItem(String string, Item item) {
        Page page = PaletteXML.getPage(string);
        Item[] itemArray = page.getItem();
        int n = itemArray != null ? itemArray.length : 0;
        Item[] itemArray2 = new Item[n + 1];
        if (itemArray != null) {
            System.arraycopy(itemArray, 0, itemArray2, 0, n);
        }
        itemArray2[n] = item;
        page.setItem(itemArray2);
    }

    public static void removeItem(String string, Item item) {
        Page page = PaletteXML.getPage(string);
        Item[] itemArray = page.getItem();
        ArrayList<Item> arrayList = new ArrayList<Item>();
        int n = itemArray != null ? itemArray.length : 0;
        Item[] itemArray2 = new Item[n - 1];
        if (itemArray != null) {
            int n2 = 0;
            while (n2 < n) {
                arrayList.add(itemArray[n2]);
                ++n2;
            }
            arrayList.remove(page);
            int n3 = arrayList.size();
            int n4 = 0;
            while (n4 < n3) {
                itemArray2[n4] = (Item)arrayList.get(n4);
                ++n4;
            }
            page.setItem(itemArray2);
        }
    }

    public static void addAddin(Addin addin) {
        Addin[] addinArray = PaletteXML.getPalette().getAddin();
        int n = addinArray != null ? addinArray.length : 0;
        Addin[] addinArray2 = new Addin[n + 1];
        if (addinArray != null) {
            System.arraycopy(addinArray, 0, addinArray2, 0, n);
        }
        addinArray2[n] = addin;
        PaletteXML.getPalette().setAddin(addinArray2);
    }

    public static void removeAddin(Addin addin) {
        Addin[] addinArray = PaletteXML.getPalette().getAddin();
        ArrayList<Addin> arrayList = new ArrayList<Addin>();
        int n = addinArray != null ? addinArray.length : 0;
        Addin[] addinArray2 = new Addin[n - 1];
        if (addinArray != null) {
            int n2 = 0;
            while (n2 < n) {
                arrayList.add(addinArray[n2]);
                ++n2;
            }
            arrayList.remove(addin);
            int n3 = arrayList.size();
            int n4 = 0;
            while (n4 < n3) {
                addinArray2[n4] = (Addin)arrayList.get(n4);
                ++n4;
            }
            PaletteXML.getPalette().setAddin(addinArray2);
        }
    }

    public static void addHistory(History history) {
        History[] historyArray = PaletteXML.getPalette().getHistory();
        int n = historyArray != null ? historyArray.length : 0;
        History[] historyArray2 = new History[n + 1];
        if (historyArray != null) {
            System.arraycopy(historyArray, 0, historyArray2, 0, n);
        }
        historyArray2[n] = history;
        PaletteXML.getPalette().setHistory(historyArray2);
    }

    public static void removeHistory(History history) {
        int n;
        History[] historyArray = PaletteXML.getPalette().getHistory();
        ArrayList<History> arrayList = new ArrayList<History>();
        int n2 = n = historyArray != null ? historyArray.length : 0;
        if (historyArray != null) {
            int n3 = 0;
            while (n3 < n) {
                if (!historyArray[n3].getPalettePage().equals(history.getPalettePage()) || !historyArray[n3].getPageType().equals(history.getPageType())) {
                    arrayList.add(historyArray[n3]);
                }
                ++n3;
            }
            arrayList.remove(history);
            int n4 = arrayList.size();
            History[] historyArray2 = new History[n4];
            int n5 = 0;
            while (n5 < n4) {
                historyArray2[n5] = (History)arrayList.get(n5);
                ++n5;
            }
            PaletteXML.getPalette().setHistory(historyArray2);
        }
    }

    public static History getHistory(String string) {
        History[] historyArray = PaletteXML.getPalette().getHistory();
        int n = historyArray != null ? historyArray.length : 0;
        int n2 = 0;
        while (n2 < n) {
            History history = historyArray[n2];
            if (history.getPageType() != null && history.getPageType().equalsIgnoreCase(string)) {
                return history;
            }
            ++n2;
        }
        return null;
    }

    public static void addJsplibrary(Jsplibrary jsplibrary) {
        String string = jsplibrary.getURI();
        Jsplibrary jsplibrary2 = string != null && string.length() != 0 ? PaletteXML.getJspLibraryByURI(string) : PaletteXML.getJspLibraryByName(jsplibrary.getPrefix());
        if (jsplibrary2 == null) {
            Jsplibrary[] jsplibraryArray = PaletteXML.getPalette().getJsplibrary();
            int n = jsplibraryArray != null ? jsplibraryArray.length : 0;
            Jsplibrary[] jsplibraryArray2 = new Jsplibrary[n + 1];
            if (jsplibraryArray != null) {
                System.arraycopy(jsplibraryArray, 0, jsplibraryArray2, 0, n);
            }
            jsplibraryArray2[n] = jsplibrary;
            PaletteXML.getPalette().setJsplibrary(jsplibraryArray2);
        }
    }

    public static void removeJsplibrary(Jsplibrary jsplibrary) {
        int n;
        Jsplibrary[] jsplibraryArray = PaletteXML.getPalette().getJsplibrary();
        ArrayList<Jsplibrary> arrayList = new ArrayList<Jsplibrary>();
        int n2 = n = jsplibraryArray != null ? jsplibraryArray.length : 0;
        if (jsplibraryArray != null) {
            int n3 = 0;
            while (n3 < n) {
                if (!jsplibraryArray[n3].getPrefix().equals(jsplibrary.getPrefix())) {
                    arrayList.add(jsplibraryArray[n3]);
                }
                ++n3;
            }
            arrayList.remove(jsplibrary);
            int n4 = arrayList.size();
            Jsplibrary[] jsplibraryArray2 = new Jsplibrary[n4];
            int n5 = 0;
            while (n5 < n4) {
                jsplibraryArray2[n5] = (Jsplibrary)arrayList.get(n5);
                ++n5;
            }
            PaletteXML.getPalette().setJsplibrary(jsplibraryArray2);
        }
    }

    public static Jsplibrary getJspLibraryByName(String string) {
        Jsplibrary[] jsplibraryArray = PaletteXML.getPalette().getJsplibrary();
        int n = jsplibraryArray != null ? jsplibraryArray.length : 0;
        int n2 = 0;
        while (n2 < n) {
            if (jsplibraryArray[n2].getPrefix().equals(string)) {
                return jsplibraryArray[n2];
            }
            ++n2;
        }
        return null;
    }

    public static Jsplibrary getJspLibraryByURI(String string) {
        Jsplibrary[] jsplibraryArray = PaletteXML.getPalette().getJsplibrary();
        int n = jsplibraryArray != null ? jsplibraryArray.length : 0;
        int n2 = 0;
        while (n2 < n) {
            if (ModelUtil.areEqual((Object)jsplibraryArray[n2].getURI(), (Object)string)) {
                return jsplibraryArray[n2];
            }
            ++n2;
        }
        return null;
    }

    public static void convertUsingMacros() {
        Jsplibrary[] jsplibraryArray = PaletteXML.getPalette().getJsplibrary();
        int n = jsplibraryArray != null ? jsplibraryArray.length : 0;
        int n2 = 0;
        while (n2 < n) {
            Jsplibrary jsplibrary = jsplibraryArray[n2];
            jsplibrary.setClassesURL(PaletteXML._replace(jsplibrary.getClassesURL()));
            jsplibrary.setIcon(PaletteXML._replace(jsplibrary.getIcon()));
            jsplibrary.setTldURL(PaletteXML._replace(jsplibrary.getTldURL()));
            ++n2;
        }
    }

    public static Page getPage(String string) {
        int n;
        Page[] pageArray = PaletteXML.getPalette().getPage();
        int n2 = n = pageArray != null ? pageArray.length : 0;
        if (pageArray != null) {
            int n3 = 0;
            while (n3 < n) {
                if (pageArray[n3].getName().equals(string)) {
                    return pageArray[n3];
                }
                ++n3;
            }
        }
        return null;
    }

    public static void savePaletteXml() throws Exception {
        if (PaletteXML.getPalette() != null && PaletteXML.getURL() != null) {
            if (!BUILD_SYSTEM) {
                SAVING = true;
                PaletteXML.convertUsingMacros();
            }
            Object2Dom object2Dom = Object2Dom.newInstanceForSchemaCompiledBeans();
            object2Dom.setNamespaceURI(XMLUtil.toNamespaceURI("component-palette"));
            XMLDocument xMLDocument = object2Dom.toDocument(PaletteXML.getPalette(), "palette");
            XMLUtil.writeXML(xMLDocument, PaletteXML.getURL());
            SAVING = false;
        }
    }

    public static void setURL(URL uRL) {
        _url = uRL;
    }

    public static URL getURL() {
        return _url;
    }

    public static void setPalette(Palette palette) {
        _palette = palette;
    }

    public static Palette getPalette() {
        if (_palette == null) {
            PaletteXML.init();
        }
        return _palette;
    }

    public static String _replace(String string) {
        Map map = Ide.getMacros();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("oracle.home", Ide.getOracleHomeDirectory());
        hashMap.put("ide.home", (String)map.get("ide.home"));
        if (string != null) {
            for (String string2 : hashMap.keySet()) {
                String string3 = (String)hashMap.get(string2);
                string3 = string3.replace('\\', '/');
                string = string.replace('\\', '/');
                String string4 = "@" + string2 + "@";
                int n = string.indexOf(string3);
                if (n == -1) continue;
                String string5 = string.substring(0, n);
                String string6 = string.substring(n + string3.length());
                String string7 = string5 + string4 + string6;
                string7 = PaletteXML.replace(string7, "//", "/");
                string7 = PaletteXML.replace(string7, "/@", "@");
                return string7;
            }
        }
        return string;
    }

    private static String replace(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        if (n >= 0) {
            string = string.substring(0, n) + string3 + string.substring(n + string2.length());
            n = string.indexOf(string2);
        }
        return string;
    }
}

