/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLTextField;
import oracle.ide.palette.PaletteItem;
import oracle.ide.palette.PalettePage;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.palette.PaletteController;
import oracle.ideimpl.palette.PaletteItemImpl;
import oracle.ideimpl.resource.PaletteArb;

final class EditItemWizard
extends JFrame
implements ActionListener,
VetoableChangeListener {
    private final PaletteController _controller;
    private JEWTDialog _dlg;
    private final JPanel _panel;
    private PaletteItemImpl _paletteItem;
    private JLabel _itemLbl;
    private JLabel _itemImageLbl;
    private JTextField _itemNameFld;
    private URLTextField _imageFld;
    private JScrollPane _scrollPane;
    private JTextArea _snippetPane;
    private JButton _browseBtn;
    private GridBagLayout gridBagLayout1;
    private PalettePage _palettePage;
    private JLabel _previewLbl;
    private JLabel _imageViewLbl;
    private String _defaultIcon;
    private JButton _defaultBtn;

    void $init$() {
        this._controller = PaletteController.getInstance();
        this._panel = new JPanel();
        this._paletteItem = null;
        this._itemLbl = new JLabel();
        this._itemImageLbl = new JLabel();
        this._itemNameFld = new JTextField();
        this._imageFld = new URLTextField();
        this._scrollPane = new JScrollPane();
        this._snippetPane = new JTextArea();
        this._browseBtn = new JButton();
        this.gridBagLayout1 = new GridBagLayout();
        this._previewLbl = new JLabel();
        this._imageViewLbl = new JLabel();
        this._defaultIcon = null;
        this._defaultBtn = new JButton();
    }

    public boolean invoke(PalettePage palettePage, PaletteItem paletteItem) {
        this._paletteItem = (PaletteItemImpl)paletteItem;
        this._palettePage = palettePage;
        this._defaultIcon = this._paletteItem.getItem().getIcon();
        this._dlg = new JEWTDialog((Frame)((Object)Ide.getMainWindow()), PaletteArb.getString(69), 7);
        this._dlg.setContent((Component)this._panel);
        this._dlg.addVetoableChangeListener((VetoableChangeListener)this);
        this._load();
        HelpSystem.getHelpSystem().registerTopic(this._panel, "f1_idedpaletteedititem_html");
        return WizardLauncher.runDialog((JDialog)this._dlg);
    }

    public PaletteItem getItem() {
        return this._paletteItem;
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)propertyChangeEvent)) {
            if (!this.itemIsValid()) {
                throw new PropertyVetoException("no", propertyChangeEvent);
            }
            String string = this._palettePage.getType();
            if (string.equals("html") || string.equals("java") || string.equals("snippet")) {
                this._paletteItem.setShortLabel(this._itemNameFld.getText());
                this._paletteItem.getItem().setShortLabel(this._itemNameFld.getText());
                this._paletteItem.setIcon(this._imageFld.getText());
                this._paletteItem.getItem().setIcon(this._imageFld.getText());
            } else {
                this._paletteItem.setIcon(this._imageFld.getText());
                this._paletteItem.getItem().setIcon(this._imageFld.getText());
            }
            if (string.equals("snippet")) {
                this._paletteItem.getItem().setCodeSnippet(this._snippetPane.getText());
            }
        }
    }

    public boolean itemIsValid() {
        String string = this._palettePage.getType();
        if (this._itemNameFld.getText().trim().length() == 0) {
            MessageDialog.error((Component)this._dlg, PaletteArb.getString(70), PaletteArb.getString(65), null);
            return false;
        }
        if (string.equals("snippet") && this._snippetPane.getText().trim().length() == 0) {
            MessageDialog.error((Component)this._dlg, "No snippet text is defined. Please define snippet text.", PaletteArb.getString(65), null);
            this._snippetPane.requestFocus();
            return false;
        }
        Iterator iterator = this._palettePage.getChildren();
        while (iterator.hasNext()) {
            PaletteItem paletteItem = (PaletteItem)iterator.next();
            if (!paletteItem.getShortLabel().equals(this._itemNameFld.getText()) || paletteItem == this._paletteItem) continue;
            MessageDialog.error((Component)this._dlg, "Cannot have duplicate names. Please assign a unique name for the component.", PaletteArb.getString(65), null);
            return false;
        }
        ImageIcon imageIcon = this._controller.getDefinedImage(this._imageFld.getText());
        if (imageIcon == null || imageIcon.getIconWidth() < 1) {
            MessageDialog.error((Component)this._dlg, PaletteArb.getString(71), PaletteArb.getString(65), "");
            return false;
        }
        return true;
    }

    public EditItemWizard() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        ResourceUtils.resLabel(this._itemLbl, this._itemNameFld, PaletteArb.getString(72));
        ResourceUtils.resLabel(this._itemImageLbl, (Component)((Object)this._imageFld), PaletteArb.getString(73));
        ResourceUtils.resButton(this._browseBtn, PaletteArb.getString(75));
        ResourceUtils.resButton(this._defaultBtn, PaletteArb.getString(76));
        this._panel.setLayout(this.gridBagLayout1);
        this._imageFld.addKeyListener(new 1());
        this._scrollPane.setBorder(BorderFactory.createTitledBorder(PaletteArb.getString(74)));
        this._previewLbl.setText(PaletteArb.getString(77));
        this._scrollPane.getViewport().add((Component)this._snippetPane, null);
        this._panel.add((Component)this._browseBtn, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._panel.add((Component)this._scrollPane, new GridBagConstraints(0, 4, 5, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this._panel.add((Component)((Object)this._imageFld), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this._panel.add((Component)this._itemNameFld, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this._panel.add((Component)this._itemImageLbl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._panel.add((Component)this._itemLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._panel.add((Component)this._previewLbl, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._panel.add((Component)this._imageViewLbl, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this._panel.add((Component)this._defaultBtn, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._scrollPane.setPreferredSize(new Dimension(300, 200));
        this._browseBtn.addActionListener(this);
        this._defaultBtn.addActionListener(this);
        this._snippetPane.setWrapStyleWord(true);
        this._snippetPane.setLineWrap(true);
        this._defaultBtn.setEnabled(false);
    }

    private void _load() {
        String string = this._paletteItem.getShortLabel();
        String string2 = this._paletteItem.getItem().getIcon();
        String string3 = this._palettePage.getType();
        String string4 = this._paletteItem.getItem().getCodeSnippet();
        if (string3.equals("jsp")) {
            this._itemNameFld.setText(string);
            this._itemNameFld.setEnabled(false);
            this._imageFld.setText(string2);
            this._scrollPane.setVisible(false);
        } else if (string3.equals("java")) {
            this._itemNameFld.setText(string);
            this._imageFld.setText(string2);
            this._scrollPane.setVisible(false);
        } else if (string3.equals("html")) {
            this._itemNameFld.setText(string);
            this._imageFld.setText(string2);
            this._scrollPane.setVisible(false);
        } else if (string3.equals("snippet")) {
            this._itemNameFld.setText(string);
            this._imageFld.setText(string2);
            this._snippetPane.setText(string4);
        }
        this._imageViewLbl.setIcon(this._paletteItem.getIcon());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._defaultBtn) {
            this._imageFld.setText(this._defaultIcon);
            this._imageViewLbl.setIcon(this._paletteItem.getIcon());
            this._defaultBtn.setEnabled(false);
            this.invalidate();
            this.repaint();
        } else {
            URL uRL = this.showImageDialog();
            if (uRL != null) {
                this._imageFld.setURL(uRL);
                this._defaultBtn.setEnabled(true);
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                Image image = toolkit.getImage(uRL);
                if (image != null) {
                    this._imageViewLbl.setText("");
                    ImageIcon imageIcon = new ImageIcon(image);
                    this._imageViewLbl.setIcon(imageIcon);
                } else {
                    this._imageViewLbl.setText(PaletteArb.getString(71));
                }
                this.invalidate();
                this.repaint();
            }
        }
    }

    private URL showImageDialog() {
        String[] stringArray = GraphicsUtils.getImageExtensions();
        URLChooser uRLChooser = DialogUtil.newURLChooser(URLFactory.newURL(null));
        uRLChooser.setURLFilter(new DefaultURLFilter("Image Files", stringArray));
        uRLChooser.setSelectionScope(0);
        int n = uRLChooser.showOpenDialog((Component)((Object)Ide.getMainWindow()), "Select Image Source");
        if (n == 0) {
            return uRLChooser.getSelectedURL();
        }
        return null;
    }

    private void keyHasBeenTyped(KeyEvent keyEvent) {
        this._defaultBtn.setEnabled(true);
    }

    static void mav$keyHasBeenTyped(EditItemWizard editItemWizard, KeyEvent keyEvent) {
        editItemWizard.keyHasBeenTyped(keyEvent);
    }

    final class 1
    extends KeyAdapter {
        public void keyReleased(KeyEvent keyEvent) {
            EditItemWizard.mav$keyHasBeenTyped(EditItemWizard.this, keyEvent);
        }
    }
}

