/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.Context;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.palette.Invokable;
import oracle.ide.palette.PaletteItem;
import oracle.ide.palette.PaletteModelListener;
import oracle.ide.palette.PalettePage;
import oracle.ide.util.AccessibleUtils;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.palette.PaletteCommands;
import oracle.ideimpl.palette.PaletteController;
import oracle.ideimpl.palette.PaletteImpl;
import oracle.ideimpl.palette.PaletteItemImpl;
import oracle.ideimpl.palette.wizard.ChangeImageDialog;
import oracle.ideimpl.palette.wizard.EditItemWizard;
import oracle.ideimpl.palette.wizard.ListIconRenderer;
import oracle.ideimpl.palette.wizard.NewPageWizard;
import oracle.ideimpl.palette.wizard.RenamePalettePageWizard;
import oracle.ideimpl.resource.PaletteArb;

public class PagePanel
extends JPanel
implements ActionListener,
PaletteModelListener,
ListSelectionListener {
    private DefaultListModel _pageModel;
    private DefaultListModel _componentModel;
    private PaletteImpl _palette;
    private PaletteController _controller;
    private PaletteCommands _commands;
    private RenamePalettePageWizard _renameWizard;
    private EditItemWizard _editItemWizard;
    private GridBagLayout _mainLayout;
    private JSplitPane _splitPane;
    private JPanel _pagePanel;
    private JPanel _componentPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane _pageScrollPane;
    private JScrollPane _componentScrollPane;
    private JList _pageList;
    private JList _componentList;
    private JButton _addPageBtn;
    private JButton _removePageBtn;
    private ListIconRenderer renderer;
    private JPanel _pageBtnPanel;
    private JPanel _componentBtnPanel;
    private GridLayout _pageBtnLayout;
    private GridLayout _componentBtnLayout;
    private JButton _addComponentBtn;
    private JButton _removeItemBtn;
    private JLabel _pageTypeLbl;
    private JComboBox _pageTypeBox;
    private GridBagLayout _pagePanelLayout;
    private GridBagLayout _componentPanelLayout;
    private Invokable _wizard;
    private Context _context;
    private JButton _renamePageBtn;
    private JButton _editComponentBtn;

    void $init$() {
        this._pageModel = new DefaultListModel();
        this._componentModel = new DefaultListModel();
        this._palette = PaletteImpl.getInstance();
        this._controller = PaletteController.getInstance();
        this._commands = new PaletteCommands();
        this._renameWizard = null;
        this._editItemWizard = null;
        this._mainLayout = new GridBagLayout();
        this._splitPane = new JSplitPane();
        this._pagePanel = new JPanel();
        this._componentPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this._pageScrollPane = new JScrollPane();
        this._componentScrollPane = new JScrollPane();
        this._pageList = new JList(this._pageModel);
        this._componentList = new JList(this._componentModel);
        this._addPageBtn = new JButton();
        this._removePageBtn = new JButton();
        this.renderer = new ListIconRenderer();
        this._pageBtnPanel = new JPanel();
        this._componentBtnPanel = new JPanel();
        this._pageBtnLayout = new GridLayout();
        this._componentBtnLayout = new GridLayout();
        this._addComponentBtn = new JButton();
        this._removeItemBtn = new JButton();
        this._pageTypeLbl = new JLabel();
        this._pagePanelLayout = new GridBagLayout();
        this._componentPanelLayout = new GridBagLayout();
        this._renamePageBtn = new JButton();
        this._editComponentBtn = new JButton();
    }

    public PagePanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void jbInit() throws Exception {
        this._pageTypeBox = new JComboBox(this._controller.getList());
        this._pageTypeBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        ResourceUtils.resLabel(this.jLabel1, this._pageList, PaletteArb.getString(45));
        ResourceUtils.resLabel(this.jLabel2, this._componentList, PaletteArb.getString(46));
        ResourceUtils.resButton(this._addPageBtn, PaletteArb.getString(47));
        ResourceUtils.resButton(this._removePageBtn, PaletteArb.getString(48));
        ResourceUtils.resButton(this._addComponentBtn, PaletteArb.getString(49));
        ResourceUtils.resButton(this._removeItemBtn, PaletteArb.getString(50));
        ResourceUtils.resLabel(this._pageTypeLbl, this._pageTypeBox, PaletteArb.getString(51));
        ResourceUtils.resButton(this._renamePageBtn, PaletteArb.getString(63));
        ResourceUtils.resButton(this._editComponentBtn, PaletteArb.getString(79));
        AccessibleUtils.updateAccessibleName(this._addPageBtn, "Add Palette Page", true);
        AccessibleUtils.updateAccessibleName(this._removePageBtn, "Remove Palette Page", true);
        AccessibleUtils.updateAccessibleName(this._renamePageBtn, "Rename Palette Page", true);
        AccessibleUtils.updateAccessibleName(this._removeItemBtn, "Remove Component", true);
        AccessibleUtils.updateAccessibleName(this._addComponentBtn, "Add Component", true);
        AccessibleUtils.updateAccessibleName(this._editComponentBtn, "Edit Component", true);
        this._pageList.setSelectionMode(0);
        this._addPageBtn.addActionListener(this);
        this._removePageBtn.addActionListener(this);
        this._removeItemBtn.addActionListener(this);
        this._addComponentBtn.addActionListener(this);
        this.setLayout(this._mainLayout);
        this._splitPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this._pagePanel.setLayout(this._pagePanelLayout);
        this._componentPanel.setLayout(this._componentPanelLayout);
        this._pageBtnPanel.setLayout(this._componentBtnLayout);
        this._componentBtnPanel.setLayout(this._pageBtnLayout);
        this._pageBtnLayout.setHgap(5);
        this._componentBtnLayout.setHgap(5);
        this.add((Component)this._pageTypeLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this._pageTypeBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this._pageScrollPane.getViewport().add((Component)this._pageList, null);
        this._pagePanel.add((Component)this._pageScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 2), 0, 0));
        this._pagePanel.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 2), 0, 0));
        this._pageBtnPanel.add((Component)this._addPageBtn, null);
        this._pageBtnPanel.add((Component)this._removePageBtn, null);
        this._pageBtnPanel.add((Component)this._renamePageBtn, null);
        this._pagePanel.add((Component)this._pageBtnPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 2), 0, 0));
        this._splitPane.add((Component)this._pagePanel, "left");
        this._componentScrollPane.getViewport().add((Component)this._componentList, null);
        this._componentPanel.add((Component)this._componentScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 2, 0, 0), 0, 0));
        this._componentPanel.add((Component)this.jLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 2, 0, 0), 0, 0));
        this._componentBtnPanel.add((Component)this._addComponentBtn, null);
        this._componentBtnPanel.add((Component)this._removeItemBtn, null);
        this._componentBtnPanel.add((Component)this._editComponentBtn, null);
        this._componentPanel.add((Component)this._componentBtnPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 2, 0, 0), 0, 0));
        this._splitPane.add((Component)this._componentPanel, "right");
        this.add((Component)this._splitPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        this._renamePageBtn.addActionListener(this);
        this._componentList.setCellRenderer(this.renderer);
        this._pageTypeBox.addActionListener(this);
        this._editComponentBtn.addActionListener(this);
    }

    protected void populatePageList() {
        if (!this._palette.getHasPopulated()) {
            this._palette.populate();
        }
        this.showPages("All");
    }

    public void populateComponents(String string) {
        if (string != null) {
            Iterator iterator;
            boolean bl;
            this._componentList.removeListSelectionListener(this);
            this._componentModel.removeAllElements();
            PalettePage palettePage = this._palette.getPalettePage(string);
            boolean bl2 = bl = palettePage != null && palettePage.getCanRemove();
            if (!bl) {
                this._removePageBtn.setEnabled(false);
                this._renamePageBtn.setEnabled(false);
            } else {
                this._removePageBtn.setEnabled(true);
                this._renamePageBtn.setEnabled(true);
            }
            PalettePage palettePage2 = this._palette.getPalettePage(string);
            Iterator iterator2 = iterator = palettePage2 != null ? palettePage2.getPaletteItems().iterator() : null;
            if (iterator != null) {
                while (iterator.hasNext()) {
                    PaletteItem paletteItem = (PaletteItem)iterator.next();
                    ImageIcon imageIcon = (ImageIcon)paletteItem.getIcon();
                    if (imageIcon == null) continue;
                    String string2 = paletteItem.getShortLabel();
                    imageIcon.setDescription(string2);
                    this._componentModel.addElement(imageIcon);
                }
            }
            this._componentList.addListSelectionListener(this);
            this._editComponentBtn.setEnabled(false);
            this._removeItemBtn.setEnabled(false);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        Object object = listSelectionEvent.getSource();
        if (object == this._pageList) {
            if (this._pageModel.getSize() > 0) {
                String string = this.getSelectedPage();
                if (string != null) {
                    boolean bl;
                    PalettePage palettePage = this._palette.getPalettePage(string);
                    boolean bl2 = bl = palettePage != null && palettePage.isPersistent() && PaletteCommands.hasEditor(palettePage.getType());
                    if (bl) {
                        this._addComponentBtn.setEnabled(true);
                    } else {
                        this._addComponentBtn.setEnabled(false);
                    }
                    this._palette.setEditPage(palettePage);
                    this.populateComponents(string);
                    this._removeItemBtn.setEnabled(false);
                    this._editComponentBtn.setEnabled(false);
                    if (palettePage != null && palettePage.getCanRemove()) {
                        this._removePageBtn.setEnabled(true);
                        this._renamePageBtn.setEnabled(true);
                    }
                } else {
                    this._addComponentBtn.setEnabled(false);
                }
            }
        } else {
            PalettePage palettePage;
            ImageIcon imageIcon = (ImageIcon)this._componentList.getSelectedValue();
            boolean bl = false;
            if (imageIcon != null) {
                PaletteItemImpl paletteItemImpl = (PaletteItemImpl)this._palette.getPaletteItem(imageIcon.getDescription(), this.getSelectedPage());
                bl = paletteItemImpl.getCanRemove();
            }
            if ((palettePage = this._palette.getPalettePage(this.getSelectedPage())) != null) {
                bl = bl ? palettePage.isPersistent() : false;
                String string = palettePage.getType();
                if (palettePage.isPersistent() && (string.equals("jsp") || string.equals("html") || string.equals("java") || string.equals("snippet"))) {
                    this._editComponentBtn.setEnabled(true);
                } else {
                    this._editComponentBtn.setEnabled(false);
                }
            }
            this._removeItemBtn.setEnabled(bl);
        }
    }

    private void addPage() {
        try {
            String string = (String)this._pageTypeBox.getSelectedItem();
            if (string.equals("All") && this._pageList.getModel().getSize() > 0 && this._pageList.getSelectedValue() != null) {
                PalettePage palettePage = this._palette.getPalettePage(this.getSelectedPage());
                string = palettePage.getType();
            }
            new NewPageWizard().invoke(string, this._context, this._controller.getList());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void removePage() {
        String string = this.getSelectedPage();
        if (string != null) {
            PalettePage palettePage = this._palette.getPalettePage(string);
            boolean bl = palettePage.getCanRemove();
            if (bl) {
                int n = this._pageList.getSelectedIndex();
                if (string != null) {
                    PalettePage palettePage2 = this._palette.getPalettePage(string);
                    this._palette.setActivePage(palettePage2);
                    try {
                        boolean bl2 = this._commands.removePalettePage();
                        if (bl2) {
                            this._componentModel.removeAllElements();
                            this.validate();
                            this._pageList.setSelectedIndex(n - 1);
                            if (this._pageList.getModel().getSize() == 0) {
                                this._renamePageBtn.setEnabled(false);
                                this._removePageBtn.setEnabled(false);
                                this._addComponentBtn.setEnabled(false);
                            }
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            } else {
                MessageDialog.error(this, PaletteArb.getString(66), PaletteArb.getString(65), null);
            }
        }
    }

    private void addItem() {
        try {
            String string = this.getSelectedPage();
            PalettePage palettePage = this._palette.getPalettePage(string);
            if (palettePage != null) {
                this._commands.invokeItemWizard(palettePage);
                this.populateComponents(this.getSelectedPage());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getSelectedPage() {
        String string = null;
        try {
            string = (String)this._pageList.getSelectedValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public String getSelectedItem() {
        ImageIcon imageIcon = (ImageIcon)this._componentList.getSelectedValue();
        return imageIcon.getDescription();
    }

    private void removeItem() {
        ImageIcon imageIcon = (ImageIcon)this._componentList.getSelectedValue();
        PalettePage palettePage = this._palette.getPalettePage(this.getSelectedPage());
        PaletteItemImpl paletteItemImpl = (PaletteItemImpl)this._palette.getPaletteItem(imageIcon.getDescription(), this.getSelectedPage());
        boolean bl = paletteItemImpl.getCanRemove();
        if (!bl) {
            MessageDialog.error(this, PaletteArb.getString(64), PaletteArb.getString(65), null);
        } else if (imageIcon != null) {
            boolean bl2 = false;
            bl2 = this._componentList.getSelectedValues().length > 1 ? MessageDialog.confirm(this, PaletteArb.format(97, "\"" + imageIcon.getDescription() + "\"", "\"" + palettePage.getShortLabel() + "\""), PaletteArb.getString(96), null) : MessageDialog.confirm(this, PaletteArb.format(95, "\"" + imageIcon.getDescription() + "\"", "\"" + palettePage.getShortLabel() + "\""), PaletteArb.getString(94), null);
            if (bl2) {
                Object[] objectArray = this._componentList.getSelectedValues();
                int n = objectArray != null ? objectArray.length : 0;
                int n2 = 0;
                while (n2 < n) {
                    ImageIcon imageIcon2 = (ImageIcon)objectArray[n2];
                    String string = imageIcon2.getDescription();
                    this._palette.removeItem(string, this.getSelectedPage());
                    this._componentModel.removeElement(imageIcon2);
                    this._editComponentBtn.setEnabled(false);
                    this._removeItemBtn.setEnabled(false);
                    ++n2;
                }
                this.repaint();
            }
        }
    }

    public void palettePageAdded(PalettePage palettePage) {
        String string = (String)this._pageTypeBox.getSelectedItem();
        if (string.equals("All") || string.equals(palettePage.getType())) {
            this._pageModel.addElement(palettePage.getShortLabel());
            this._pageList.setSelectedIndex(this._pageModel.getSize() - 1);
            String string2 = this.getSelectedPage();
            this.populateComponents(string2);
            this._pageList.ensureIndexIsVisible(this._pageModel.getSize() - 1);
        }
    }

    public void palettePageRemoved(PalettePage palettePage) {
        this._pageModel.removeElement(this._pageList.getSelectedValue());
    }

    public void paletteItemAdded(PaletteItem paletteItem) {
        this._controller.refreshPalette();
    }

    public void paletteItemRemoved(PaletteItem paletteItem) {
        this._controller.refreshPalette();
    }

    public void palettePageRenamed(String string, PalettePage palettePage) {
    }

    public void paletteItemRenamed(String string, PaletteItem paletteItem) {
        ImageIcon imageIcon = (ImageIcon)this._componentList.getSelectedValue();
        int n = this._componentList.getSelectedIndex();
        imageIcon = (ImageIcon)paletteItem.getIcon();
        imageIcon.setDescription(paletteItem.getShortLabel());
        String string2 = this.getSelectedPage();
        if (string2 != null) {
            this.populateComponents(string2);
        }
        this._componentList.setSelectedIndex(n);
        PaletteItemImpl paletteItemImpl = (PaletteItemImpl)paletteItem;
        PalettePage palettePage = this._palette.getPalettePage(this.getSelectedPage());
        if (this._controller.getPaletteUI() != null) {
            this._controller.getPaletteUI().updateItem(palettePage, paletteItemImpl);
            this._controller.refreshPalette();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JComponent jComponent = (JComponent)actionEvent.getSource();
        if (jComponent == this._addPageBtn) {
            this.addPage();
        } else if (jComponent == this._removePageBtn) {
            this.removePage();
        } else if (jComponent == this._removeItemBtn) {
            this.removeItem();
        } else if (jComponent == this._pageTypeBox) {
            String string = (String)this._pageTypeBox.getSelectedItem();
            this._removeItemBtn.setEnabled(false);
            this._editComponentBtn.setEnabled(false);
            this.showPages(string);
            if (this._pageList.getModel().getSize() > 0) {
                String string2 = this.getSelectedPage();
                if (string2 == null && this._pageList.getModel().getSize() > 0) {
                    this._pageList.setSelectedIndex(0);
                    string2 = this.getSelectedPage();
                }
                if (string2 != null) {
                    this.populateComponents(string2);
                    PalettePage palettePage = this._palette.getPalettePage(string2);
                    boolean bl = true;
                    if (!palettePage.getCanRemove()) {
                        bl = false;
                    }
                    this._removePageBtn.setEnabled(bl);
                    this._renamePageBtn.setEnabled(bl);
                    this._addComponentBtn.setEnabled(palettePage.isPersistent() && PaletteCommands.hasEditor(palettePage.getType()));
                }
            } else {
                this._removePageBtn.setEnabled(false);
                this._renamePageBtn.setEnabled(false);
                this._addComponentBtn.setEnabled(false);
            }
        } else if (jComponent == this._addComponentBtn) {
            if (this._pageModel.getSize() > 0) {
                String string = this.getSelectedPage();
                PalettePage palettePage = this._palette.getPalettePage(string);
                String string3 = palettePage.getType();
                this._commands.invokeItemWizard(palettePage);
                this._palette.setEditPage(palettePage);
                this.populateComponents(this.getSelectedPage());
            }
        } else if (jComponent == this._renamePageBtn) {
            if (this._pageModel.getSize() > 0) {
                String string = this.getSelectedPage();
                PalettePage palettePage = this._palette.getPalettePage(string);
                boolean bl = palettePage.getCanRemove();
                if (!bl) {
                    MessageDialog.error(this, PaletteArb.getString(98), PaletteArb.getString(99), null);
                    return;
                }
                this._renameWizard = new RenamePalettePageWizard();
                String string4 = this._renameWizard.invoke(palettePage);
                if (string4 != null) {
                    palettePage.setName(string4);
                    this._palette.firePalettePageRenamed(string, palettePage);
                    int n = this._pageList.getSelectedIndex();
                    this._pageModel.set(n, string4);
                }
            }
        } else if (jComponent == this._editComponentBtn) {
            String string = this.getSelectedItem();
            this._editItemWizard = new EditItemWizard();
            PaletteItem paletteItem = this._palette.getPaletteItem(string, this.getSelectedPage());
            PalettePage palettePage = this._palette.getPalettePage(this.getSelectedPage());
            String string5 = palettePage.getType();
            if (string5.equals("jsp") || string5.equals("html") || string5.equals("java") || string5.equals("snippet")) {
                boolean bl = this._editItemWizard.invoke(palettePage, paletteItem);
                if (bl) {
                    paletteItem = this._editItemWizard.getItem();
                    this._palette.firePaletteItemRenamed(string, paletteItem);
                }
            } else {
                MessageDialog.error(this, PaletteArb.getString(100), PaletteArb.getString(99), null);
            }
        } else {
            ChangeImageDialog changeImageDialog = new ChangeImageDialog();
            ImageIcon imageIcon = (ImageIcon)this._componentList.getSelectedValue();
            if (imageIcon != null) {
                String string = this.getSelectedItem();
                PaletteItemImpl paletteItemImpl = (PaletteItemImpl)this._palette.getPaletteItem(string, this.getSelectedPage());
                changeImageDialog.invoke(string, paletteItemImpl);
            }
        }
        this._wizard = null;
    }

    private void showPages(String string) {
        Iterator iterator = this._palette.getChildren();
        this._pageModel.removeAllElements();
        this._componentModel.removeAllElements();
        this._palette.removePaletteModelListener(this);
        this._pageList.removeListSelectionListener(this);
        while (iterator.hasNext()) {
            PalettePage palettePage = (PalettePage)iterator.next();
            if (!palettePage.canShow()) continue;
            String string2 = palettePage.getName();
            String string3 = palettePage.getType();
            if (string.equals("All")) {
                this._pageModel.addElement(palettePage.getShortLabel());
                continue;
            }
            if (!string3.equalsIgnoreCase(string)) continue;
            this._pageModel.addElement(palettePage.getShortLabel());
        }
        this._editComponentBtn.setEnabled(false);
        this._removeItemBtn.setEnabled(false);
        this._palette.addPaletteModelListener(this);
        this._pageList.addListSelectionListener(this);
        if (this._palette.getActivePage() != null) {
            String string4 = this._palette.getActivePage().getShortLabel();
            this._pageList.setSelectedValue(string4, true);
        } else {
            this._pageList.setSelectedIndex(0);
        }
    }

    public void setContext(Context context) {
        this._context = context;
    }

    private void makeSameSize(JButton[] jButtonArray) {
        if (jButtonArray.length == 0) {
            return;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < jButtonArray.length) {
            int n3 = jButtonArray[n2].getPreferredSize().width;
            n = n3 > n ? n3 : n;
            ++n2;
        }
        Dimension dimension = new Dimension(n, jButtonArray[0].getPreferredSize().height);
        int n4 = 0;
        while (n4 < jButtonArray.length) {
            jButtonArray[n4].setPreferredSize(dimension);
            ++n4;
        }
    }
}

