/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.Ide;
import oracle.ide.palette.PaletteItem;
import oracle.ide.palette.PaletteModelListener;
import oracle.ide.palette.PalettePage;
import oracle.ideimpl.palette.PaletteCommands;
import oracle.ideimpl.palette.PaletteImpl;
import oracle.ideimpl.palette.wizard.ListIconRenderer;
import oracle.ideimpl.palette.wizard.PalettePnl__addItemBtn_actionAdapter;
import oracle.ideimpl.palette.wizard.PalettePnl__addPageBtn_actionAdapter;
import oracle.ideimpl.palette.wizard.PalettePnl__removeItemBtn_actionAdapter;
import oracle.ideimpl.palette.wizard.PalettePnl__removePageBtn_actionAdapter;

public class PalettePnl
extends JPanel
implements PaletteModelListener,
ListSelectionListener {
    private final DefaultListModel _pageModel;
    private final DefaultListModel _componentModel;
    private final PaletteImpl _palette;
    private final PaletteCommands _commands;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private final JScrollPane _pageScrollPane;
    private final JScrollPane _componentScrollPane;
    private final JList _pageList;
    private final JList _componentList;
    private JButton _addPageBtn;
    private JButton _removePageBtn;
    private JButton _addItemBtn;
    private ListIconRenderer renderer;
    private JButton _removeItemBtn;
    private final GridBagLayout gridBagLayout1;

    void $init$() {
        this._pageModel = new DefaultListModel();
        this._componentModel = new DefaultListModel();
        this._palette = PaletteImpl.getInstance();
        this._commands = new PaletteCommands();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this._pageScrollPane = new JScrollPane();
        this._componentScrollPane = new JScrollPane();
        this._pageList = new JList(this._pageModel);
        this._componentList = new JList(this._componentModel);
        this._addPageBtn = new JButton();
        this._removePageBtn = new JButton();
        this._addItemBtn = new JButton();
        this.renderer = new ListIconRenderer();
        this._removeItemBtn = new JButton();
        this.gridBagLayout1 = new GridBagLayout();
    }

    public PalettePnl() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setPreferredSize(new Dimension(380, 400));
        this._pageList.addListSelectionListener(this);
        this._palette.addPaletteModelListener(this);
        this.jLabel1.setText("Pages:");
        this.jLabel2.setText("Components:");
        this._addPageBtn.setText("Add...");
        this._addPageBtn.addActionListener(new PalettePnl__addPageBtn_actionAdapter(this));
        this._removePageBtn.setText("Remove...");
        this._removePageBtn.addActionListener(new PalettePnl__removePageBtn_actionAdapter(this));
        this._addItemBtn.setText("Add Item(s)");
        this._addItemBtn.addActionListener(new PalettePnl__addItemBtn_actionAdapter(this));
        this._removeItemBtn.setText("Remove Item(s)");
        this._removeItemBtn.addActionListener(new PalettePnl__removeItemBtn_actionAdapter(this));
        this.setLayout(this.gridBagLayout1);
        this.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.jLabel2, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this._pageScrollPane, new GridBagConstraints(0, 1, 4, 1, 0.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this._pageScrollPane.getViewport().add((Component)this._pageList, null);
        this.add((Component)this._componentScrollPane, new GridBagConstraints(4, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this._componentScrollPane.getViewport().add((Component)this._componentList, null);
        this.add((Component)this._addPageBtn, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this._removePageBtn, new GridBagConstraints(2, 2, 2, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this._addItemBtn, new GridBagConstraints(4, 2, 2, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this._removeItemBtn, new GridBagConstraints(6, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._componentList.setCellRenderer(this.renderer);
    }

    protected void populatePageList() {
        if (!this._palette.getHasPopulated()) {
            this._palette.populate();
        }
        Iterator iterator = this._palette.getChildren();
    }

    private void _populateComponents(String string) {
        if (string != null) {
            this._componentModel.removeAllElements();
            PalettePage palettePage = this._palette.getPalettePage(string);
            for (PaletteItem paletteItem : palettePage.getPaletteItems()) {
                ImageIcon imageIcon = (ImageIcon)paletteItem.getIcon();
                String string2 = paletteItem.getShortLabel();
                imageIcon.setDescription(string2);
                this._componentModel.addElement(imageIcon);
            }
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this._pageModel.getSize() > 0) {
            String string = (String)this._pageList.getSelectedValue();
            this._populateComponents(string);
        }
    }

    void addPage(ActionEvent actionEvent) {
    }

    void removePage(ActionEvent actionEvent) {
        String string = (String)this._pageList.getSelectedValue();
        if (string != null) {
            PalettePage palettePage = this._palette.getPalettePage(string);
            this._palette.setActivePage(palettePage);
            try {
                boolean bl = this._commands.removePalettePage();
                if (bl) {
                    this._componentModel.removeAllElements();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    void addItem(ActionEvent actionEvent) {
        try {
            PalettePage palettePage = this._palette.getPalettePage((String)this._pageList.getSelectedValue());
            if (palettePage != null) {
                this._commands.invokeItemWizard(palettePage);
                this._populateComponents((String)this._pageList.getSelectedValue());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void removeItem(ActionEvent actionEvent) {
        ImageIcon imageIcon = (ImageIcon)this._componentList.getSelectedValue();
        if (imageIcon != null) {
            String string = imageIcon.getDescription();
            int n = JOptionPane.showConfirmDialog((Component)((Object)Ide.getMainWindow()), "Are you sure you want to remove \"" + string + "\"?", "Removing Palette Page", 0);
            if (n == 0) {
                this._palette.removeItem(string, (String)this._pageList.getSelectedValue());
                this._componentModel.removeElement(imageIcon);
            }
        }
    }

    public void palettePageAdded(PalettePage palettePage) {
        this._pageModel.addElement(palettePage.getName());
        this._pageList.setSelectedIndex(0);
        String string = (String)this._pageList.getSelectedValue();
        this._populateComponents(string);
    }

    public void palettePageRemoved(PalettePage palettePage) {
        this._pageModel.removeElement(this._pageList.getSelectedValue());
    }

    public void paletteItemAdded(PaletteItem paletteItem) {
    }

    public void paletteItemRemoved(PaletteItem paletteItem) {
    }

    public void palettePageRenamed(String string, PalettePage palettePage) {
    }

    public void paletteItemRenamed(String string, PaletteItem paletteItem) {
    }
}

