/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.plaf;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeCellRenderer;

public class DefaultTreeCellRendererFocusFix
extends DefaultTreeCellRenderer {
    private boolean drawsFocusBorderAroundIcon;

    public DefaultTreeCellRendererFocusFix() {
        Object object = UIManager.get("Tree.drawsFocusBorderAroundIcon");
        this.drawsFocusBorderAroundIcon = object != null && (Boolean)object != false;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Border border = UIManager.getBorder("Tree.focusBorder");
        if (border == null) {
            return;
        }
        Color color = this.selected ? this.getBackgroundSelectionColor() : this.getBackgroundNonSelectionColor();
        if (color == null) {
            color = this.getBackground();
        }
        int n = -1;
        if (color != null) {
            n = this.getLabelStart();
        }
        if (this.hasFocus) {
            int n2;
            int n3;
            int n4;
            int n5;
            if (this.drawsFocusBorderAroundIcon) {
                n = 0;
            } else if (n == -1) {
                n = this.getLabelStart();
            }
            if (this.getComponentOrientation().isLeftToRight()) {
                n5 = n;
                n4 = 0;
                n3 = this.getWidth() - 1 - n;
                n2 = this.getHeight() - 1;
            } else {
                n5 = 0;
                n4 = 0;
                n3 = this.getWidth() - 1 - n;
                n2 = this.getHeight() - 1;
            }
            Color color2 = graphics.getColor();
            graphics.setColor(color);
            graphics.drawRect(n5, n4, n3, n2);
            Color color3 = this.selected ? this.getTextSelectionColor() : this.getTextNonSelectionColor();
            graphics.setColor(color3);
            border.paintBorder(this, graphics, n5, n4, n3 + 1, n2 + 1);
            graphics.setColor(color2);
        }
    }

    private int getLabelStart() {
        Icon icon = this.getIcon();
        if (icon != null && this.getText() != null) {
            return icon.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
        }
        return 0;
    }
}

