/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.plaf;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.plaf.UIResource;

public class ImageIconUIResource
extends ImageIcon
implements UIResource {
    private Icon icon;
    private boolean nullConversionFailed;

    public ImageIconUIResource(Icon icon) {
        this.icon = icon;
    }

    public Image getImage() {
        if (this.icon != null && !this.nullConversionFailed) {
            this.nullConversion();
        }
        return super.getImage();
    }

    public void setImage(Image image) {
        super.setImage(image);
        this.icon = null;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        if (this.icon != null) {
            this.componentConversion(component);
        }
        if (!this.nullConversionFailed && super.getImage() != null) {
            super.paintIcon(component, graphics, n, n2);
        } else if (this.icon != null) {
            this.icon.paintIcon(component, graphics, n, n2);
        }
    }

    public int getIconHeight() {
        return this.icon != null ? this.icon.getIconHeight() : super.getIconHeight();
    }

    public int getIconWidth() {
        return this.icon != null ? this.icon.getIconWidth() : super.getIconWidth();
    }

    private void nullConversion() {
        if (this.convertToImage(null)) {
            this.icon = null;
        } else {
            this.nullConversionFailed = true;
        }
    }

    private void componentConversion(Component component) {
        if (!this.nullConversionFailed) {
            this.nullConversion();
        }
        if (this.nullConversionFailed && component != null) {
            this.convertToImage(component);
        }
    }

    private boolean convertToImage(Component component) {
        boolean bl;
        Image image = this.createImage();
        if (image == null) {
            return false;
        }
        Graphics graphics = image.getGraphics();
        try {
            this.icon.paintIcon(component, graphics, 0, 0);
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    private Image createImage() {
        Image image = super.getImage();
        if (this.icon != null) {
            int n = this.icon.getIconWidth();
            int n2 = this.icon.getIconHeight();
            if (n != 0 && n2 != 0 && (image == null || n != image.getWidth(null) || n2 != image.getHeight(null))) {
                image = new BufferedImage(n, n2, 2);
                super.setImage(image);
            }
        }
        return image;
    }
}

