/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.plaf;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicListUI;
import oracle.ide.util.JDK;

public class WindowsListUI
extends BasicListUI {
    private KeyListener keyListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsListUI();
    }

    protected void installListeners() {
        super.installListeners();
        if (JDK.HAS_BUG_TYPE_DOES_NOT_SCROLL_IN_JLIST) {
            this.keyListener = this.createKeyListener();
            this.list.addKeyListener(this.keyListener);
        }
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        if (JDK.HAS_BUG_TYPE_DOES_NOT_SCROLL_IN_JLIST) {
            this.list.removeKeyListener(this.keyListener);
            this.keyListener = null;
        }
    }

    private KeyListener createKeyListener() {
        return new KeyHandler();
    }

    public static final class KeyHandler
    extends KeyAdapter {
        public void keyTyped(KeyEvent keyEvent) {
            JList jList = (JList)keyEvent.getSource();
            ListModel listModel = jList.getModel();
            if (listModel.getSize() == 0 || keyEvent.isAltDown() || keyEvent.isControlDown() || keyEvent.isMetaDown()) {
                return;
            }
            int n = jList.getSelectedIndex();
            if (n >= 0) {
                jList.ensureIndexIsVisible(n);
            }
        }

        KeyHandler() {
        }
    }
}

