/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.plaf;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import oracle.ide.nulls.NullIcon;

final class WindowsMenuItemUIHelper {
    static final Icon BLANK_ICON = new NullIcon();
    PropertyChangeListener _propertyChangeListener;

    WindowsMenuItemUIHelper() {
    }

    void installDefaults(JMenuItem jMenuItem) {
        if (jMenuItem.getIcon() == null) {
            jMenuItem.setIcon(BLANK_ICON);
        }
        if (jMenuItem.getDisabledIcon() == null) {
            jMenuItem.setDisabledIcon(BLANK_ICON);
        }
        if (jMenuItem.getPressedIcon() == null) {
            jMenuItem.setPressedIcon(BLANK_ICON);
        }
    }

    void installListeners(JMenuItem jMenuItem) {
        this._propertyChangeListener = this.createPropertyChangeListener(jMenuItem);
        if (this._propertyChangeListener != null) {
            jMenuItem.addPropertyChangeListener(this._propertyChangeListener);
        }
    }

    void uninstallDefaults(JMenuItem jMenuItem) {
        if (jMenuItem.getIcon() == BLANK_ICON) {
            jMenuItem.setIcon(null);
        }
        if (jMenuItem.getDisabledIcon() == BLANK_ICON) {
            jMenuItem.setDisabledIcon(null);
        }
        if (jMenuItem.getPressedIcon() == BLANK_ICON) {
            jMenuItem.setPressedIcon(null);
        }
    }

    void uninstallListeners(JMenuItem jMenuItem) {
        if (this._propertyChangeListener != null) {
            jMenuItem.removePropertyChangeListener(this._propertyChangeListener);
            this._propertyChangeListener = null;
        }
    }

    PropertyChangeListener createPropertyChangeListener(JComponent jComponent) {
        return new PropertyChangeHandler();
    }

    static class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            JMenuItem jMenuItem = (JMenuItem)propertyChangeEvent.getSource();
            if (string.equals("icon")) {
                if (propertyChangeEvent.getNewValue() == null) {
                    jMenuItem.setIcon(BLANK_ICON);
                }
            } else if (string.equals("disabledIcon")) {
                if (propertyChangeEvent.getNewValue() == null) {
                    jMenuItem.setDisabledIcon(BLANK_ICON);
                }
            } else if (string.equals("pressedIcon") && propertyChangeEvent.getNewValue() == null) {
                jMenuItem.setPressedIcon(BLANK_ICON);
            }
        }

        PropertyChangeHandler() {
        }
    }
}

