/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.plaf;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import oracle.ide.util.JDK;
import oracle.ideimpl.plaf.DefaultTreeCellRendererFocusFix;
import oracle.ideimpl.plaf.TreeUIHelper;

public class WindowsTreeUI
extends BasicTreeUI {
    protected TreeUIHelper helper;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsTreeUI();
    }

    public void installUI(JComponent jComponent) {
        this.helper = new TreeUIHelper((JTree)jComponent);
        super.installUI(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.helper = null;
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        this.helper.installKeyboardActionsHook();
    }

    protected MouseListener createMouseListener() {
        return new MouseHandler(null);
    }

    protected TreeCellRenderer createDefaultCellRenderer() {
        if (JDK.HAS_BUG_4674205) {
            return new DefaultTreeCellRendererFocusFix();
        }
        return super.createDefaultCellRenderer();
    }

    protected void paintHorizontalLine(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
        this.drawDashedHorizontalLine(graphics, n, n2, n3);
    }

    protected void paintVerticalLine(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
        this.drawDashedVerticalLine(graphics, n, n2, n3);
    }

    protected void ensureRowsAreVisible(int n, int n2) {
        if (this.tree != null && n >= 0 && n2 < this.getRowCount(this.tree)) {
            Rectangle rectangle = this.tree.getVisibleRect();
            if (n == n2) {
                Rectangle rectangle2 = this.getPathBounds(this.tree, this.getPathForRow(this.tree, n));
                if (rectangle2 != null) {
                    rectangle2.x = rectangle.x;
                    rectangle2.width = rectangle.width;
                    this.tree.scrollRectToVisible(rectangle2);
                }
            } else {
                Rectangle rectangle3;
                Rectangle rectangle4 = rectangle3 = this.getPathBounds(this.tree, this.getPathForRow(this.tree, n));
                int n3 = rectangle3.y;
                int n4 = n3 + rectangle.height;
                int n5 = n + 1;
                while (n5 <= n2) {
                    rectangle4 = this.getPathBounds(this.tree, this.getPathForRow(this.tree, n5));
                    if (rectangle4.y + rectangle4.height > n4) {
                        n5 = n2;
                    }
                    ++n5;
                }
                this.tree.scrollRectToVisible(new Rectangle(rectangle.x, n3, 1, rectangle4.y + rectangle4.height - n3));
            }
        }
    }

    static JTree ra$tree(WindowsTreeUI windowsTreeUI) {
        return windowsTreeUI.tree;
    }

    static void mav$selectPathForEvent(WindowsTreeUI windowsTreeUI, TreePath treePath, MouseEvent mouseEvent) {
        windowsTreeUI.selectPathForEvent(treePath, mouseEvent);
    }

    static void mav$checkForClickInExpandControl(WindowsTreeUI windowsTreeUI, TreePath treePath, int n, int n2) {
        windowsTreeUI.checkForClickInExpandControl(treePath, n, n2);
    }

    static boolean mav$startEditing(WindowsTreeUI windowsTreeUI, TreePath treePath, MouseEvent mouseEvent) {
        return windowsTreeUI.startEditing(treePath, mouseEvent);
    }

    private final class MouseHandler
    extends MouseAdapter {
        private TreePath lastSelectedPath;

        void $init$() {
            this.lastSelectedPath = null;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (WindowsTreeUI.ra$tree(WindowsTreeUI.this) != null && WindowsTreeUI.ra$tree(WindowsTreeUI.this).isEnabled() && !mouseEvent.isConsumed()) {
                if (JDK.HAS_BUG_MENU_RESTORES_WRONG_FOCUS) {
                    MenuSelectionManager.defaultManager().clearSelectedPath();
                }
                WindowsTreeUI.ra$tree(WindowsTreeUI.this).requestFocus();
                TreePath treePath = WindowsTreeUI.this.getClosestPathForLocation(WindowsTreeUI.ra$tree(WindowsTreeUI.this), mouseEvent.getX(), mouseEvent.getY());
                if (treePath != null) {
                    int n;
                    Rectangle rectangle = WindowsTreeUI.this.getPathBounds(WindowsTreeUI.ra$tree(WindowsTreeUI.this), treePath);
                    if (mouseEvent.getY() > rectangle.y + rectangle.height) {
                        return;
                    }
                    if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        WindowsTreeUI.mav$checkForClickInExpandControl(WindowsTreeUI.this, treePath, mouseEvent.getX(), mouseEvent.getY());
                    }
                    if ((n = mouseEvent.getX()) > rectangle.x && n <= rectangle.x + rectangle.width && !WindowsTreeUI.mav$startEditing(WindowsTreeUI.this, treePath, mouseEvent)) {
                        if (WindowsTreeUI.ra$tree(WindowsTreeUI.this).isPathSelected(treePath)) {
                            this.lastSelectedPath = treePath;
                        } else {
                            this.lastSelectedPath = null;
                            WindowsTreeUI.mav$selectPathForEvent(WindowsTreeUI.this, treePath, mouseEvent);
                        }
                    }
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            TreePath treePath;
            if (WindowsTreeUI.ra$tree(WindowsTreeUI.this) != null && WindowsTreeUI.ra$tree(WindowsTreeUI.this).isEnabled() && !mouseEvent.isConsumed() && (treePath = WindowsTreeUI.this.getClosestPathForLocation(WindowsTreeUI.ra$tree(WindowsTreeUI.this), mouseEvent.getX(), mouseEvent.getY())) != null) {
                Rectangle rectangle = WindowsTreeUI.this.getPathBounds(WindowsTreeUI.ra$tree(WindowsTreeUI.this), treePath);
                if (mouseEvent.getY() > rectangle.y + rectangle.height) {
                    return;
                }
                int n = mouseEvent.getX();
                if (n > rectangle.x && n <= rectangle.x + rectangle.width && treePath.equals(this.lastSelectedPath)) {
                    WindowsTreeUI.mav$selectPathForEvent(WindowsTreeUI.this, treePath, mouseEvent);
                }
            }
            this.lastSelectedPath = null;
        }

        private MouseHandler() {
            this.$init$();
        }

        MouseHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

