/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.print;

import java.awt.Component;
import java.util.ArrayList;
import oracle.ide.print.DocumentPrintFactory;
import oracle.ide.print.PageableFactory;
import oracle.ide.util.ModelUtil;
import oracle.ideimpl.print.ComponentPageableFactory;

final class FactoryRegistry {
    private ArrayList _pageableFactories;
    private ArrayList _documentPrintFactories;
    public static int INSERT_START = 0;
    public static int INSERT_BEFORE = 1;
    public static int INSERT_AFTER = 2;
    private static int EXACT_MATCH = 1;
    private static int ASSIGNABLE_FROM_MATCH = 2;
    private static int RETURN_PAGEABLE_FACTORY_CLASS = 1;
    private static int RETURN_SOURCE_CLASS = 2;

    void $init$() {
        this._pageableFactories = new ArrayList(3);
        this._documentPrintFactories = new ArrayList(3);
    }

    FactoryRegistry() {
        this.$init$();
        this.registerPageableFactory(Component.class, ComponentPageableFactory.class);
    }

    public boolean registerPageableFactory(Class clazz, Class clazz2) {
        return this.registerPageableFactory(clazz, clazz2, clazz, INSERT_BEFORE);
    }

    public boolean registerPageableFactory(String string, String string2) {
        return this.registerPageableFactory(string, string2, string, INSERT_BEFORE);
    }

    public boolean registerPageableFactory(String string, String string2, String string3, int n) {
        Class<?> clazz = null;
        Class<?> clazz2 = null;
        Class<?> clazz3 = null;
        try {
            clazz = Class.forName(string);
            clazz2 = Class.forName(string2);
            boolean bl = false;
            Class<?>[] classArray = clazz2.getInterfaces();
            int n2 = 0;
            while (n2 < classArray.length) {
                if (classArray[n2] == PageableFactory.class) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                boolean bl2 = false;
                return bl2;
            }
            if (ModelUtil.hasLength((String)string3)) {
                clazz3 = Class.forName(string3);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            boolean bl = false;
            return bl;
        }
        return this.registerPageableFactory(clazz, clazz2, clazz3, n);
    }

    public boolean registerPageableFactory(Class clazz, Class clazz2, Class clazz3, int n) {
        if (this.findFactoryClassPairForClass(clazz, this._pageableFactories, EXACT_MATCH) == -1) {
            int n2 = INSERT_START;
            if (clazz3 != null && n != INSERT_START) {
                n2 = this.findFactoryClassPairForClass(clazz3, this._pageableFactories, ASSIGNABLE_FROM_MATCH);
                if (n != INSERT_BEFORE || n2 == -1) {
                    n2 = n == INSERT_AFTER && n2 != -1 ? ++n2 : this._pageableFactories.size();
                }
            }
            this.registerFactory(clazz, clazz2, this._pageableFactories, n2);
        }
        return true;
    }

    public void unregisterPageableFactory(String string) {
        this.unregisterFactory(string, this._pageableFactories);
    }

    public void unregisterPageableFactory(Class clazz) {
        this.unregisterFactory(clazz, this._pageableFactories);
    }

    public Class getPageableFactoryClassForClass(String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Class clazz2 = null;
            return clazz2;
        }
        return this.getClassForClass(clazz, this._pageableFactories, RETURN_PAGEABLE_FACTORY_CLASS);
    }

    public Class getPageableFactoryClassForClass(Class clazz) {
        return this.getClassForClass(clazz, this._pageableFactories, RETURN_PAGEABLE_FACTORY_CLASS);
    }

    public Class getRegisteredAssignableClass(String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Class clazz2 = null;
            return clazz2;
        }
        return this.getClassForClass(clazz, this._pageableFactories, RETURN_SOURCE_CLASS);
    }

    public Class getRegisteredAssignableClass(Class clazz) {
        return this.getClassForClass(clazz, this._pageableFactories, RETURN_SOURCE_CLASS);
    }

    public PageableFactory getPageableFactory(Object object) {
        int n = this.findFactoryClassPairForClass(object.getClass(), this._pageableFactories, ASSIGNABLE_FROM_MATCH);
        if (n != -1) {
            FactoryClassPair factoryClassPair = (FactoryClassPair)this._pageableFactories.get(n);
            try {
                PageableFactory pageableFactory;
                Class clazz = factoryClassPair.getFactoryClass();
                PageableFactory pageableFactory2 = pageableFactory = (PageableFactory)clazz.newInstance();
                return pageableFactory2;
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean registerDocumentPrintFactory(String string, String string2) {
        Class<?> clazz = null;
        Class<?> clazz2 = null;
        try {
            clazz = Class.forName(string);
            clazz2 = Class.forName(string2);
            if (clazz2.getSuperclass() != DocumentPrintFactory.class) {
                boolean bl = false;
                return bl;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            boolean bl = false;
            return bl;
        }
        return this.registerDocumentPrintFactory(clazz, clazz2);
    }

    public boolean registerDocumentPrintFactory(Class clazz, Class clazz2) {
        if (this.findFactoryClassPairForClass(clazz, this._documentPrintFactories, EXACT_MATCH) == -1) {
            this.registerFactory(clazz, clazz2, this._documentPrintFactories);
        }
        return true;
    }

    public void unregisterDocumentPrintFactory(String string) {
        this.unregisterFactory(string, this._documentPrintFactories);
    }

    public void unregisterDocumentPrintFactory(Class clazz) {
        this.unregisterFactory(clazz, this._documentPrintFactories);
    }

    public DocumentPrintFactory getDocumentPrintFactory(Class clazz) {
        int n = this.findFactoryClassPairForClass(clazz, this._documentPrintFactories, ASSIGNABLE_FROM_MATCH);
        if (n != -1) {
            FactoryClassPair factoryClassPair = (FactoryClassPair)this._documentPrintFactories.get(n);
            try {
                DocumentPrintFactory documentPrintFactory;
                Class clazz2 = factoryClassPair.getFactoryClass();
                DocumentPrintFactory documentPrintFactory2 = documentPrintFactory = (DocumentPrintFactory)clazz2.newInstance();
                return documentPrintFactory2;
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerFactory(Class clazz, Class clazz2, ArrayList arrayList, int n) {
        FactoryClassPair factoryClassPair = new FactoryClassPair(clazz, clazz2);
        if (n < 0) {
            n = 0;
        }
        if (n < arrayList.size()) {
            ArrayList arrayList2 = arrayList;
            synchronized (arrayList2) {
                arrayList.add(n, factoryClassPair);
            }
        }
        ArrayList arrayList3 = arrayList;
        synchronized (arrayList3) {
            arrayList.add(factoryClassPair);
        }
    }

    private void registerFactory(Class clazz, Class clazz2, ArrayList arrayList) {
        this.registerFactory(clazz, clazz2, arrayList, INSERT_START);
    }

    private void unregisterFactory(String string, ArrayList arrayList) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return;
        }
        this.unregisterFactory(clazz, arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterFactory(Class clazz, ArrayList arrayList) {
        int n = this.findFactoryClassPairForClass(clazz, arrayList, EXACT_MATCH);
        if (n != -1) {
            ArrayList arrayList2 = arrayList;
            synchronized (arrayList2) {
                arrayList.remove(n);
            }
        }
    }

    private int findFactoryClassPairForClass(Class clazz, ArrayList arrayList, int n) {
        int n2 = 0;
        while (n2 < arrayList.size()) {
            FactoryClassPair factoryClassPair = (FactoryClassPair)arrayList.get(n2);
            Class clazz2 = factoryClassPair.getSourceClass();
            if (n == EXACT_MATCH) {
                if (clazz2 == clazz) {
                    return n2;
                }
            } else if (n == ASSIGNABLE_FROM_MATCH) {
                if (clazz2.isAssignableFrom(clazz)) {
                    return n2;
                }
            } else {
                return -1;
            }
            ++n2;
        }
        return -1;
    }

    private Class getClassForClass(Class clazz, ArrayList arrayList, int n) {
        int n2 = this.findFactoryClassPairForClass(clazz, arrayList, ASSIGNABLE_FROM_MATCH);
        if (n2 == -1) {
            return null;
        }
        FactoryClassPair factoryClassPair = (FactoryClassPair)arrayList.get(n2);
        if (n == RETURN_PAGEABLE_FACTORY_CLASS) {
            return factoryClassPair.getFactoryClass();
        }
        if (n == RETURN_SOURCE_CLASS) {
            return factoryClassPair.getSourceClass();
        }
        return null;
    }

    public class FactoryClassPair {
        private Class _sourceClass;
        private Class _factoryClass;

        public FactoryClassPair(Class clazz, Class clazz2) {
            this._sourceClass = clazz;
            this._factoryClass = clazz2;
        }

        public Class getSourceClass() {
            return this._sourceClass;
        }

        public Class getFactoryClass() {
            return this._factoryClass;
        }
    }
}

