/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.print;

import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.WaitCursor;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.print.DocumentPrintFactory;
import oracle.ide.print.PageableFactory;
import oracle.ide.print.PrintManager;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.SwingWorker;
import oracle.ide.view.View;
import oracle.ideimpl.IdeMenus;
import oracle.ideimpl.print.FactoryRegistry;
import oracle.ideimpl.print.PrintThread;

public class PrintManagerImpl
extends PrintManager
implements Addin,
Controller {
    private PageFormat mPageFormat;
    private int mPrintThreadCount;
    private FactoryRegistry mFactoryRegistry;
    private PrinterJob mPrinterJob;
    private Printable mPrintable;
    private Pageable mPageable;
    private Pageable[] mPageables;
    private PrintRequestAttributeSet mPrintRequestAttributeSet;

    void $init$() {
        this.mPageFormat = new PageFormat();
        this.mPrintThreadCount = 0;
        this.mFactoryRegistry = new FactoryRegistry();
    }

    public PrintManagerImpl() {
        this.$init$();
        this.mFactoryRegistry.registerPageableFactory("oracle.ide.model.TextNode", "oracle.ide.ceditor.EditorPageableFactory");
    }

    public void initialize() {
        PrintManager.setPrintManager(this);
        Menubar menubar = Ide.getMenubar();
        JMenu jMenu = MenuManager.getJMenu("File");
        menubar.add(this.createPrinterSetupMenuItem(), jMenu, MenuConstants.SECTION_FILE_PRINT);
        menubar.add(this.createPrinterMenuItem(), jMenu, MenuConstants.SECTION_FILE_PRINT);
    }

    private JMenuItem createPrinterSetupMenuItem() {
        return IdeMenus.createMenuItem(this, 15, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(71), IdeMainWindow.ACTION_CATEGORY_FILE, IdeArb.getInteger(72), IdeArb.getInstance(), 73, null, true, MenuConstants.WEIGHT_FILE_PAGE_SETUP);
    }

    private JMenuItem createPrinterMenuItem() {
        return IdeMenus.createMenuItem(this, 16, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(74), IdeMainWindow.ACTION_CATEGORY_FILE, IdeArb.getInteger(75), IdeArb.getInstance(), 76, null, false, MenuConstants.WEIGHT_FILE_PRINT);
    }

    public void setPrintable(Printable printable, PageFormat pageFormat) {
        this.mPrintable = printable;
        this.mPageFormat = pageFormat;
    }

    public void setPageable(Pageable pageable) {
        this.mPageable = pageable;
    }

    public void setPageables(Pageable[] pageableArray) {
        this.mPageables = pageableArray;
    }

    public boolean registerDocumentPrintFactory(Class clazz, Class clazz2) {
        return this.mFactoryRegistry.registerDocumentPrintFactory(clazz, clazz2);
    }

    public void unregisterDocumentPrintFactory(Class clazz) {
        this.mFactoryRegistry.unregisterDocumentPrintFactory(clazz);
    }

    public Pageable createPageableForObject(Object object) {
        PageableFactory pageableFactory = this.mFactoryRegistry.getPageableFactory(object);
        if (pageableFactory != null) {
            Pageable pageable = pageableFactory.create(object, this.mPageFormat);
            pageableFactory = null;
            return pageable;
        }
        return null;
    }

    public PageFormat getPageFormat() {
        return this.mPageFormat;
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.mPageFormat = pageFormat;
    }

    void incrementPrintThread() {
        ++this.mPrintThreadCount;
    }

    void decrementPrintThread() {
        --this.mPrintThreadCount;
    }

    private void showPageDialog() {
        if (this.mPrinterJob == null) {
            this.mPrinterJob = PrinterJob.getPrinterJob();
        }
        if (this.mPrintRequestAttributeSet == null) {
            this.mPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        }
        this.mPageFormat = this.mPrinterJob.pageDialog(this.mPrintRequestAttributeSet);
    }

    private void print(Context context) {
        2 var2_2 = new 2(this, context);
        var2_2.start();
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == 16) {
            boolean bl = false;
            if (context == null) {
                bl = false;
            } else {
                DocumentPrintFactory documentPrintFactory = this.mFactoryRegistry.getDocumentPrintFactory(context.getView().getClass());
                if (documentPrintFactory == null) {
                    bl = false;
                } else if (documentPrintFactory.isPrintingEnabled(context)) {
                    bl = true;
                    documentPrintFactory = null;
                } else {
                    bl = false;
                }
            }
            ideAction.setEnabled(bl);
            return true;
        }
        if (n == 15) {
            ideAction.setEnabled(true);
            return true;
        }
        return false;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == 16) {
            this.print(context);
            return true;
        }
        if (n == 15) {
            WaitCursor waitCursor = Ide.getWaitCursor();
            1 var5_5 = new 1(this, waitCursor, context);
            var5_5.start();
            return true;
        }
        return false;
    }

    static PrinterJob ra$mPrinterJob(PrintManagerImpl printManagerImpl) {
        return printManagerImpl.mPrinterJob;
    }

    static void wa$mPrinterJob(PrintManagerImpl printManagerImpl, PrinterJob printerJob) {
        printManagerImpl.mPrinterJob = printerJob;
    }

    static void wa$mPrintable(PrintManagerImpl printManagerImpl, Printable printable) {
        printManagerImpl.mPrintable = printable;
    }

    static void wa$mPageable(PrintManagerImpl printManagerImpl, Pageable pageable) {
        printManagerImpl.mPageable = pageable;
    }

    static void wa$mPageables(PrintManagerImpl printManagerImpl, Pageable[] pageableArray) {
        printManagerImpl.mPageables = pageableArray;
    }

    static FactoryRegistry ra$mFactoryRegistry(PrintManagerImpl printManagerImpl) {
        return printManagerImpl.mFactoryRegistry;
    }

    static Printable ra$mPrintable(PrintManagerImpl printManagerImpl) {
        return printManagerImpl.mPrintable;
    }

    static Pageable ra$mPageable(PrintManagerImpl printManagerImpl) {
        return printManagerImpl.mPageable;
    }

    static Pageable[] ra$mPageables(PrintManagerImpl printManagerImpl) {
        return printManagerImpl.mPageables;
    }

    static PageFormat ra$mPageFormat(PrintManagerImpl printManagerImpl) {
        return printManagerImpl.mPageFormat;
    }

    static PrintRequestAttributeSet ra$mPrintRequestAttributeSet(PrintManagerImpl printManagerImpl) {
        return printManagerImpl.mPrintRequestAttributeSet;
    }

    static void wa$mPrintRequestAttributeSet(PrintManagerImpl printManagerImpl, PrintRequestAttributeSet printRequestAttributeSet) {
        printManagerImpl.mPrintRequestAttributeSet = printRequestAttributeSet;
    }

    static void mav$showPageDialog(PrintManagerImpl printManagerImpl) {
        printManagerImpl.showPageDialog();
    }

    public final class 2
    extends SwingWorker {
        private final /* synthetic */ Context v$context;
        final /* synthetic */ PrintManagerImpl this$0;

        public Object construct() {
            DocumentPrintFactory documentPrintFactory;
            if (PrintManagerImpl.ra$mPrinterJob(this.this$0) == null) {
                PrintManagerImpl.wa$mPrinterJob(this.this$0, PrinterJob.getPrinterJob());
            }
            PrintManagerImpl.wa$mPrintable(this.this$0, null);
            PrintManagerImpl.wa$mPageable(this.this$0, null);
            PrintManagerImpl.wa$mPageables(this.this$0, null);
            Node node = this.v$context.getNode();
            if (node != null) {
                PrintManagerImpl.ra$mPrinterJob(this.this$0).setJobName(URLFileSystem.getPlatformPathName(node.getURL()));
            }
            if ((documentPrintFactory = PrintManagerImpl.ra$mFactoryRegistry(this.this$0).getDocumentPrintFactory(this.v$context.getView().getClass())) == null) {
                return null;
            }
            documentPrintFactory.create(this.v$context);
            if (PrintManagerImpl.ra$mPrintable(this.this$0) != null || PrintManagerImpl.ra$mPageable(this.this$0) != null || PrintManagerImpl.ra$mPageables(this.this$0) != null) {
                if (PrintManagerImpl.ra$mPrintable(this.this$0) != null) {
                    PrintManagerImpl.ra$mPrinterJob(this.this$0).setPrintable(PrintManagerImpl.ra$mPrintable(this.this$0), PrintManagerImpl.ra$mPageFormat(this.this$0));
                } else if (PrintManagerImpl.ra$mPageable(this.this$0) != null) {
                    PrintManagerImpl.ra$mPrinterJob(this.this$0).setPageable(PrintManagerImpl.ra$mPageable(this.this$0));
                } else if (PrintManagerImpl.ra$mPageables(this.this$0) != null) {
                    PrintManagerImpl.ra$mPrinterJob(this.this$0).setPageable(PrintManagerImpl.ra$mPageables(this.this$0)[0]);
                }
            }
            if (PrintManagerImpl.ra$mPrintRequestAttributeSet(this.this$0) == null) {
                PrintManagerImpl.wa$mPrintRequestAttributeSet(this.this$0, new HashPrintRequestAttributeSet());
            }
            if (PrintManagerImpl.ra$mPrinterJob(this.this$0).printDialog(PrintManagerImpl.ra$mPrintRequestAttributeSet(this.this$0))) {
                int n = PrintManagerImpl.ra$mPageFormat(this.this$0).getOrientation();
                OrientationRequested orientationRequested = (OrientationRequested)PrintManagerImpl.ra$mPrintRequestAttributeSet(this.this$0).get(OrientationRequested.class);
                if (orientationRequested != null) {
                    if (orientationRequested == OrientationRequested.LANDSCAPE && n != 0) {
                        PrintManagerImpl.ra$mPageFormat(this.this$0).setOrientation(0);
                        documentPrintFactory.create(this.v$context);
                    } else if ((orientationRequested == OrientationRequested.PORTRAIT || orientationRequested == OrientationRequested.REVERSE_PORTRAIT) && n != 1) {
                        PrintManagerImpl.ra$mPageFormat(this.this$0).setOrientation(1);
                        documentPrintFactory.create(this.v$context);
                    } else if (orientationRequested == OrientationRequested.REVERSE_LANDSCAPE && n != 2) {
                        PrintManagerImpl.ra$mPageFormat(this.this$0).setOrientation(2);
                        documentPrintFactory.create(this.v$context);
                    }
                }
                if (PrintManagerImpl.ra$mPrintable(this.this$0) != null || PrintManagerImpl.ra$mPageable(this.this$0) != null || PrintManagerImpl.ra$mPageables(this.this$0) != null) {
                    Thread thread = null;
                    if (PrintManagerImpl.ra$mPrintable(this.this$0) != null) {
                        thread = new PrintThread(PrintManagerImpl.ra$mPrintable(this.this$0), PrintManagerImpl.ra$mPrinterJob(this.this$0), PrintManagerImpl.ra$mPrintRequestAttributeSet(this.this$0));
                    } else if (PrintManagerImpl.ra$mPageable(this.this$0) != null) {
                        thread = new PrintThread(PrintManagerImpl.ra$mPageable(this.this$0), PrintManagerImpl.ra$mPrinterJob(this.this$0), PrintManagerImpl.ra$mPrintRequestAttributeSet(this.this$0));
                    } else if (PrintManagerImpl.ra$mPageables(this.this$0) != null) {
                        thread = new PrintThread(PrintManagerImpl.ra$mPageables(this.this$0), PrintManagerImpl.ra$mPrinterJob(this.this$0), PrintManagerImpl.ra$mPrintRequestAttributeSet(this.this$0));
                    }
                    thread.setPriority(thread.getPriority() - 1);
                    thread.start();
                }
            } else {
                PrintManagerImpl.wa$mPrintable(this.this$0, null);
                PrintManagerImpl.wa$mPageable(this.this$0, null);
                PrintManagerImpl.wa$mPageables(this.this$0, null);
            }
            return null;
        }

        public void finished() {
            View view = this.v$context.getView();
            if (view != null) {
                view.getGUI().requestFocusInWindow();
            }
        }

        public 2(PrintManagerImpl printManagerImpl, Context context) {
            this.v$context = context;
            this.this$0 = printManagerImpl;
        }
    }

    public final class 1
    extends SwingWorker {
        private final /* synthetic */ WaitCursor v$wc;
        private final /* synthetic */ Context v$context;
        final /* synthetic */ PrintManagerImpl this$0;

        public Object construct() {
            this.v$wc.show(400L);
            PrintManagerImpl.mav$showPageDialog(this.this$0);
            return this;
        }

        public void finished() {
            View view;
            this.v$wc.hide();
            if (this.v$context != null && (view = this.v$context.getView()) != null) {
                view.getGUI().requestFocusInWindow();
            }
        }

        public 1(PrintManagerImpl printManagerImpl, WaitCursor waitCursor, Context context) {
            this.v$context = context;
            this.v$wc = waitCursor;
            this.this$0 = printManagerImpl;
        }
    }
}

