/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.replace;

import java.awt.Component;
import java.net.URL;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.swing.JMenu;
import javax.swing.JSeparator;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.net.URLFileSystem;
import oracle.ide.replace.ReplaceMenuManager;
import oracle.ideimpl.resource.IdeImplArb;
import oracle.javatools.dialogs.ExceptionDialog;

public final class ReplaceMenuAddin
extends ReplaceMenuManager
implements MenuListener,
ContextMenuListener,
Addin {
    private JMenu _mainReplaceMenu;
    private JMenu _contextReplaceMenu;

    public void initialize() {
        NavigatorManager.getWorkspaceNavigatorManager().getContextMenu().addContextMenuListener(this);
        EditorManager.getEditorManager().getContextMenu().addContextMenuListener(this);
        MenuManager.getJMenu("File").addMenuListener(this);
        try {
            InitialContext initialContext = new InitialContext();
            initialContext.bind("ide/replacemenus", (Object)this);
        }
        catch (NamingException namingException) {
            ExceptionDialog.showExceptionDialog(null, (Exception)namingException);
        }
        IdeAction ideAction = IdeActions.getFileRevertAction();
        Ide.getMenubar().add(Ide.getMenubar().createMenuItem(ideAction, 1.0f), this.getMainReplaceMenu(), 3.0f);
        Ide.getMenubar().add(Ide.getMenubar().createMenuItem(ideAction, 1.0f), this.getContextReplaceMenu(), 3.0f);
    }

    public boolean canShutdown() {
        return true;
    }

    public void shutdown() {
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        Element[] elementArray = context.getSelection();
        if (context != null && elementArray.length > 0) {
            JMenu jMenu = this.getContextReplaceMenu();
            this.removeLeadingSeparator(jMenu);
            if (jMenu.getItemCount() > 0) {
                boolean bl = false;
                int n = 0;
                while (n < elementArray.length && !bl) {
                    URL uRL;
                    if (elementArray[n] instanceof Locatable && (uRL = ((Locatable)((Object)elementArray[n])).getURL()) != null && !URLFileSystem.isDirectoryPath(uRL) && URLFileSystem.exists(uRL)) {
                        bl = true;
                    }
                    ++n;
                }
                if (bl) {
                    contextMenu.add((Component)jMenu, MenuConstants.SECTION_ADDITIONAL_CTXT_MENU);
                }
            }
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void menuSelected(MenuEvent menuEvent) {
        if (menuEvent.getSource() == MenuManager.getJMenu("File")) {
            Ide.getMenubar().add(this.getMainReplaceMenu(), MenuManager.getJMenu("File"), MenuConstants.SECTION_FILE_ADDINS);
            this.removeLeadingSeparator(this.getMainReplaceMenu());
        }
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public JMenu getMainReplaceMenu() {
        if (this._mainReplaceMenu == null) {
            this._mainReplaceMenu = Ide.getMenubar().createSubMenu(StringUtils.stripMnemonic((String)IdeImplArb.getString(98)), new Integer(StringUtils.getMnemonicKeyCode((String)IdeImplArb.getString(98))));
        }
        return this._mainReplaceMenu;
    }

    public JMenu getContextReplaceMenu() {
        if (this._contextReplaceMenu == null) {
            this._contextReplaceMenu = Ide.getMenubar().createSubMenu(StringUtils.stripMnemonic((String)IdeImplArb.getString(98)), new Integer(StringUtils.getMnemonicKeyCode((String)IdeImplArb.getString(98))), 5.0f);
        }
        return this._contextReplaceMenu;
    }

    private void removeLeadingSeparator(JMenu jMenu) {
        Component[] componentArray = jMenu.getMenuComponents();
        if (componentArray != null && componentArray.length > 0 && componentArray[0] instanceof JSeparator) {
            jMenu.remove(0);
        }
    }
}

