/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.runner;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import oracle.ide.model.Element;
import oracle.ide.runner.RunProcess;
import oracle.ideimpl.resource.RunMgrArb;
import oracle.ideimpl.runner.BaseRunnerFolder;
import oracle.ideimpl.runner.RunManager;

final class Processes
extends BaseRunnerFolder {
    private RunManager runManager;
    private boolean calledViewRunManager;

    Processes(RunManager runManager) {
        this.runManager = runManager;
        this.calledViewRunManager = false;
    }

    public String getShortLabel() {
        return RunMgrArb.getString(7);
    }

    public Icon getIcon() {
        return RunMgrArb.getIcon(8);
    }

    public boolean add(Element element) {
        boolean bl = super.add(element);
        if (bl) {
            if (element instanceof RunProcess) {
                RunManager.runner.selectProcess((RunProcess)element);
            }
            if (!this.calledViewRunManager && this.countChildren() > 1) {
                RunManager.runner.viewRunManager();
                this.calledViewRunManager = true;
            }
        }
        return bl;
    }

    public boolean remove(Element element) {
        int n;
        List list;
        RunProcess runProcess;
        if (element instanceof RunProcess && this.runManager.isActiveRunProcess(runProcess = (RunProcess)element) && (list = this.getRunProcessesList()).size() > 1 && (n = list.indexOf(runProcess)) != -1) {
            n = n == 0 ? 1 : --n;
            RunProcess runProcess2 = (RunProcess)list.get(n);
            RunManager.runner.selectProcess(runProcess2);
        }
        return super.remove(element);
    }

    private List getRunProcessesList() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.getChildren();
        if (iterator != null) {
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof RunProcess)) continue;
                arrayList.add(e);
            }
        }
        return arrayList;
    }

    public RunProcess[] getRunProcesses() {
        List list = this.getRunProcessesList();
        return list.toArray(new RunProcess[list.size()]);
    }
}

