/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.runner;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.IdeMainWindow;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.DockUtil;
import oracle.ide.docking.Dockable;
import oracle.ide.exception.SingletonClassException;
import oracle.ide.layout.IdeLayout;
import oracle.ide.layout.Layouts;
import oracle.ide.log.LogPage;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.navigator.NavigatorConstants;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.panels.Navigable;
import oracle.ide.resource.IdeArb;
import oracle.ide.runner.AbstractStarterFactory;
import oracle.ide.runner.Debugger;
import oracle.ide.runner.RunLogPage;
import oracle.ide.runner.RunProcess;
import oracle.ide.runner.Runner;
import oracle.ide.runner.StarterFactory;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;
import oracle.ideimpl.resource.RunMgrArb;
import oracle.ideimpl.runner.BaseRunnerFolder;
import oracle.ideimpl.runner.DebuggerHook;
import oracle.ideimpl.runner.Processes;
import oracle.ideimpl.runner.RunManagerDockableFactory;
import oracle.ideimpl.runner.RunManagerWindow;
import oracle.ideimpl.runner.StarterFactoryWrapper;
import oracle.ideri.util.Product;

public final class RunManager
extends BaseRunnerFolder
implements ViewSelectionListener,
Controller,
ContextMenuListener,
MenuListener,
IdeListener,
ShutdownHook,
Addin,
ActiveViewListener {
    private static RunManager instance;
    static Runner runner;
    private static Map registeredStarterFactories;
    private static List runConfigurationLaunchNavigables;
    private static List runConfigurationToolNavigables;
    private static Map currentTerminateActions;
    private static int countTerminateCommands;
    private static RunManagerWindow runManagerWindow;
    private static Processes processes;
    private static RunProcess activeRunProcess;
    private static IdeAction actionViewRunManager;
    private static JMenu runMenu;
    private static JMenu terminateSubMenu;
    private static JMenuItem emptyItem;
    private static final int VIEW_RUN_MANAGER_CMD_ID;
    private static final String RUN_TERMINATE_CMD_PREFIX = "RunTerminateCommand";
    private static IdeAction actionNavigatorTerminate;
    private static final int NAVIGATOR_TERMINATE_CMD_ID;
    private static final boolean testSimpleProcessExec = false;

    static {
        VIEW_RUN_MANAGER_CMD_ID = Ide.findOrCreateCmdID("ViewRunManager");
        NAVIGATOR_TERMINATE_CMD_ID = Ide.findOrCreateCmdID("TerminateCommand");
    }

    public RunManager() throws SingletonClassException {
        if (instance != null) {
            throw new SingletonClassException("oracle.ide.runner.RunManager");
        }
        instance = this;
    }

    public String getShortLabel() {
        return RunMgrArb.getString(6);
    }

    public void initialize() {
        registeredStarterFactories = new HashMap();
        runConfigurationLaunchNavigables = new ArrayList();
        runConfigurationToolNavigables = new ArrayList();
        runner = new RunnerImpl(null);
        Runner.setRunner(runner);
        new RunManagerDockableFactory();
        this.createActions();
        this.createRunMenus();
        Ide.addIdeListener(this);
        ExitCommand.addShutdownHook(this);
    }

    public void shutdown() {
        runner.terminate(null, true);
    }

    public boolean canShutdown() {
        return !runner.isRunning(null) || runner.terminate(null, false);
    }

    public void addinsLoaded(IdeEvent ideEvent) {
    }

    public void mainWindowOpened(IdeEvent ideEvent) {
        Ide.removeIdeListener(this);
        Ide.getMainWindow().addActiveViewListener(this);
        NavigatorManager.getWorkspaceNavigatorManager().addContextMenuListener(this, null);
        DebuggerHook debuggerHook = (DebuggerHook)ExtensionRegistry.getOracleRegistry().getIdeHook(DebuggerHook.ELEMENT);
        List list = debuggerHook.getExpressions();
        for (DebuggerHook.ObjectPreferencesExpression objectPreferencesExpression : list) {
            Debugger.getDebugger().addObjectPreferencesExpression(objectPreferencesExpression.getClassName(), objectPreferencesExpression.getExpression(), objectPreferencesExpression.isSelected());
        }
        debuggerHook.dispose();
    }

    public void mainWindowClosing(IdeEvent ideEvent) {
        Ide.getMainWindow().removeActiveViewListener(this);
        NavigatorManager.getWorkspaceNavigatorManager().removeContextMenuListener(this);
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuSelected(MenuEvent menuEvent) {
        JMenu jMenu;
        Object object = menuEvent.getSource();
        if (object == (jMenu = MenuManager.getJMenu("View"))) {
            jMenu.removeMenuListener(this);
            Menubar menubar = Ide.getMenubar();
            JMenuItem jMenuItem = menubar.createMenuItem(actionViewRunManager, MenuConstants.WEIGHT_VIEW_RUN_MANAGER);
            menubar.add(jMenuItem, jMenu, MenuConstants.SECTION_VIEW_DEBUG_RUN);
        }
    }

    public void activeViewChanged(ActiveViewEvent activeViewEvent) {
        RunProcess runProcess;
        View view = Ide.getMainWindow().getLastActiveView();
        if (view instanceof RunLogPage && (runProcess = ((RunLogPage)view).getRunProcess()) != null) {
            runner.selectProcess(runProcess);
        }
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        try {
            if (context != null && context.getView() instanceof RunManagerWindow) {
                contextMenu.remove(NavigatorConstants.New);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update(actionNavigatorTerminate, context);
        if (actionNavigatorTerminate.isEnabled()) {
            JMenuItem jMenuItem = contextMenu.createMenuItem(actionNavigatorTerminate);
            contextMenu.add(jMenuItem);
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        Element element;
        Element[] elementArray;
        if (context != null && (elementArray = context.getSelection()) != null && elementArray.length > 0 && (element = elementArray[elementArray.length - 1]) instanceof RunProcess) {
            RunProcess runProcess = (RunProcess)element;
            runProcess.doubleClicked();
            return true;
        }
        return false;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        RunProcess runProcess;
        int n = ideAction.getCommandId();
        if (n == VIEW_RUN_MANAGER_CMD_ID) {
            runner.viewRunManager();
            return true;
        }
        if (n == NAVIGATOR_TERMINATE_CMD_ID) {
            Element[] elementArray = context.getSelection();
            if (elementArray != null) {
                int n2 = elementArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    Element element = elementArray[n3];
                    if (element instanceof RunProcess) {
                        RunProcess runProcess2 = (RunProcess)element;
                        runProcess2.terminate();
                    }
                    ++n3;
                }
            }
            return true;
        }
        if (currentTerminateActions != null && (runProcess = (RunProcess)currentTerminateActions.get(ideAction)) != null) {
            runProcess.terminate();
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        RunProcess runProcess;
        int n = ideAction.getCommandId();
        if (n == VIEW_RUN_MANAGER_CMD_ID) {
            return true;
        }
        if (n == NAVIGATOR_TERMINATE_CMD_ID) {
            int n2;
            boolean bl = false;
            Element[] elementArray = context.getSelection();
            if (elementArray != null && (n2 = elementArray.length) > 0) {
                int n3 = 0;
                int n4 = 0;
                while (n4 < n2) {
                    RunProcess runProcess2;
                    Element element = elementArray[n4];
                    if (element instanceof RunProcess && (runProcess2 = (RunProcess)element).canTerminate()) {
                        ++n3;
                    }
                    ++n4;
                }
                if (n3 == n2) {
                    bl = true;
                }
            }
            ideAction.setEnabled(bl);
            return true;
        }
        if (currentTerminateActions != null && (runProcess = (RunProcess)currentTerminateActions.get(ideAction)) != null) {
            ideAction.setEnabled(true);
            return true;
        }
        return false;
    }

    public void viewSelectionChanged(ViewSelectionEvent viewSelectionEvent) {
        Element element;
        Element[] elementArray;
        RunProcess runProcess = null;
        Context context = runner.getRunManagerWindow().getContext();
        if (context != null && (elementArray = context.getSelection()) != null && elementArray.length > 0 && (element = elementArray[elementArray.length - 1]) instanceof RunProcess) {
            runProcess = (RunProcess)element;
        }
        RunProcess runProcess2 = activeRunProcess;
        if (activeRunProcess != null) {
            activeRunProcess.unselected();
            activeRunProcess = null;
        }
        if (runProcess != null) {
            LogPage logPage;
            if ((runProcess2 == null || !runProcess2.hasFinished()) && (logPage = runProcess.getLogPage()) instanceof RunLogPage) {
                RunLogPage runLogPage = (RunLogPage)logPage;
                runLogPage.showPage();
            }
            activeRunProcess = runProcess;
            activeRunProcess.selected();
        }
        View view = Ide.getMainWindow().getLastActiveView();
        Dockable dockable = null;
        View view2 = view;
        while (view2 != null) {
            if (view2 instanceof Dockable) {
                dockable = (Dockable)((Object)view2);
                break;
            }
            view2 = view2.owner();
        }
        Layouts layouts = Layouts.getLayouts();
        IdeLayout ideLayout = null;
        if (activeRunProcess != null) {
            ideLayout = activeRunProcess.getProcessLayout();
            if (ideLayout == null) {
                ideLayout = layouts.getDesignLayout();
            }
        } else if (processes.countChildren() == 0) {
            ideLayout = layouts.getDesignLayout();
        }
        if (ideLayout != null && !ideLayout.equals(layouts.getActiveLayout())) {
            layouts.activateLayout(ideLayout);
        }
        if ((view instanceof RunManagerWindow || view instanceof LogPage) && !view.isVisible() && dockable != null) {
            DockStation.getDockStation().setDockableVisible(dockable, true);
        }
    }

    private void createActions() {
        String string = IdeMainWindow.ACTION_CATEGORY_VIEW;
        actionViewRunManager = IdeAction.get(VIEW_RUN_MANAGER_CMD_ID, null, RunMgrArb.getString(2), string, RunMgrArb.getInteger(3), RunMgrArb.getInstance(), 4, null, true);
        actionViewRunManager.addController(this);
        JMenu jMenu = MenuManager.getJMenu("View");
        jMenu.addMenuListener(this);
        actionNavigatorTerminate = IdeAction.get(NAVIGATOR_TERMINATE_CMD_ID, null, IdeArb.getString(148), null, IdeArb.getInteger(149), IdeArb.getInstance(), 150, null, true);
        actionNavigatorTerminate.addController(this);
    }

    private void createRunMenus() {
        Menubar menubar = Ide.getMenubar();
        runMenu = MenuManager.getJMenu("Run");
        menubar.add(runMenu);
        terminateSubMenu = menubar.createSubMenu(IdeArb.getString(148), IdeArb.getInteger(149), MenuConstants.WEIGHT_RUN_TERMINATE);
        emptyItem = new JMenuItem(IdeArb.getString(233));
        emptyItem.setEnabled(false);
        terminateSubMenu.add(emptyItem);
        terminateSubMenu.setEnabled(false);
        if (!Product.isRaptor()) {
            menubar.add(terminateSubMenu, runMenu, MenuConstants.SECTION_RUN_TERMINATE);
        }
    }

    boolean isActiveRunProcess(RunProcess runProcess) {
        return runProcess.equals(activeRunProcess);
    }

    static List ra$runConfigurationToolNavigables() {
        return runConfigurationToolNavigables;
    }

    static List ra$runConfigurationLaunchNavigables() {
        return runConfigurationLaunchNavigables;
    }

    static Map ra$registeredStarterFactories() {
        return registeredStarterFactories;
    }

    static Map ra$currentTerminateActions() {
        return currentTerminateActions;
    }

    static JMenu ra$terminateSubMenu() {
        return terminateSubMenu;
    }

    static JMenuItem ra$emptyItem() {
        return emptyItem;
    }

    static void wa$currentTerminateActions(Map map) {
        currentTerminateActions = map;
    }

    static int ra$countTerminateCommands() {
        return countTerminateCommands;
    }

    static void wa$countTerminateCommands(int n) {
        countTerminateCommands = n;
    }

    static IdeAction ra$actionViewRunManager() {
        return actionViewRunManager;
    }

    static RunManagerWindow ra$runManagerWindow() {
        return runManagerWindow;
    }

    static Processes ra$processes() {
        return processes;
    }

    static void wa$processes(Processes processes) {
        RunManager.processes = processes;
    }

    static void wa$runManagerWindow(RunManagerWindow runManagerWindow) {
        RunManager.runManagerWindow = runManagerWindow;
    }

    static JMenu ra$runMenu() {
        return runMenu;
    }

    private class RunnerImpl
    extends Runner {
        public boolean isRunning(Project project) {
            if (RunManager.ra$processes() != null) {
                RunProcess[] runProcessArray = RunManager.ra$processes().getRunProcesses();
                int n = runProcessArray.length;
                int n2 = 0;
                while (n2 < n) {
                    RunProcess runProcess = runProcessArray[n2];
                    if (project == null || project == runProcess.getProject()) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }

        public boolean terminate(Project project, boolean bl) {
            if (RunManager.ra$processes() != null) {
                ArrayList<RunProcess> arrayList = new ArrayList<RunProcess>();
                RunProcess[] runProcessArray = RunManager.ra$processes().getRunProcesses();
                int n = runProcessArray.length;
                int n2 = 0;
                while (n2 < n) {
                    RunProcess runProcess = runProcessArray[n2];
                    if (project == null || project == runProcess.getProject()) {
                        arrayList.add(runProcess);
                    }
                    ++n2;
                }
                n = arrayList.size();
                if (n > 0) {
                    boolean bl2;
                    if (bl) {
                        bl2 = true;
                    } else {
                        String string;
                        Object[] objectArray = new Object[1 + n];
                        int n3 = 0;
                        if (n == 1) {
                            objectArray[n3++] = RunMgrArb.getString(11);
                            string = RunMgrArb.getString(9);
                        } else {
                            objectArray[n3++] = RunMgrArb.getString(12);
                            string = RunMgrArb.getString(10);
                        }
                        for (RunProcess runProcess : arrayList) {
                            JLabel jLabel = new JLabel(runProcess.getShortLabel(), runProcess.getIcon(), 2);
                            objectArray[n3++] = jLabel;
                        }
                        int n4 = JOptionPane.showConfirmDialog((Component)((Object)Ide.getMainWindow()), objectArray, string, 0, 3);
                        boolean bl3 = bl2 = n4 == 0;
                    }
                    if (bl2) {
                        for (RunProcess runProcess : arrayList) {
                            runProcess.terminate();
                        }
                        Layouts layouts = Layouts.getLayouts();
                        layouts.activateLayout(layouts.getDesignLayout());
                    } else {
                        return false;
                    }
                }
            }
            return true;
        }

        public JMenu getRunMenu() {
            return RunManager.ra$runMenu();
        }

        public synchronized NavigatorWindow getRunManagerWindow() {
            if (RunManager.ra$runManagerWindow() == null) {
                Context context = Context.newIdeContext(RunManager.this);
                context.setProject(null);
                context.setWorkspace(null);
                RunManager.wa$runManagerWindow(new RunManagerWindow(context, RunManager.this));
                RunManager.ra$runManagerWindow().setToolbarVisible(true);
                RunManager.ra$runManagerWindow().addViewSelectionListener(RunManager.this);
                this.getProcessesFolder();
            }
            return RunManager.ra$runManagerWindow();
        }

        public Folder getRunManagerFolder() {
            this.getRunManagerWindow();
            return RunManager.this;
        }

        public synchronized Folder getProcessesFolder() {
            if (RunManager.ra$processes() == null) {
                try {
                    RunManager.wa$processes(new Processes(RunManager.this));
                    this.getRunManagerFolder().add(RunManager.ra$processes());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return RunManager.ra$processes();
        }

        public void viewRunManager() {
            DockUtil.showDockableWindow(this.getRunManagerWindow());
        }

        public boolean isRunManagerVisible() {
            if (RunManager.ra$runManagerWindow() == null) {
                return false;
            }
            return RunManager.ra$runManagerWindow().isVisible();
        }

        public IdeAction getViewRunManagerAction() {
            return RunManager.ra$actionViewRunManager();
        }

        public boolean selectProcess(RunProcess runProcess) {
            return ((RunManagerWindow)this.getRunManagerWindow()).selectProcess(runProcess);
        }

        public void addTerminateMenu(RunProcess runProcess) {
            if (RunManager.ra$currentTerminateActions() == null) {
                RunManager.wa$currentTerminateActions(new HashMap(10));
            }
            RunManager.wa$countTerminateCommands(RunManager.ra$countTerminateCommands() + 1);
            int n = Ide.findOrCreateCmdID(RunManager.RUN_TERMINATE_CMD_PREFIX + RunManager.ra$countTerminateCommands());
            IdeAction ideAction = IdeAction.get(n, null, runProcess.getShortLabel(), null, null, runProcess.getIcon(), null, true);
            ideAction.addController(RunManager.this);
            RunManager.ra$currentTerminateActions().put(ideAction, runProcess);
            if (RunManager.ra$terminateSubMenu().getItem(0) == RunManager.ra$emptyItem()) {
                RunManager.ra$terminateSubMenu().remove(0);
            }
            RunManager.ra$terminateSubMenu().setEnabled(true);
            JMenuItem jMenuItem = Ide.getMenubar().createMenuItem(ideAction);
            RunManager.ra$terminateSubMenu().add(jMenuItem);
            ideAction.putValue("UserData", jMenuItem);
        }

        public void removeTerminateMenu(RunProcess runProcess) {
            for (IdeAction ideAction : RunManager.ra$currentTerminateActions().keySet()) {
                if (!RunManager.ra$currentTerminateActions().get(ideAction).equals(runProcess)) continue;
                RunManager.ra$currentTerminateActions().remove(ideAction);
                JMenuItem jMenuItem = (JMenuItem)ideAction.getValue("UserData");
                RunManager.ra$terminateSubMenu().remove(jMenuItem);
                jMenuItem.setAction(null);
                ideAction.putValue("UserData", null);
                ideAction.removeController(RunManager.this);
                IdeAction.remove(ideAction.getCommandId());
                if (RunManager.ra$terminateSubMenu().getItemCount() != 0) break;
                RunManager.ra$terminateSubMenu().add(RunManager.ra$emptyItem());
                RunManager.ra$terminateSubMenu().setEnabled(false);
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registerStarterFactory(Class clazz, StarterFactory starterFactory) {
            if (!(starterFactory instanceof AbstractStarterFactory)) {
                starterFactory = new StarterFactoryWrapper(starterFactory);
            }
            if (((AbstractStarterFactory)starterFactory).canBeRegistered()) {
                Map map = RunManager.ra$registeredStarterFactories();
                synchronized (map) {
                    ArrayList<StarterFactory> arrayList = (ArrayList<StarterFactory>)RunManager.ra$registeredStarterFactories().get(clazz);
                    if (arrayList == null) {
                        arrayList = new ArrayList<StarterFactory>();
                        RunManager.ra$registeredStarterFactories().put(clazz, arrayList);
                    }
                    arrayList.add(0, starterFactory);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregisterStarterFactory(Class clazz, StarterFactory starterFactory) {
            Map map = RunManager.ra$registeredStarterFactories();
            synchronized (map) {
                List list = (List)RunManager.ra$registeredStarterFactories().get(clazz);
                if (list != null) {
                    if (!list.remove(starterFactory)) {
                        for (Object e : list) {
                            if (!(e instanceof StarterFactoryWrapper) || !((StarterFactoryWrapper)e).getStarterFactory().equals(starterFactory)) continue;
                            list.remove(e);
                            break;
                        }
                    }
                    if (list.isEmpty()) {
                        RunManager.ra$registeredStarterFactories().remove(clazz);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Class[] getClassesWithRegisteredStarterFactory() {
            Map map = RunManager.ra$registeredStarterFactories();
            synchronized (map) {
                Class[] classArray = RunManager.ra$registeredStarterFactories().keySet().toArray(new Class[RunManager.ra$registeredStarterFactories().size()]);
                return classArray;
            }
        }

        public AbstractStarterFactory[] getRegisteredStarterFactories(Class clazz) {
            return this.getRegisteredStarterFactories(clazz, null);
        }

        private boolean checkStarterFactorySubClass(Class clazz, Object object) {
            if (clazz == null) {
                return true;
            }
            if (clazz.isAssignableFrom(object.getClass())) {
                return true;
            }
            if (object instanceof StarterFactoryWrapper) {
                return this.checkStarterFactorySubClass(clazz, ((StarterFactoryWrapper)object).getStarterFactory());
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AbstractStarterFactory[] getRegisteredStarterFactories(Class clazz, Class clazz2) {
            Map map = RunManager.ra$registeredStarterFactories();
            synchronized (map) {
                ArrayList arrayList = new ArrayList();
                List list = (List)RunManager.ra$registeredStarterFactories().get(clazz);
                for (Object e : list) {
                    if (!this.checkStarterFactorySubClass(clazz2, e)) continue;
                    arrayList.add(e);
                }
                AbstractStarterFactory[] abstractStarterFactoryArray = arrayList.toArray(new AbstractStarterFactory[arrayList.size()]);
                return abstractStarterFactoryArray;
            }
        }

        public AbstractStarterFactory[] getStarterFactoriesForTarget(Class clazz) {
            return this.getStarterFactoriesForTarget(clazz, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AbstractStarterFactory[] getStarterFactoriesForTarget(Class clazz, Class clazz2) {
            Map map = RunManager.ra$registeredStarterFactories();
            synchronized (map) {
                ArrayList arrayList = new ArrayList();
                for (Class clazz3 : RunManager.ra$registeredStarterFactories().keySet()) {
                    if (!clazz3.isAssignableFrom(clazz)) continue;
                    List list = (List)RunManager.ra$registeredStarterFactories().get(clazz3);
                    for (Object e : list) {
                        if (!this.checkStarterFactorySubClass(clazz2, e)) continue;
                        arrayList.add(e);
                    }
                }
                AbstractStarterFactory[] abstractStarterFactoryArray = arrayList.toArray(new AbstractStarterFactory[arrayList.size()]);
                return abstractStarterFactoryArray;
            }
        }

        public boolean couldNodeBeRunnable(Node node) {
            return this.couldNodeBeRunnable(node, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean couldNodeBeRunnable(Node node, Class clazz) {
            if (node != null) {
                Class<?> clazz2 = node.getClass();
                Map map = RunManager.ra$registeredStarterFactories();
                synchronized (map) {
                    for (Class clazz3 : RunManager.ra$registeredStarterFactories().keySet()) {
                        if (!clazz3.isAssignableFrom(clazz2)) continue;
                        List list = (List)RunManager.ra$registeredStarterFactories().get(clazz3);
                        for (Object e : list) {
                            if (!this.checkStarterFactorySubClass(clazz, e)) continue;
                            boolean bl = true;
                            return bl;
                        }
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean enableRunDebugActions(Context context, Class clazz) {
            Node node = RunProcess.getContextNodeForRun(context);
            if (node != null) {
                if (node instanceof Project && node == context.getProject()) {
                    return true;
                }
                Class<?> clazz2 = node.getClass();
                Map map = RunManager.ra$registeredStarterFactories();
                synchronized (map) {
                    for (Class clazz3 : RunManager.ra$registeredStarterFactories().keySet()) {
                        if (!clazz3.isAssignableFrom(clazz2)) continue;
                        List list = (List)RunManager.ra$registeredStarterFactories().get(clazz3);
                        for (Object e : list) {
                            AbstractStarterFactory abstractStarterFactory;
                            if (!this.checkStarterFactorySubClass(clazz, e) || !(abstractStarterFactory = (AbstractStarterFactory)e).enableRunDebugActions(context)) continue;
                            boolean bl = true;
                            return bl;
                        }
                    }
                }
            }
            return false;
        }

        public Navigable getProjectSettingsRunnerNavigable() {
            return null;
        }

        public void setProjectSettingsRunnerNavigable(Navigable navigable) {
        }

        public void addRunConfigurationLaunchNavigable(Navigable navigable) {
            RunManager.ra$runConfigurationLaunchNavigables().add(navigable);
        }

        public Navigable[] getRunConfigurationLaunchNavigables() {
            return RunManager.ra$runConfigurationLaunchNavigables().toArray(new Navigable[RunManager.ra$runConfigurationLaunchNavigables().size()]);
        }

        public void addRunConfigurationToolNavigable(Navigable navigable) {
            RunManager.ra$runConfigurationToolNavigables().add(navigable);
        }

        public Navigable[] getRunConfigurationToolNavigables() {
            return RunManager.ra$runConfigurationToolNavigables().toArray(new Navigable[RunManager.ra$runConfigurationToolNavigables().size()]);
        }

        private RunnerImpl() {
        }

        RunnerImpl(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

