/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.runner;

import java.util.EventObject;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTree;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.explorer.TNode;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.runner.RunProcess;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ideimpl.resource.RunMgrArb;
import oracle.ideimpl.runner.RunManager;
import oracle.ideri.navigator.DefaultNavigatorWindow;

public final class RunManagerWindow
extends DefaultNavigatorWindow {
    private RunManager runManager;
    static final String RUN_MANAGER_WINDOW_ID = "RunManagerWindow";
    private static Icon runManagerTabIcon = null;

    RunManagerWindow(Context context, RunManager runManager) {
        super(context, RUN_MANAGER_WINDOW_ID);
        this.runManager = runManager;
        this.setTitle(RunMgrArb.getString(5));
        this.getGUI();
    }

    private void setProjectInContext(Context context) {
        Element[] elementArray = context.getSelection();
        Element element = elementArray != null && elementArray.length > 0 ? elementArray[elementArray.length - 1] : null;
        if (element instanceof RunProcess) {
            RunProcess runProcess = (RunProcess)element;
            Context context2 = runProcess.getContext();
            Workspace workspace = context2.getWorkspace();
            Project project = context2.getProject();
            Workspaces workspaces = Ide.getWorkspaces();
            List list = workspaces.getListOfChildren();
            if (list != null && list.contains(workspace)) {
                context.setWorkspace(workspace);
                if (workspace.containsChild(project)) {
                    context.setProject(project);
                }
            }
        } else {
            context.setWorkspace(Ide.getActiveWorkspace());
            context.setProject(Ide.getActiveProject());
        }
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_runmanagerwindow_html");
    }

    public Context getContext(EventObject eventObject) {
        Context context = super.getContext(eventObject);
        this.setProjectInContext(context);
        return context;
    }

    public Icon getTabIcon() {
        if (runManagerTabIcon == null) {
            runManagerTabIcon = RunMgrArb.getIcon(4);
        }
        return runManagerTabIcon;
    }

    protected boolean coalesceTreeExplorerUpdates() {
        return false;
    }

    protected boolean canFireViewSelectionChanged(ViewSelectionEvent viewSelectionEvent) {
        return true;
    }

    boolean selectProcess(RunProcess runProcess) {
        TNode tNode = this.findProcessesTNode();
        int n = tNode.getChildCount() - 1;
        while (n >= 0) {
            TNode tNode2 = (TNode)tNode.getChildAt(n);
            if (tNode2.getData() == runProcess) {
                this.setSelected(tNode2);
                return true;
            }
            --n;
        }
        return false;
    }

    private TNode findProcessesTNode() {
        JTree jTree = this.getTree();
        TNode tNode = (TNode)jTree.getModel().getRoot();
        Element element = tNode.getData();
        if (element == this.runManager) {
            Folder folder = RunManager.runner.getProcessesFolder();
            int n = tNode.getChildCount() - 1;
            while (n >= 0) {
                TNode tNode2 = (TNode)tNode.getChildAt(n);
                if (tNode2.getData() == folder) {
                    return tNode2;
                }
                --n;
            }
        }
        return null;
    }
}

