/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.runner;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.log.MessagePage;
import oracle.ide.runner.RunProcessListener;
import oracle.ide.runner.SimpleProcess;

public final class TestSimpleProcessExec
implements Controller {
    private static final int RUN_SIMPLE_EXEC_1_CMD_ID = Ide.findOrCreateCmdID("RunSimpleExec1Command");
    private static final int RUN_SIMPLE_EXEC_2_CMD_ID = Ide.findOrCreateCmdID("RunSimpleExec2Command");
    private static final int RUN_SIMPLE_EXECANDWAIT_1_CMD_ID = Ide.findOrCreateCmdID("RunSimpleExecAndWait1Command");
    private static final int RUN_SIMPLE_EXECANDWAIT_2_CMD_ID = Ide.findOrCreateCmdID("RunSimpleExecAndWait2Command");

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == RUN_SIMPLE_EXEC_1_CMD_ID) {
            String[] stringArray = new String[]{Ide.getOracleHomeDirectory() + "\\jdk\\bin\\javap"};
            SimpleProcess simpleProcess = new SimpleProcess(stringArray);
            simpleProcess.setLabel("exec 1");
            simpleProcess.setCommandStringForLog("javap oh yeah!!!");
            new 1TestSimpleProcessOutputThread("output 1", simpleProcess.duplicateOutputStream()).start();
            new 1TestSimpleProcessOutputThread("output 2", simpleProcess.duplicateOutputStream()).start();
            new 1TestSimpleProcessOutputThread("error 1", simpleProcess.duplicateErrorStream()).start();
            new 1TestSimpleProcessOutputThread("error 2", simpleProcess.duplicateErrorStream()).start();
            System.out.println("exec 1 - before exec");
            simpleProcess.exec();
            System.out.println("exec 1 - after  exec");
            return true;
        }
        if (n == RUN_SIMPLE_EXEC_2_CMD_ID) {
            3 var6_6 = new 3();
            var6_6.start();
            return true;
        }
        if (n == RUN_SIMPLE_EXECANDWAIT_1_CMD_ID) {
            MessagePage messagePage = new MessagePage();
            String[] stringArray = new String[]{Ide.getOracleHomeDirectory() + "\\jdk\\bin\\javap"};
            SimpleProcess simpleProcess = new SimpleProcess(stringArray);
            simpleProcess.setLabel("execAndWait 1A");
            simpleProcess.setLogPage(messagePage);
            simpleProcess.setRunProcessListener(new 2(this, messagePage));
            System.out.println("execAndWait 1A - before execAndWait");
            int n2 = simpleProcess.execAndWait();
            System.out.println("execAndWait 1A - after  execAndWait result is " + n2);
            return true;
        }
        if (n == RUN_SIMPLE_EXECANDWAIT_2_CMD_ID) {
            1 var11_11 = new 1();
            var11_11.start();
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        return n == RUN_SIMPLE_EXEC_1_CMD_ID || n == RUN_SIMPLE_EXEC_2_CMD_ID || n == RUN_SIMPLE_EXECANDWAIT_1_CMD_ID || n == RUN_SIMPLE_EXECANDWAIT_2_CMD_ID;
    }

    void addMenus(JMenu jMenu) {
        Menubar menubar = Ide.getMenubar();
        IdeAction ideAction = IdeAction.get(RUN_SIMPLE_EXEC_1_CMD_ID, null, "SimpleProcess.exec on event thread", null, null, null, null, true);
        ideAction.addController(this);
        JMenuItem jMenuItem = menubar.createMenuItem(ideAction);
        jMenu.add(jMenuItem);
        ideAction = IdeAction.get(RUN_SIMPLE_EXEC_2_CMD_ID, null, "SimpleProcess.exec on other thread", null, null, null, null, true);
        ideAction.addController(this);
        jMenuItem = menubar.createMenuItem(ideAction);
        jMenu.add(jMenuItem);
        ideAction = IdeAction.get(RUN_SIMPLE_EXECANDWAIT_1_CMD_ID, null, "SimpleProcess.execAndWait on event thread", null, null, null, null, true);
        ideAction.addController(this);
        jMenuItem = menubar.createMenuItem(ideAction);
        jMenu.add(jMenuItem);
        ideAction = IdeAction.get(RUN_SIMPLE_EXECANDWAIT_2_CMD_ID, null, "SimpleProcess.execAndWait on other thread", null, null, null, null, true);
        ideAction.addController(this);
        jMenuItem = menubar.createMenuItem(ideAction);
        jMenu.add(jMenuItem);
    }

    public class 1TestSimpleProcessOutputThread
    extends Thread {
        private PipedInputStream pis;

        1TestSimpleProcessOutputThread(String string, PipedInputStream pipedInputStream) {
            super(string);
            this.pis = pipedInputStream;
        }

        public void run() {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.pis));
            while (true) {
                try {
                    String string = bufferedReader.readLine();
                    if (string == null) {
                        System.out.println(this.getName() + " - readLine returned null");
                        return;
                    }
                    System.out.println(this.getName() + " [" + string + "]");
                }
                catch (Exception exception) {
                }
            }
        }
    }

    public final class 3
    extends Thread {
        public void run() {
            String[] stringArray = new String[]{Ide.getOracleHomeDirectory() + "\\jdk\\bin\\javap"};
            SimpleProcess simpleProcess = new SimpleProcess(stringArray);
            simpleProcess.setLabel("exec 2");
            simpleProcess.setCommandStringForLog("javap oh yeah!!!");
            System.out.println("exec 2 - before exec");
            simpleProcess.exec();
            System.out.println("exec 2 - after  exec");
        }
    }

    public final class 2
    implements RunProcessListener {
        private final /* synthetic */ MessagePage v$page;
        final /* synthetic */ TestSimpleProcessExec this$0;

        public void processFinished(int n) {
            System.out.println("execAndWait 1A - processFinished exitCode is " + n);
            String[] stringArray = new String[]{Ide.getOracleHomeDirectory() + "\\jdk\\bin\\java"};
            SimpleProcess simpleProcess = new SimpleProcess(stringArray);
            simpleProcess.setLabel("execAndWait 1B");
            simpleProcess.setLogPage(this.v$page);
            System.out.println("execAndWait 1B - before execAndWait");
            int n2 = simpleProcess.execAndWait();
            System.out.println("execAndWait 1B - after  execAndWait result is " + n2);
        }

        public 2(TestSimpleProcessExec testSimpleProcessExec, MessagePage messagePage) {
            this.v$page = messagePage;
            this.this$0 = testSimpleProcessExec;
        }
    }

    public final class 1
    extends Thread {
        public void run() {
            MessagePage messagePage = new MessagePage();
            String[] stringArray = new String[]{Ide.getOracleHomeDirectory() + "\\jdk\\bin\\javap"};
            SimpleProcess simpleProcess = new SimpleProcess(stringArray);
            simpleProcess.setLabel("execAndWait 2A");
            simpleProcess.setLogPage(messagePage);
            System.out.println("execAndWait 2A - before execAndWait");
            int n = simpleProcess.execAndWait();
            System.out.println("execAndWait 2A - after  execAndWait result is " + n);
            String[] stringArray2 = new String[]{Ide.getOracleHomeDirectory() + "\\jdk\\bin\\java"};
            SimpleProcess simpleProcess2 = new SimpleProcess(stringArray2);
            simpleProcess2.setLabel("execAndWait 2B");
            simpleProcess2.setLogPage(messagePage);
            System.out.println("execAndWait 2B - before execAndWait");
            n = simpleProcess2.execAndWait();
            System.out.println("execAndWait 2B - after  execAndWait result is " + n);
        }
    }
}

