/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.shell;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.ide.config.FileAssociations;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.resource.ShellArb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigureFileAssociationsDialog
extends JPanel {
    private JLabel lblTitle;
    private JCheckBox[] chkArray;
    private JLabel lblHelp;
    private GridBagLayout mainLayout;
    public boolean ok;

    void $init$() {
        this.lblTitle = new JLabel();
        this.chkArray = null;
        this.lblHelp = new JLabel();
        this.mainLayout = new GridBagLayout();
        this.ok = false;
    }

    public ConfigureFileAssociationsDialog(String string, ArrayList<String> arrayList, ArrayList<String> arrayList2) {
        this.$init$();
        try {
            if (string == null || arrayList == null || arrayList.size() == 0) {
                return;
            }
            this.jbInit(string, arrayList2);
            this.loadData(arrayList);
            HelpUtils.setHelpID((JComponent)this, (String)"f1_idedconfigurefiletypeassociations_html");
            JEWTDialog jEWTDialog = null;
            jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog(this, this.chkArray[0], ShellArb.format(0, string), 7);
            jEWTDialog.setResizable(true);
            Dimension dimension = this.getPreferredSize();
            dimension.width = Math.min(600, dimension.width);
            this.setPreferredSize(dimension);
            this.ok = WizardLauncher.runDialog((JDialog)jEWTDialog);
            if (this.ok) {
                this.saveData(arrayList);
            }
            jEWTDialog = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void readAssociations(ArrayList<String> arrayList) {
        int n = 0;
        while (n < arrayList.size()) {
            if (FileAssociations.isAssociated(arrayList.get(n))) {
                this.chkArray[n].setSelected(true);
            }
            ++n;
        }
    }

    private void loadData(ArrayList<String> arrayList) {
        int n = 0;
        while (n < arrayList.size()) {
            this.chkArray[n].setSelected(false);
            ++n;
        }
        this.readAssociations(arrayList);
    }

    private void saveData(ArrayList<String> arrayList) {
        int n = 0;
        while (n < arrayList.size()) {
            if (this.chkArray[n].isSelected()) {
                FileAssociations.setAssociated(arrayList.get(n), true);
            }
            ++n;
        }
    }

    private void jbInit(String string, ArrayList<String> arrayList) throws Exception {
        ResourceUtils.resLabel(this.lblTitle, null, ShellArb.format(2, string));
        ResourceUtils.resLabel(this.lblHelp, null, ShellArb.getString(3));
        this.chkArray = new JCheckBox[arrayList.size()];
        int n = 0;
        while (n < arrayList.size()) {
            this.chkArray[n] = new JCheckBox();
            ResourceUtils.resButton(this.chkArray[n], arrayList.get(n));
            ++n;
        }
        this.setLayout(this.mainLayout);
        this.add((Component)this.lblTitle, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 0), 0, 0));
        int n2 = 0;
        while (n2 < this.chkArray.length) {
            double d = n2 + 1 >= this.chkArray.length ? 1.0 : 0.0;
            this.add((Component)this.chkArray[n2], new GridBagConstraints(0, n2 + 2, 1, 1, d, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            ++n2;
        }
    }
}

