/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.shell;

import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.IdeMainWindow;
import oracle.ide.cmd.OpenCommand;
import oracle.ide.config.FileAssociations;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.natives.registry.Registry;
import oracle.ide.natives.registry.RegistryException;
import oracle.ide.natives.registry.RegistryKey;
import oracle.ide.net.URLFactory;
import oracle.ideimpl.ProductHook;
import oracle.ideimpl.ProductInformation;
import oracle.ideimpl.shell.ConfigureFileAssociationsDialog;
import oracle.javatools.data.HashStructure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShellIntegration
implements Addin {
    private static final String OPEN_COMMAND = "Open\\(\\(?\"(.*)\"\\)\\)?";
    private static boolean isMainWindowOpen;
    private static LinkedList commandQueue;
    private static Registry registry;

    static {
        commandQueue = new LinkedList();
    }

    public static void runCommand(String string) {
        SwingUtilities.invokeLater(new 2(string));
    }

    @Override
    public void initialize() {
        if (Ide.getIdeArgs().getCreateUI() && System.getProperty("ide.shell.enableFileTypeAssociation") != null) {
            Ide.addIdeListener(new 1());
        }
    }

    public boolean canShutdown() {
        return true;
    }

    private void showConfigurationDialog(String string, ArrayList<String> arrayList, ArrayList<String> arrayList2) {
        if (System.getProperty("ide.shell.enableFileTypeAssociation") != null && ShellIntegration.getCurrentUserKey() != null && string != null && !this.isFileTypeDefined(string, arrayList.get(0))) {
            this.addFileTypeKeys(string, arrayList);
            new ConfigureFileAssociationsDialog(string, arrayList, arrayList2);
        }
    }

    private boolean isFileTypeDefined(String string, String string2) {
        String string3 = string + string2 + "File";
        try {
            RegistryKey registryKey = registry.getClassesRootKey();
            RegistryKey registryKey2 = registryKey.openKey(string3, 983103L);
            if (registryKey2 != null) {
                registryKey2.close();
                boolean bl = true;
                return bl;
            }
        }
        catch (RegistryException registryException) {
            // empty catch block
        }
        return false;
    }

    private void addFileTypeKeys(String string, ArrayList<String> arrayList) {
        String string2 = "\"" + FileAssociations.getExePathName() + "\"" + " \"%1\"";
        try {
            RegistryKey registryKey = registry.getLocalMachineKey();
            RegistryKey registryKey2 = registry.getClassesRootKey();
            int n = 0;
            while (n < arrayList.size()) {
                String string3 = "SOFTWARE\\Classes\\";
                String string4 = string + arrayList.get(n) + "File\\Shell\\Open\\Command";
                RegistryKey registryKey3 = registryKey.createKey(string3 + string4, false, 131078L);
                if (registryKey3 != null) {
                    registryKey3.setExpandedStringValue("", string2);
                    registryKey3.close();
                }
                if ((registryKey3 = registryKey2.createKey(string4, false, 131078L)) != null) {
                    registryKey3.setExpandedStringValue("", string2);
                    registryKey3.close();
                }
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void shutdown() {
    }

    private static RegistryKey getCurrentUserKey() {
        try {
            registry = new Registry();
            RegistryKey registryKey = registry.getCurrentUserKey();
            return registryKey;
        }
        catch (Exception exception) {
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        return null;
    }

    private void processQueue() {
        isMainWindowOpen = true;
        for (String string : commandQueue) {
            ShellIntegration.processCommand(string);
        }
        commandQueue.clear();
    }

    private static void processCommand(String string) {
        Pattern pattern = Pattern.compile(OPEN_COMMAND);
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            ShellIntegration.openFile(matcher.group(1));
        }
    }

    private static void openFile(String string) {
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        int n = ideMainWindow.getExtendedState();
        if ((n & 1) != 0) {
            ideMainWindow.setExtendedState(n & 0xFFFFFFFE);
        }
        ideMainWindow.toFront();
        URL uRL = URLFactory.newFileURL(string);
        try {
            Node node = NodeFactory.findOrCreate(uRL);
            OpenCommand openCommand = new OpenCommand();
            openCommand.setContext(Context.newIdeContext(node));
            openCommand.openURL(uRL);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static boolean ra$isMainWindowOpen() {
        return isMainWindowOpen;
    }

    static void maS$processCommand(String string) {
        ShellIntegration.processCommand(string);
    }

    static LinkedList ra$commandQueue() {
        return commandQueue;
    }

    static void mav$showConfigurationDialog(ShellIntegration shellIntegration, String string, ArrayList arrayList, ArrayList arrayList2) {
        shellIntegration.showConfigurationDialog(string, arrayList, arrayList2);
    }

    static void mav$processQueue(ShellIntegration shellIntegration) {
        shellIntegration.processQueue();
    }

    public static final class 2
    implements Runnable {
        private final /* synthetic */ String v$command;

        public void run() {
            if (ShellIntegration.ra$isMainWindowOpen()) {
                ShellIntegration.maS$processCommand(this.v$command);
            } else {
                ShellIntegration.ra$commandQueue().add(this.v$command);
            }
        }

        public 2(String string) {
            this.v$command = string;
        }
    }

    public final class 1
    implements IdeListener {
        public void addinsLoaded(IdeEvent ideEvent) {
        }

        public void mainWindowOpened(IdeEvent ideEvent) {
            ProductHook productHook = (ProductHook)ExtensionRegistry.getExtensionRegistry().getHook(ProductHook.NAME);
            ProductInformation productInformation = productHook.getProductInformation();
            String string = productInformation.getShortName();
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            List list = productInformation.getFileAssociations();
            if (list != null && list.size() > 0) {
                for (HashStructure hashStructure : list) {
                    arrayList.add(hashStructure.getString("suffix"));
                    arrayList2.add(hashStructure.getString("label"));
                }
            }
            if (arrayList.size() > 0) {
                ShellIntegration.mav$showConfigurationDialog(ShellIntegration.this, string, arrayList, arrayList2);
            }
            ShellIntegration.mav$processQueue(ShellIntegration.this);
        }

        public void mainWindowClosing(IdeEvent ideEvent) {
        }
    }
}

