/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.util;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.net.URL;
import java.util.List;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.EditorUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.util.BitField;

public final class DropFileUtil {
    private static DropTargetListener defaultDropFileListener;

    private DropFileUtil() {
    }

    public static DropTargetListener getDefaultDropFileListener() {
        if (defaultDropFileListener == null) {
            defaultDropFileListener = new DropFileListener();
        }
        return defaultDropFileListener;
    }

    public static boolean canDrop(DropTargetDragEvent dropTargetDragEvent) {
        int n = dropTargetDragEvent.getDropAction();
        boolean bl = BitField.isSet(n, 1) || BitField.isSet(n, 2);
        return bl && dropTargetDragEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
    }

    public static boolean drop(DropTargetDropEvent dropTargetDropEvent) {
        boolean bl = false;
        try {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            if (dropTargetDropEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                EditorManager editorManager = EditorManager.getEditorManager();
                dropTargetDropEvent.acceptDrop(3);
                List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                for (File file : list) {
                    bl &= DropFileUtil.drop(editorManager, file);
                }
                dropTargetDropEvent.getDropTargetContext().dropComplete(true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    private static boolean drop(EditorManager editorManager, File file) {
        boolean bl = true;
        if (file.isFile()) {
            URL uRL = URLFactory.newFileURL(file);
            Editor editor = EditorUtil.openDefaultEditorInFrame(uRL);
            if (editor == null) {
                bl = false;
            } else {
                EditorManager.getEditorManager().setExplicit(editor, true);
            }
        } else {
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                bl &= DropFileUtil.drop(editorManager, fileArray[n]);
                ++n;
            }
        }
        return bl;
    }

    public static class DropFileListener
    implements DropTargetListener {
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            this.handleDropTargetDragEvent(dropTargetDragEvent);
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            this.handleDropTargetDragEvent(dropTargetDragEvent);
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            this.handleDropTargetDragEvent(dropTargetDragEvent);
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            DropFileUtil.drop(dropTargetDropEvent);
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        private void handleDropTargetDragEvent(DropTargetDragEvent dropTargetDragEvent) {
            if (DropFileUtil.canDrop(dropTargetDragEvent)) {
                dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }
    }
}

