/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.util;

import java.io.File;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import oracle.ide.net.URLFileSystem;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PresetKeystrokeContextUtil {
    private static String PRESET_TAG = "preset";
    private static String CONTEXT_TAG = "context";
    private static String NAME_TAG = "name";
    private static String MAP_TAG = "map";
    private static String ACTION_TAG = "action";

    private PresetKeystrokeContextUtil() {
    }

    public static void usage() {
        System.out.println("Preset keystroke loader version 9i");
        System.out.println("Usage:  PresetKeystrokeContextUtil <???.kdf file> <preset entry xml file>");
        System.out.println("");
        System.exit(0);
    }

    private static Document getDocument(URL uRL) throws Exception {
        XMLDocument xMLDocument;
        try {
            DOMParser dOMParser = new DOMParser();
            dOMParser.setPreserveWhitespace(false);
            dOMParser.parse(uRL);
            xMLDocument = dOMParser.getDocument();
        }
        catch (Exception exception) {
            System.out.println("Unable to parse or locate " + uRL.getPath());
            throw exception;
        }
        return xMLDocument;
    }

    private static Element getContextNamed(NodeList nodeList, String string) {
        if (string != null) {
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                String string2 = PresetKeystrokeContextUtil.getName((Element)nodeList.item(n2));
                if (string2 != null && string2.equals(string)) {
                    return (Element)nodeList.item(n2);
                }
                ++n2;
            }
        }
        return null;
    }

    private static Element getMapForAction(NodeList nodeList, String string) {
        if (string != null) {
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                String string2 = PresetKeystrokeContextUtil.getAction((Element)nodeList.item(n2));
                if (string2 != null && string2.equals(string)) {
                    return (Element)nodeList.item(n2);
                }
                ++n2;
            }
        }
        return null;
    }

    private static String getAction(Element element) {
        return element.getAttribute(ACTION_TAG);
    }

    private static String getName(Element element) {
        return element.getAttribute(NAME_TAG);
    }

    private static void loadAndMergeItems(URL uRL, URL uRL2) throws Exception {
        Document document = PresetKeystrokeContextUtil.getDocument(uRL);
        Document document2 = PresetKeystrokeContextUtil.getDocument(uRL2);
        NodeList nodeList = document2.getElementsByTagName(CONTEXT_TAG);
        if (nodeList == null) {
            System.out.println("No context element in " + uRL2.getPath());
            return;
        }
        NodeList nodeList2 = document.getElementsByTagName(CONTEXT_TAG);
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Element element = (Element)nodeList.item(n2);
            String string = PresetKeystrokeContextUtil.getName(element);
            Element element2 = PresetKeystrokeContextUtil.getContextNamed(nodeList2, string);
            if (element2 == null) {
                Node node = ((XMLDocument)document).adoptNode((Node)element);
                NodeList nodeList3 = document.getElementsByTagName(PRESET_TAG);
                nodeList3.item(0).appendChild(node);
            } else {
                NodeList nodeList4 = element2.getElementsByTagName(MAP_TAG);
                NodeList nodeList5 = element.getElementsByTagName(MAP_TAG);
                int n3 = nodeList5.getLength();
                if (n3 > 0) {
                    if (nodeList4.getLength() > 0) {
                        int n4 = 0;
                        while (n4 < n3) {
                            Element element3 = (Element)nodeList5.item(n4);
                            Element element4 = PresetKeystrokeContextUtil.getMapForAction(nodeList4, PresetKeystrokeContextUtil.getAction(element3));
                            if (element4 == null) {
                                Node node = ((XMLDocument)document).adoptNode((Node)element3);
                                element2.appendChild(node);
                            }
                            ++n4;
                        }
                    } else {
                        int n5 = 0;
                        while (n5 < n3) {
                            Element element5 = (Element)nodeList5.item(n5);
                            Node node = ((XMLDocument)document).adoptNode((Node)element5);
                            element2.appendChild(node);
                            ++n5;
                        }
                    }
                }
            }
            ++n2;
        }
        ((XMLDocument)document).print(new PrintWriter(URLFileSystem.openOutputStream(uRL)));
    }

    private static URL getFileURL(String string) {
        URL uRL = null;
        File file = new File(string);
        if (file.exists()) {
            try {
                uRL = file.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println("ERROR: URL [" + uRL.toString() + "] is not valid");
            }
        } else {
            System.err.println("ERROR: File [" + string + "] does not exist");
        }
        return uRL;
    }

    private static void abort(String string) {
        System.err.println("ERROR: " + string);
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            PresetKeystrokeContextUtil.usage();
        }
        URL uRL = PresetKeystrokeContextUtil.getFileURL(stringArray[0]);
        URL uRL2 = PresetKeystrokeContextUtil.getFileURL(stringArray[1]);
        if (uRL2 == null || uRL == null) {
            PresetKeystrokeContextUtil.abort("Invalid Command Line Arguments Given");
            PresetKeystrokeContextUtil.usage();
        }
        try {
            PresetKeystrokeContextUtil.loadAndMergeItems(uRL, uRL2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.exit(0);
    }
}

