/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.viewers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.IOException;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.border.Border;
import oracle.ide.Context;
import oracle.ide.controls.ThinBevel;
import oracle.ide.editor.Editor;
import oracle.ide.model.Element;
import oracle.ide.model.ImageNode;
import oracle.ide.model.UpdateMessage;
import oracle.ideimpl.resource.ViewersArb;
import oracle.javatools.editor.plugins.StatusBarPlugin;

public class ImageViewer
extends Editor {
    private static final Border THIN_BEVEL_BORDER = BorderFactory.createCompoundBorder(new ThinBevel(1), StatusBarPlugin.EMPTY_BORDER);
    private JPanel mainPanel;
    private ImageNode imageNode;

    public void setContext(Context context) {
        if (context == null) {
            this.imageNode = null;
            return;
        }
        Element element = context.getElement();
        if (!(element instanceof ImageNode)) {
            this.imageNode = null;
            return;
        }
        this.imageNode = (ImageNode)element;
        super.setContext(context);
    }

    public Object getEditorAttribute(String string) {
        if (string == "old_editor") {
            return Boolean.TRUE;
        }
        return super.getEditorAttribute(string);
    }

    public void open() {
        if (this.imageNode == null) {
            return;
        }
        try {
            this.imageNode.open();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void update(Object object, UpdateMessage updateMessage) {
    }

    public void close() {
        super.close();
        this.mainPanel = null;
        this.imageNode = null;
    }

    public Component getGUI() {
        return this.createGUI();
    }

    private Component createGUI() {
        if (this.mainPanel != null) {
            return this.mainPanel;
        }
        Image image = this.imageNode != null ? this.imageNode.getImage() : null;
        ImageIcon imageIcon = image != null ? new ImageIcon(image) : null;
        ScrollableImage scrollableImage = new ScrollableImage(imageIcon);
        AccessibleContext accessibleContext = scrollableImage.getAccessibleContext();
        if (accessibleContext != null) {
            accessibleContext.setAccessibleName(ViewersArb.getString(4));
        }
        scrollableImage.setBorder(BorderFactory.createLineBorder(Color.red));
        JScrollPane jScrollPane = new JScrollPane(scrollableImage);
        jScrollPane.setBorder(Editor.CUSTOM_BORDER);
        jScrollPane.setViewportBorder(null);
        jScrollPane.getViewport().setBackground(Color.white);
        String string = imageIcon != null ? ViewersArb.format(3, new Integer(imageIcon.getIconWidth()), new Integer(imageIcon.getIconHeight())) : null;
        JLabel jLabel = new JLabel(string);
        jLabel.setBorder(THIN_BEVEL_BORDER);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jLabel, "Center");
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add((Component)jScrollPane, "Center");
        this.mainPanel.add((Component)jPanel, "South");
        return this.mainPanel;
    }

    private static final class ScrollableImage
    extends JLabel
    implements Scrollable {
        private final int unitIncrement;

        void $init$() {
            this.unitIncrement = 16;
        }

        ScrollableImage(Icon icon) {
            super(icon);
            this.$init$();
        }

        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            int n3 = n == 0 ? rectangle.x : rectangle.y;
            if (n2 < 0) {
                int n4 = n3 - n3 / 16 * 16;
                return n4 == 0 ? 16 : n4;
            }
            return (n3 / 16 + 1) * 16 - n3;
        }

        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            if (n == 0) {
                return rectangle.width - 16;
            }
            return rectangle.height - 16;
        }

        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }
}

