/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webbrowser;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.resource.IdeImplArb;

final class AuthenticationPrompt
extends JPanel {
    private final MultiLineLabel hintLabel;
    private final JLabel userNameLabel;
    private final JLabel passwordLabel;
    private final JTextField userNameField;
    private final JPasswordField passwordField;
    private String host;
    private int port;
    private String protocol;
    private String prompt;
    private static final String HELP_ID = "f1_idedauthentication_html";

    void $init$() {
        this.hintLabel = new MultiLineLabel();
        this.userNameLabel = new JLabel();
        this.passwordLabel = new JLabel();
        this.userNameField = new JTextField(20);
        this.passwordField = new JPasswordField(20);
    }

    public AuthenticationPrompt(String string, int n, String string2, String string3) {
        this.$init$();
        this.host = string;
        this.port = n;
        this.protocol = string2;
        this.prompt = string3;
        this.jbInit();
    }

    public String getUserName() {
        return this.userNameField.getText();
    }

    public char[] getPassword() {
        return this.passwordField.getPassword();
    }

    public boolean runDialog(Component component) {
        int n;
        HelpSystem helpSystem = HelpSystem.getHelpSystem();
        if (helpSystem != null) {
            n = 7;
            helpSystem.registerTopic(this, HELP_ID);
        } else {
            n = 3;
        }
        JEWTDialog jEWTDialog = JEWTDialog.createDialog((Component)component, (String)IdeImplArb.getString(75), (int)n);
        jEWTDialog.setContent((Component)this);
        return jEWTDialog.runDialog();
    }

    private void jbInit() {
        String string;
        ResourceUtils.resLabel(this.userNameLabel, this.userNameField, IdeImplArb.getString(78));
        ResourceUtils.resLabel(this.passwordLabel, this.passwordField, IdeImplArb.getString(79));
        if (this.prompt != null && this.prompt.trim().length() > 0) {
            MessageFormat messageFormat = new MessageFormat(IdeImplArb.getString(77));
            string = messageFormat.format(new Object[]{this.prompt.trim(), this.host});
        } else {
            MessageFormat messageFormat = new MessageFormat(IdeImplArb.getString(76));
            string = messageFormat.format(new Object[]{this.host});
        }
        this.hintLabel.setText(string);
        this.hintLabel.setTextWrapper(WordWrapper.getTextWrapper());
        this.hintLabel.setPreferredAspectRatio(12.0f);
        this.hintLabel.setVerticalShrinking(false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 15, 0);
        this.add((Component)this.hintLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 12);
        this.add((Component)this.userNameLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.userNameField, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.passwordLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.passwordField, gridBagConstraints);
    }
}

